/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schema;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceInfo;
import io.konig.core.NamespaceInfoManager;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.OwlVocab;
import io.konig.core.vocab.Schema;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class EnumerationReasoner {
    private Map<String, Set<URI>> individualByName;

    public void mapIndividualsByName(Graph graph) {
        this.individualByName = new HashMap<String, Set<URI>>();
        OwlReasoner owl = new OwlReasoner(graph);
        for (Vertex v : graph.vertices()) {
            Value value;
            Resource id = v.getId();
            if (!(id instanceof URI) || !owl.instanceOf(id, Schema.Enumeration) && !owl.instanceOf(id, OwlVocab.NamedIndividual) || (value = v.getValue(Schema.name)) == null) continue;
            String name = value.stringValue();
            Set<URI> set = this.individualByName.get(name);
            if (set == null) {
                set = new HashSet<URI>();
                this.individualByName.put(name, set);
            }
            set.add((URI)id);
        }
    }

    public Set<URI> getIndividualsByName(String name) {
        if (this.individualByName == null) {
            throw new KonigException("The method `mapIndividualsByName` must be invoked before calling `getIndividualsByName`");
        }
        Set<Object> result = this.individualByName.get(name);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public void annotateEnumerationNamespaces(Graph graph, NamespaceInfoManager nim) {
        OwlReasoner reasoner = new OwlReasoner(graph);
        block0: for (NamespaceInfo ns : nim.listNamespaces()) {
            block1: for (URI term : ns.getTerms()) {
                Resource id;
                Vertex v = graph.getVertex((Resource)term);
                if (v == null || !((id = v.getId()) instanceof URI) || reasoner.isSubClassOf(id, (Resource)Schema.Enumeration) || id.stringValue().equals(ns.getNamespaceIri())) continue;
                Set<Edge> typeSet = v.outProperty(RDF.TYPE);
                for (Edge e : typeSet) {
                    URI typeId;
                    Value value = e.getObject();
                    if (!(value instanceof URI) || !OwlVocab.NamedIndividual.equals((Object)(typeId = (URI)value)) && !reasoner.isSubClassOf((Resource)typeId, (Resource)Schema.Enumeration)) continue;
                    continue block1;
                }
                continue block0;
            }
            ns.getType().add(Konig.EnumNamespace);
        }
    }
}

