/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.annotation.RdfList;
import io.konig.core.Vertex;
import io.konig.shacl.Constraint;
import io.konig.shacl.GraphFilter;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeConsumer;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.URI;

@RdfList
public class AndConstraint
implements Constraint,
ShapeConsumer {
    private Shape declaringShape;
    private List<Shape> shapes = new ArrayList<Shape>();

    @Override
    public List<Shape> getShapes() {
        return this.shapes;
    }

    @Override
    public AndConstraint add(Shape shape) {
        if (!this.shapes.contains(shape)) {
            this.shapes.add(shape);
        }
        return this;
    }

    @Override
    public boolean accept(Vertex v) {
        GraphFilter filter = GraphFilter.INSTANCE;
        for (Shape s : this.shapes) {
            if (filter.matches(v, s)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPropertyConstraint(URI predicate) {
        for (Shape s : this.shapes) {
            if (!s.hasPropertyConstraint(predicate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Shape findShapeByTargetClass(URI targetClass) {
        for (Shape s : this.shapes) {
            if (!targetClass.equals((Object)s.getTargetClass())) continue;
            return s;
        }
        return null;
    }

    @Override
    public Shape getDeclaringShape() {
        return this.declaringShape;
    }

    public void setDeclaringShape(Shape s) {
        this.declaringShape = s;
    }
}

