/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.OwlReasoner;
import io.konig.core.Path;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.util.SimpleValueMap;
import io.konig.core.util.ValueFormat;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.OwlVocab;
import io.konig.core.vocab.Schema;
import io.konig.shacl.AndConstraint;
import io.konig.shacl.NodeKind;
import io.konig.shacl.OrConstraint;
import io.konig.shacl.OwlClassNotFoundException;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.PropertyStructure;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassStructure {
    private static final Logger logger = LoggerFactory.getLogger(ClassStructure.class);
    private static final Integer ZERO = new Integer(0);
    private Map<Resource, Shape> shapeMap = new HashMap<Resource, Shape>();
    private Map<URI, PropertyStructure> propertyMap = new HashMap<URI, PropertyStructure>();
    private Shape nullShape = new Shape((Resource)Konig.NullShape);
    private ValueFormat iriTemplate;
    private boolean failOnDatatypeConflict = false;
    private OwlReasoner reasoner;

    public ClassStructure() {
    }

    public ClassStructure(ValueFormat iriTemplate) {
        this.iriTemplate = iriTemplate;
    }

    public OwlReasoner getReasoner() {
        return this.reasoner;
    }

    public ClassStructure(ValueFormat iriTemplate, ShapeManager shapeManager, OwlReasoner reasoner) {
        this.iriTemplate = iriTemplate;
        this.init(shapeManager, reasoner);
    }

    public Collection<PropertyStructure> listProperties() {
        return this.propertyMap.values();
    }

    public PropertyStructure getProperty(URI propertyId) {
        return this.propertyMap.get(propertyId);
    }

    public Set<Resource> domainIncludes(URI propertyId) {
        PropertyStructure info = this.propertyMap.get(propertyId);
        if (info == null) {
            throw new KonigException("Property not found: " + propertyId);
        }
        Set<Resource> set = info.getDomainIncludes();
        if (set == null) {
            set = new HashSet<Resource>();
            if (info.getDomain() != null) {
                set.add(info.getDomain());
            }
        }
        return set;
    }

    public Collection<Shape> listClassShapes() {
        return this.shapeMap.values();
    }

    public Set<Resource> listClasses() {
        return this.shapeMap.keySet();
    }

    public void init(ShapeManager shapeManager, OwlReasoner reasoner) {
        if (reasoner != null && reasoner.getGraph() != null && reasoner.getGraph().getNamespaceManager() != null) {
            reasoner.getGraph().getNamespaceManager().add("owl", "http://www.w3.org/2002/07/owl#");
        }
        Builder builder = new Builder(shapeManager, reasoner);
        builder.build();
    }

    public Shape getShapeForClass(Resource classId) throws OwlClassNotFoundException {
        Shape result = this.shapeForClass(classId);
        if (result == null) {
            throw new OwlClassNotFoundException(classId);
        }
        return result;
    }

    public Shape shapeForClass(Resource classId) {
        if (classId == null) {
            throw new IllegalArgumentException("classId cannot be null");
        }
        if (classId.equals(Schema.Thing)) {
            classId = OWL.THING;
        }
        Shape result = this.shapeMap.get(classId);
        return result;
    }

    public boolean isNullShape(Shape shape) {
        return Konig.NullShape.equals((Object)shape.getId());
    }

    public boolean hasSubClass(Shape shape) {
        OrConstraint or = shape.getOr();
        return or != null && !or.getShapes().isEmpty();
    }

    public Map<URI, PropertyConstraint> getPropertyMap(Shape shape) {
        HashMap<URI, PropertyConstraint> map = new HashMap<URI, PropertyConstraint>();
        this.addProperties(map, shape);
        return map;
    }

    private void addProperties(Map<URI, PropertyConstraint> map, Shape shape) {
        for (PropertyConstraint p : shape.getProperty()) {
            URI predicate = p.getPredicate();
            if (predicate == null || map.containsKey(predicate)) continue;
            map.put(predicate, p);
        }
        List<Shape> superList = this.superClasses(shape);
        for (Shape s : superList) {
            this.addProperties(map, s);
        }
    }

    public List<PropertyConstraint> getProperties(Shape shape) {
        Map<URI, PropertyConstraint> map = this.getPropertyMap(shape);
        return new ArrayList<PropertyConstraint>(map.values());
    }

    public List<Shape> superClasses(Shape shape) {
        ArrayList<Shape> list = new ArrayList<Shape>();
        this.addSuper(list, shape);
        return list;
    }

    private void addSuper(List<Shape> list, Shape shape) {
        if (this.hasSuperClass(shape)) {
            for (Shape s : shape.getAnd().getShapes()) {
                if (!this.contains(list, s)) {
                    list.add(s);
                }
                this.addSuper(list, s);
            }
        }
    }

    public List<Shape> transitiveClosure(Shape s) {
        List<Shape> list = this.superClasses(s);
        list.addAll(this.subClasses(s));
        list.add(s);
        return list;
    }

    public List<Shape> subClasses(Shape shape) {
        ArrayList<Shape> list = new ArrayList<Shape>();
        this.addSubclassShapes(list, shape);
        return list;
    }

    private void addSubclassShapes(List<Shape> list, Shape shape) {
        OrConstraint or = shape.getOr();
        if (or != null) {
            for (Shape s : or.getShapes()) {
                if (!this.isNullShape(s) && !this.contains(list, s)) {
                    list.add(s);
                }
                this.addSubclassShapes(list, s);
            }
        }
    }

    private boolean contains(List<Shape> list, Shape shape) {
        for (Shape s : list) {
            if (s != shape && !shape.getId().equals(s.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasProperty(Resource owlClass, URI property) {
        Shape shape = this.getShapeForClass(owlClass);
        if (shape == null) {
            throw new KonigException("Class not found: " + owlClass);
        }
        return this.hasProperty(shape, property);
    }

    public boolean hasProperty(Shape canonicalShape, URI property) {
        if (canonicalShape.getPropertyConstraint(property) != null) {
            return true;
        }
        AndConstraint and = canonicalShape.getAnd();
        if (and != null) {
            for (Shape ancestor : and.getShapes()) {
                if (!this.hasProperty(ancestor, property)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean ancestorHasProperty(Resource owlClass, URI property) throws OwlClassNotFoundException {
        Shape shape = this.getShapeForClass(owlClass);
        AndConstraint and = shape.getAnd();
        if (and != null) {
            for (Shape ancestor : and.getShapes()) {
                if (!this.hasProperty(ancestor, property)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSuperClass(Shape shape) {
        List<Shape> list;
        AndConstraint and = shape.getAnd();
        return and != null && ((list = and.getShapes()).size() > 1 || !OWL.THING.equals((Object)list.get(0).getTargetClass()));
    }

    public List<URI> listSubclasses(Shape shape) {
        ArrayList<URI> list = new ArrayList<URI>();
        this.addSubclasses(list, shape);
        return list;
    }

    private void addSubclasses(List<URI> list, Shape shape) {
        if (shape.getOr() != null) {
            for (Shape s : shape.getOr().getShapes()) {
                if (this.nullShape == s) continue;
                URI targetClass = s.getTargetClass();
                list.add(targetClass);
                this.addSubclasses(list, s);
            }
        }
    }

    public Shape getNullShape() {
        return this.nullShape;
    }

    private class Builder {
        private ShapeManager shapeManager;

        public Builder(ShapeManager shapeManager, OwlReasoner reasoner) {
            this.shapeManager = shapeManager;
            ClassStructure.this.reasoner = reasoner;
        }

        private void build() {
            this.scanShapes();
            this.scanProperties();
            this.scanClasses();
            this.buildShapes();
            this.buildHierarchy();
            this.injectThingAndNullShape();
            this.bubbleUp();
            this.bubbleDown();
        }

        private void bubbleDown() {
            for (Shape shape : ClassStructure.this.listClassShapes()) {
                this.bubbleDown(shape);
            }
        }

        private void bubbleDown(Shape shape) {
            for (PropertyConstraint p : shape.getProperty()) {
                this.bubbleDown(shape, p);
            }
        }

        private void bubbleUp() {
            for (Shape shape : ClassStructure.this.listClassShapes()) {
                this.bubbleUp(shape);
            }
        }

        private void bubbleUp(Shape shape) {
            for (PropertyConstraint p : shape.getProperty()) {
                this.bubbleUp(shape, p);
            }
        }

        private void bubbleDown(Shape shape, PropertyConstraint p) {
            URI predicate = p.getPredicate();
            Integer maxCount = p.getMaxCount();
            if (maxCount != null) {
                List<Shape> list = ClassStructure.this.superClasses(shape);
                for (Shape superclass : list) {
                    PropertyConstraint q = superclass.getPropertyConstraint(predicate);
                    if (q == null || q.getMaxCount() != null) continue;
                    p.setMaxCount(null);
                    break;
                }
            }
        }

        private void bubbleUp(Shape shape, PropertyConstraint p) {
            URI predicate = p.getPredicate();
            Integer maxCount = p.getMaxCount();
            if (maxCount != null) {
                List<Shape> list = ClassStructure.this.subClasses(shape);
                for (Shape subClass : list) {
                    PropertyConstraint q = subClass.getPropertyConstraint(predicate);
                    if (q == null || q.getMaxCount() != null) continue;
                    p.setMaxCount(null);
                    break;
                }
            }
        }

        private void scanShapes() {
            Graph graph = ClassStructure.this.reasoner.getGraph();
            for (Shape shape : this.shapeManager.listShapes()) {
                URI targetClass = shape.getTargetClass();
                if (targetClass == null) continue;
                graph.edge((Resource)targetClass, RDF.TYPE, (Value)OWL.CLASS);
                Shape classShape = this.produceShape((Resource)targetClass);
                this.addProperties(shape, classShape);
            }
        }

        private void addProperties(Shape shape, Shape classShape) {
            for (PropertyConstraint source : shape.getProperty()) {
                this.applyGlobalProperty(shape, source);
                URI predicate = source.getPredicate();
                PropertyConstraint target = classShape.getPropertyConstraint(predicate);
                if (target == null) {
                    PropertyConstraint p = source.clone();
                    Shape valueShape = p.getShape();
                    if (valueShape != null) {
                        Resource valueClass = p.getValueClass();
                        if (valueClass == null) {
                            p.setValueClass((Resource)valueShape.getTargetClass());
                        }
                        p.setShape(null);
                    }
                    classShape.add(p);
                    continue;
                }
                this.merge(source, target);
            }
        }

        private void applyGlobalProperty(Shape shape, PropertyConstraint p) {
            URI targetClass = shape.getTargetClass();
            URI predicate = p.getPredicate();
            if (predicate != null) {
                PropertyStructure info = this.produceProperty(predicate);
                info.addShape(shape);
                this.setDomain(info, (Resource)targetClass);
                this.setDatatype(info, p.getDatatype());
                this.setMaxCount(info, p.getMaxCount());
                this.setMinCount(info, p.getMinCount());
                this.setEquivalentPath(info, p.getEquivalentPath());
                this.setValueClass(info, p.getValueClass());
                if (p.getShape() != null) {
                    this.setValueClass(info, (Resource)p.getShape().getTargetClass());
                }
            }
            if (p.getValueClass() instanceof URI) {
                ClassStructure.this.reasoner.getGraph().edge(p.getValueClass(), RDF.TYPE, (Value)OWL.CLASS);
            }
        }

        private void merge(PropertyConstraint source, PropertyConstraint target) {
            this.setDatatype(source, target);
            this.setEquivalentPath(source, target);
            this.setMaxCount(source, target);
            this.setMinCount(source, target);
            this.setValueClass(source, target);
        }

        private void setValueClass(PropertyConstraint source, PropertyConstraint p) {
            Shape shape;
            Resource value = source.getValueClass();
            if (value == null && (shape = source.getShape()) != null) {
                value = shape.getTargetClass();
            }
            if (value != null) {
                if (p.getDatatype() != null) {
                    p.setDatatype(null);
                    p.setValueClass((Resource)OWL.THING);
                    return;
                }
                Resource valueClass = p.getValueClass();
                if (valueClass == null) {
                    p.setValueClass(value);
                } else {
                    Resource result = ClassStructure.this.reasoner.leastCommonSuperClass(valueClass, value);
                    p.setValueClass(result);
                }
            }
        }

        private void setMinCount(PropertyConstraint source, PropertyConstraint target) {
            Integer a = this.minCount(source);
            Integer b = this.minCount(target);
            target.setMinCount(a < b ? a : b);
        }

        private Integer minCount(PropertyConstraint source) {
            Integer result = source.getMinCount();
            if (result == null) {
                result = ZERO;
            }
            return result;
        }

        private void setMaxCount(PropertyConstraint source, PropertyConstraint target) {
            Integer a = source.getMaxCount();
            Integer b = target.getMaxCount();
            if (a == null || b == null) {
                target.setMaxCount(null);
            } else if (a != null && (b == null || a > b)) {
                target.setMaxCount(a);
            }
        }

        private void setEquivalentPath(PropertyConstraint source, PropertyConstraint target) {
            if (source.getEquivalentPath() != null) {
                target.setEquivalentPath(source.getEquivalentPath());
            }
        }

        private void setDatatype(PropertyConstraint source, PropertyConstraint p) {
            URI value = source.getDatatype();
            if (value != null) {
                URI prior;
                if (p.getPredicate().equals((Object)RDF.TYPE)) {
                    p.setDatatype(null);
                    p.setValueClass((Resource)OWL.CLASS);
                    return;
                }
                if (p.getValueClass() != null) {
                    p.setDatatype(null);
                    p.setValueClass((Resource)OWL.THING);
                }
                if ((prior = p.getDatatype()) != null && !prior.equals(value)) {
                    if (ClassStructure.this.failOnDatatypeConflict) {
                        throw new KonigException("Conflicting datatype on property <" + p.getPredicate() + ">: Found <" + prior + "> and <" + value + ">");
                    }
                    logger.warn("Conflicting datatype on property <{}>: Found <{}> and <{}>. Using rdfs:Literal", new Object[]{p.getPredicate().stringValue(), prior.stringValue(), value.stringValue()});
                    value = RDFS.LITERAL;
                }
                p.setDatatype(value);
            }
        }

        private void subClassOf(Shape subtype, Shape supertype) {
            OrConstraint or = supertype.getOr();
            if (or == null) {
                or = new OrConstraint();
                supertype.setOr(or);
            }
            or.add(subtype);
            AndConstraint and = subtype.getAnd();
            if (and == null) {
                and = new AndConstraint();
                subtype.setAnd(and);
            }
            and.add(supertype);
        }

        private void injectThingAndNullShape() {
            Shape thing = this.produceShape((Resource)OWL.THING);
            for (Shape shape : ClassStructure.this.shapeMap.values()) {
                OrConstraint or;
                if (shape == thing) continue;
                if (!ClassStructure.this.hasSuperClass(shape)) {
                    this.subClassOf(shape, thing);
                }
                if ((or = shape.getOr()) == null || or.getShapes().size() != 1) continue;
                or.add(ClassStructure.this.nullShape);
            }
        }

        private void scanClasses() {
            List<Vertex> classList = ClassStructure.this.reasoner.getGraph().v((Resource)OWL.CLASS).in(RDF.TYPE).toVertexList();
            for (Vertex v : classList) {
                this.produceShape(v.getId());
            }
        }

        private void buildHierarchy() {
            ArrayList shapeList = new ArrayList(ClassStructure.this.shapeMap.values());
            for (Shape shape : shapeList) {
                Set<URI> superClasses;
                URI targetClass = shape.getTargetClass();
                if (targetClass == null) continue;
                Set<URI> subClasses = ClassStructure.this.reasoner.subClasses(targetClass);
                if (!subClasses.isEmpty()) {
                    OrConstraint orList = new OrConstraint();
                    shape.setOr(orList);
                    for (URI subclassId : subClasses) {
                        Shape s = this.produceShape((Resource)subclassId);
                        orList.add(s);
                    }
                }
                if ((superClasses = ClassStructure.this.reasoner.superClasses(targetClass)).isEmpty()) continue;
                AndConstraint andList = new AndConstraint();
                shape.setAnd(andList);
                for (URI superclassId : superClasses) {
                    andList.add(this.produceShape((Resource)superclassId));
                }
            }
        }

        private void buildShapes() {
            for (PropertyStructure info : ClassStructure.this.propertyMap.values()) {
                Set<Resource> domainIncludes;
                Shape shape;
                Resource domain = info.getDomain();
                URI predicate = info.getPredicate();
                if (domain != null && (shape = this.produceShape(domain)).getPropertyConstraint(predicate) == null) {
                    shape.add(info.asPropertyConstraint());
                }
                if ((domainIncludes = info.getDomainIncludes()) == null) continue;
                for (Resource owlClass : domainIncludes) {
                    Shape shape2 = this.produceShape(owlClass);
                    if (shape2.getPropertyConstraint(predicate) != null) continue;
                    shape2.add(info.asPropertyConstraint());
                }
            }
        }

        private void scanProperties() {
            List<Vertex> propertyList = ClassStructure.this.reasoner.getGraph().v((Resource)RDF.PROPERTY).union(new Value[]{OWL.DATATYPEPROPERTY, OWL.OBJECTPROPERTY, OWL.FUNCTIONALPROPERTY, OWL.INVERSEFUNCTIONALPROPERTY, OWL.SYMMETRICPROPERTY, OWL.TRANSITIVEPROPERTY, OWL.ANNOTATIONPROPERTY, OWL.DEPRECATEDPROPERTY, OWL.ONTOLOGYPROPERTY, OwlVocab.ReflexiveProperty, OwlVocab.IrreflexiveProperty, OwlVocab.AsymetricProperty}).in(RDF.TYPE).distinct().toVertexList();
            for (Vertex v : propertyList) {
                if (!(v.getId() instanceof URI)) continue;
                URI propertyId = (URI)v.getId();
                boolean isFunctional = ClassStructure.this.reasoner.instanceOf((Resource)propertyId, OWL.FUNCTIONALPROPERTY);
                URI domain = v.getURI(RDFS.DOMAIN);
                URI range = v.getURI(RDFS.RANGE);
                String comment = RdfUtil.getDescription(v);
                PropertyStructure p = this.produceProperty(propertyId);
                p.setDescription(comment);
                if (domain != null) {
                    p.setDomain((Resource)domain);
                    p.setDomainLocked(true);
                } else {
                    Set<URI> set = v.asTraversal().out(Schema.domainIncludes).toUriSet();
                    if (!set.isEmpty()) {
                        for (URI uri : set) {
                            p.domainIncludes((Resource)uri);
                        }
                        p.setDomainIncludesLocked(true);
                    }
                }
                if (isFunctional) {
                    this.setMaxCount(p, 1);
                }
                if (range == null) continue;
                if (ClassStructure.this.reasoner.isSubclassOfLiteral((Resource)range)) {
                    this.setDatatype(p, range);
                    continue;
                }
                this.setValueClass(p, (Resource)range);
            }
        }

        private void setDomain(PropertyStructure p, Resource value) {
            if (value != null) {
                Resource prior;
                if (Schema.Thing.equals((Object)value)) {
                    value = OWL.THING;
                }
                if (!value.equals(prior = p.getDomain())) {
                    if (p.getDomainIncludes() != null) {
                        Iterator<Resource> sequence = p.getDomainIncludes().iterator();
                        while (sequence.hasNext()) {
                            Resource other = sequence.next();
                            if (other.equals(value)) {
                                return;
                            }
                            if (p.isDomainIncludesLocked()) {
                                if (ClassStructure.this.reasoner.isSubClassOf(value, other)) {
                                    return;
                                }
                                if (!ClassStructure.this.reasoner.isSubClassOf(other, value)) continue;
                                sequence.remove();
                                continue;
                            }
                            Resource common = ClassStructure.this.reasoner.leastCommonSuperClass(value, other);
                            if (common.equals(other)) {
                                return;
                            }
                            if (common.equals(OWL.THING)) continue;
                            sequence.remove();
                            value = common;
                        }
                        p.domainIncludes(value);
                    } else if (prior == null) {
                        p.setDomain(value);
                    } else if (OWL.THING.equals((Object)prior)) {
                        p.domainIncludes(value);
                    } else if (OWL.THING.equals((Object)value)) {
                        p.domainIncludes(prior);
                    } else {
                        Resource common = ClassStructure.this.reasoner.leastCommonSuperClass(prior, value);
                        if (OWL.THING.equals((Object)common)) {
                            p.domainIncludes(prior);
                            p.domainIncludes(value);
                            if (!p.isDomainLocked()) {
                                p.setDomain(null);
                            }
                        } else if (p.isDomainLocked()) {
                            p.domainIncludes(common);
                        } else {
                            p.setDomain(common);
                        }
                    }
                }
            }
        }

        private void setValueClass(PropertyStructure p, Resource value) {
            if (value != null) {
                if (p.getDatatype() != null) {
                    throw new KonigException("Property <" + p.getPredicate() + "> has sh:datatype <" + p.getDatatype() + "> and sh:class <" + value + ">");
                }
                Resource valueClass = p.getValueClass();
                if (valueClass == null) {
                    p.setValueClass(value);
                } else {
                    Resource result = ClassStructure.this.reasoner.leastCommonSuperClass(valueClass, value);
                    p.setValueClass(result);
                }
            }
        }

        private void setDatatype(PropertyStructure p, URI value) {
            if (value != null) {
                if (p.getPredicate().equals((Object)RDF.TYPE)) {
                    p.setDatatype(null);
                    p.setValueClass((Resource)OWL.CLASS);
                    return;
                }
                if (p.getValueClass() != null) {
                    throw new KonigException("Property <" + p.getPredicate() + "> has sh:datatype <" + value + "> and sh:class <" + p.getValueClass() + ">");
                }
                Resource prior = p.getDatatype();
                if (prior != null && !prior.equals(value)) {
                    if (ClassStructure.this.failOnDatatypeConflict) {
                        throw new KonigException("Conflicting datatype on property <" + p.getPredicate() + ">: Found <" + prior + "> and <" + value + ">");
                    }
                    logger.warn("Conflicting datatype on property <{}>: Found <{}> and <{}>. Using rdfs:Literal", new Object[]{p.getPredicate().stringValue(), prior.stringValue(), value.stringValue()});
                    value = RDFS.LITERAL;
                }
                p.setDatatype((Resource)value);
            }
        }

        private void setEquivalentPath(PropertyStructure p, Path path) {
            if (path != null) {
                p.setEquivalentPath(path);
            }
        }

        private void setMaxCount(PropertyStructure p, Integer value) {
            Integer prior;
            if (value != null && ((prior = p.getMaxCount()) == null || value > prior)) {
                p.setMaxCount(value);
            }
        }

        private void setMinCount(PropertyStructure info, Integer value) {
            Integer prior;
            if (value != null && ((prior = info.getMinCount()) == null || value < prior)) {
                info.setMinCount(value);
            }
        }

        private PropertyStructure produceProperty(URI predicate) {
            PropertyStructure p = (PropertyStructure)ClassStructure.this.propertyMap.get(predicate);
            if (p == null) {
                p = new PropertyStructure(predicate);
                ClassStructure.this.propertyMap.put(predicate, p);
            }
            return p;
        }

        private Shape produceShape(Resource targetClassId) {
            Shape shape;
            if (targetClassId.equals(Schema.Thing)) {
                targetClassId = OWL.THING;
            }
            if ((shape = (Shape)ClassStructure.this.shapeMap.get(targetClassId)) == null) {
                URI targetClassURI = targetClassId instanceof URI ? (URI)targetClassId : null;
                URI shapeId = ClassStructure.this.iriTemplate == null || targetClassURI == null ? null : this.shapeName(targetClassURI);
                shape = new Shape((Resource)shapeId);
                if (targetClassId instanceof URI) {
                    shape.setTargetClass((URI)targetClassId);
                }
                ClassStructure.this.shapeMap.put(targetClassId, shape);
                PropertyConstraint p = new PropertyConstraint(RDF.TYPE);
                p.setNodeKind(NodeKind.IRI);
                p.setValueClass((Resource)OWL.CLASS);
                shape.add(p);
            }
            return shape;
        }

        private URI shapeName(URI targetClassURI) {
            SimpleValueMap map = new SimpleValueMap();
            map.put("targetClassLocalName", targetClassURI.getLocalName());
            Namespace ns = ClassStructure.this.reasoner.getGraph().getNamespaceManager().findByName(targetClassURI.getNamespace());
            if (ns == null) {
                throw new KonigException("Prefix not found for namespace " + targetClassURI.getNamespace());
            }
            map.put("targetClassNamespacePrefix", ns.getPrefix());
            String value = ClassStructure.this.iriTemplate.format(map);
            return new URIImpl(value);
        }
    }
}

