/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.core.Context;
import io.konig.core.NameMap;
import io.konig.core.NamespaceManager;
import io.konig.core.Term;
import io.konig.formula.CurieValue;
import io.konig.formula.Formula;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.LocalNameTerm;
import io.konig.formula.QuantifiedExpression;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;

public class FormulaContextBuilder
implements ShapeVisitor {
    private NamespaceManager nsManager;
    private NameMap map;
    private Map<String, Warning> warnings = new HashMap<String, Warning>();
    private Worker worker = new Worker();

    public FormulaContextBuilder(NamespaceManager nsManager, NameMap map) {
        this.nsManager = nsManager;
        this.map = map;
    }

    @Override
    public void visit(Shape shape) {
        this.worker.setShape(shape);
        this.handleIriFormula(shape);
        this.visit(shape, shape.getProperty());
        this.visit(shape, shape.getDerivedProperty());
    }

    private void handleIriFormula(Shape shape) {
        QuantifiedExpression formula = shape.getIriFormula();
        if (formula != null) {
            this.worker.setProperty(null);
            formula.dispatch(this.worker);
        }
    }

    private void visit(Shape shape, List<PropertyConstraint> list) {
        if (list != null) {
            for (PropertyConstraint p : list) {
                QuantifiedExpression formula = p.getFormula();
                if (formula == null) continue;
                this.worker.setProperty(p);
                formula.dispatch(this.worker);
            }
        }
    }

    class Worker
    implements FormulaVisitor {
        private Shape shape;
        private PropertyConstraint property;

        Worker() {
        }

        void setShape(Shape shape) {
            this.shape = shape;
        }

        void setProperty(PropertyConstraint property) {
            this.property = property;
        }

        void namespaceNotFound(String prefix) {
            FormulaContextBuilder.this.warnings.put(prefix, new NamespaceNotFoundWarning(prefix, this.shape, this.property));
        }

        @Override
        public void enter(Formula formula) {
        }

        @Override
        public void exit(Formula formula) {
            if (formula instanceof LocalNameTerm) {
                this.visitLocalNameTerm((LocalNameTerm)formula);
            } else if (formula instanceof CurieValue) {
                this.visitCurieTerm((CurieValue)formula);
            }
        }

        private void visitCurieTerm(CurieValue curie) {
            String prefix;
            Context context = curie.getContext();
            Term term = context.getTerm(prefix = curie.getNamespacePrefix());
            if (term == null) {
                Namespace ns = FormulaContextBuilder.this.nsManager.findByPrefix(prefix);
                if (ns == null) {
                    this.namespaceNotFound(prefix);
                } else {
                    term = new Term(prefix, ns.getName(), Term.Kind.NAMESPACE);
                    context.add(term);
                }
            }
        }

        private void visitLocalNameTerm(LocalNameTerm formula) {
            String name = formula.getLocalName();
            URI uri = FormulaContextBuilder.this.map.get(name);
            if (uri == null) {
                FormulaContextBuilder.this.warnings.put(name, new NameNotDefinedWarning(name, this.shape, this.property));
            } else {
                Context context = formula.getContext();
                Term term = context.getTerm(name);
                if (term == null) {
                    Namespace ns = FormulaContextBuilder.this.nsManager.findByName(uri.getNamespace());
                    if (ns != null) {
                        Term nsTerm = context.getTerm(ns.getPrefix());
                        if (nsTerm == null) {
                            nsTerm = new Term(ns.getPrefix(), ns.getName(), Term.Kind.NAMESPACE);
                            context.add(nsTerm);
                        }
                        if (nsTerm.getId().equals(ns.getName())) {
                            StringBuilder value = new StringBuilder();
                            value.append(ns.getPrefix());
                            value.append(':');
                            value.append(name);
                            context.addTerm(name, value.toString());
                            return;
                        }
                    }
                    context.addTerm(name, uri.stringValue());
                }
            }
        }
    }

    public static class NamespaceNotFoundWarning
    implements Warning {
        private String namespacePrefix;
        private Shape shape;
        private PropertyConstraint property;

        public NamespaceNotFoundWarning(String prefix, Shape shape, PropertyConstraint property) {
            this.namespacePrefix = prefix;
            this.shape = shape;
            this.property = property;
        }

        public String getNamespacePrefix() {
            return this.namespacePrefix;
        }

        public Shape getShape() {
            return this.shape;
        }

        public PropertyConstraint getProperty() {
            return this.property;
        }
    }

    public static class NameNotDefinedWarning
    implements Warning {
        private String name;
        private Shape shape;
        private PropertyConstraint property;

        public NameNotDefinedWarning(String name, Shape shape, PropertyConstraint property) {
            this.name = name;
            this.shape = shape;
            this.property = property;
        }

        public String getName() {
            return this.name;
        }

        public Shape getShape() {
            return this.shape;
        }

        public PropertyConstraint getProperty() {
            return this.property;
        }
    }

    public static interface Warning {
    }
}

