/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.core.AmbiguousPreferredClassException;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.shacl.ClassManager;
import io.konig.shacl.LogicalShapeNamer;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class LogicalShapeBuilder {
    private OwlReasoner reasoner;
    private LogicalShapeNamer shapeNamer;
    private Set<URI> stack;
    private boolean usePropertyConstraintComment;

    public LogicalShapeBuilder(OwlReasoner reasoner, LogicalShapeNamer shapeNamer) {
        this.reasoner = reasoner;
        this.shapeNamer = shapeNamer;
    }

    public boolean isUsePropertyConstraintComment() {
        return this.usePropertyConstraintComment;
    }

    public void setUsePropertyConstraintComment(boolean usePropertyConstraintComment) {
        this.usePropertyConstraintComment = usePropertyConstraintComment;
    }

    private URI targetClass(Shape shape) {
        URI targetClass = shape.getTargetClass();
        try {
            return targetClass == null ? null : this.reasoner.preferredClassAsURI(targetClass);
        }
        catch (AmbiguousPreferredClassException e) {
            throw new RuntimeException(e);
        }
    }

    public void buildLogicalShapes(ShapeManager shapeManager, ClassManager classManager) {
        List<Shape> list = shapeManager.listShapes();
        this.stack = new HashSet<URI>();
        for (Shape shape : list) {
            URI targetClass = this.targetClass(shape);
            Shape logicalShape = classManager.getLogicalShape((Resource)targetClass);
            if (logicalShape != null) continue;
            this.buildLogicalShape(list, targetClass, classManager);
        }
        List<Vertex> classList = this.reasoner.owlClassList();
        for (Vertex v : classList) {
            URI uri;
            Shape logicalShape;
            Resource id = v.getId();
            if (!(id instanceof URI) || (logicalShape = classManager.getLogicalShape((Resource)(uri = (URI)id))) != null) continue;
            this.buildLogicalShape(null, uri, classManager);
        }
        for (URI owlClass : this.stack) {
            Shape prior = classManager.getLogicalShape((Resource)owlClass);
            if (prior != null) continue;
            URI shapeId = this.shapeNamer.logicalShapeForOwlClass(owlClass);
            Shape shape = new Shape((Resource)shapeId);
            shape.setTargetClass(owlClass);
            classManager.addLogicalShape(shape);
        }
        this.stack = null;
    }

    private void buildLogicalShape(List<Shape> list, URI targetClass, ClassManager classManager) {
        if (targetClass == null) {
            return;
        }
        URI shapeId = this.shapeNamer.logicalShapeForOwlClass(targetClass);
        Shape shape = new Shape((Resource)shapeId);
        shape.setTargetClass(targetClass);
        classManager.addLogicalShape(shape);
        List<Shape> filter = this.filterByTargetClass(list, targetClass);
        Map<String, List<PropertyConstraint>> map = this.buildPropertyMap(filter);
        for (List<PropertyConstraint> pList : map.values()) {
            this.mergeProperties(shape, pList);
        }
    }

    private Resource preferredClass(Resource owlClass) {
        try {
            return owlClass == null ? null : this.reasoner.preferredClass(owlClass).getId();
        }
        catch (AmbiguousPreferredClassException e) {
            throw new RuntimeException(e);
        }
    }

    private void mergeProperties(Shape shape, List<PropertyConstraint> pList) {
        PropertyConstraint constraint = null;
        for (PropertyConstraint p : pList) {
            if (constraint == null) {
                constraint = new PropertyConstraint(p.getPredicate());
                this.setDefaultComment(constraint);
                shape.add(constraint);
            }
            Integer minCountA = constraint.getMinCount();
            Integer minCountB = p.getMinCount();
            if (minCountA == null) {
                constraint.setMinCount(minCountB);
            } else if (minCountB == null || minCountB < minCountA) {
                constraint.setMinCount(minCountB);
            }
            this.mergeComment(constraint, p);
            Integer maxCountA = constraint.getMaxCount();
            Integer maxCountB = p.getMaxCount();
            if (maxCountA == null) {
                constraint.setMaxCount(maxCountB);
            } else if (maxCountB == null || maxCountB > maxCountA) {
                constraint.setMaxCount(maxCountB);
            }
            Resource datatypeA = this.preferredClass((Resource)constraint.getDatatype());
            Resource datatypeB = this.preferredClass((Resource)p.getDatatype());
            Resource classA = this.preferredClass(constraint.getValueClass());
            Resource classB = this.preferredClass(p.getValueClass());
            Shape valueShapeA = constraint.getShape();
            Shape valueShapeB = p.getShape();
            if (valueShapeB != null) {
                classB = this.leastUpperBound(shape, p, "sh:class", (Resource)this.targetClass(valueShapeB), classB);
            }
            if (valueShapeA != null && classA == null) {
                classA = valueShapeA.getTargetClass();
            }
            if (valueShapeA != null && classA != null) {
                classA = this.leastUpperBound(shape, p, "sh:class", (Resource)this.targetClass(valueShapeA), classA);
            }
            classB = this.leastUpperBound(shape, p, "sh:class", classB, classA);
            datatypeB = (URI)this.leastUpperBound(shape, p, "sh:datatype", datatypeB, datatypeA);
            if (classB instanceof URI) {
                this.stack.add((URI)classB);
            }
            constraint.setValueClass(classB);
            constraint.setDatatype((URI)datatypeB);
        }
    }

    private void mergeComment(PropertyConstraint a, PropertyConstraint b) {
        if (this.usePropertyConstraintComment && a.getComment() == null) {
            a.setComment(b.getComment());
        }
    }

    private void setDefaultComment(PropertyConstraint constraint) {
        String comment;
        URI predicate = constraint.getPredicate();
        Vertex v = this.reasoner.getGraph().getVertex((Resource)predicate);
        if (v != null && (comment = RdfUtil.getDescription(v)) != null) {
            constraint.setComment(comment);
        }
    }

    private Resource leastUpperBound(Shape shape, PropertyConstraint p, String context, Resource classA, Resource classB) {
        if (classA != null && classB == null) {
            return classA;
        }
        if (classB != null && classA == null) {
            return classB;
        }
        if (classA != null && classB != null) {
            if (classA.equals(classB)) {
                return classA;
            }
            throw new RuntimeException("Conflicting " + context + " detected on property " + p.getPredicate().getLocalName() + " of " + shape.getTargetClass().getLocalName());
        }
        return null;
    }

    private Map<String, List<PropertyConstraint>> buildPropertyMap(List<Shape> list) {
        HashMap<String, List<PropertyConstraint>> map = new HashMap<String, List<PropertyConstraint>>();
        for (Shape shape : list) {
            List<PropertyConstraint> pList = shape.getProperty();
            for (PropertyConstraint p : pList) {
                URI predicate = p.getPredicate();
                ArrayList<PropertyConstraint> sink = (ArrayList<PropertyConstraint>)map.get(predicate.stringValue());
                if (sink == null) {
                    sink = new ArrayList<PropertyConstraint>();
                    map.put(predicate.stringValue(), sink);
                }
                sink.add(p);
            }
        }
        return map;
    }

    private List<Shape> filterByTargetClass(List<Shape> list, URI targetClass) {
        ArrayList<Shape> result = new ArrayList<Shape>();
        if (list != null) {
            for (Shape shape : list) {
                if (!targetClass.equals((Object)this.targetClass(shape))) continue;
                result.add(shape);
            }
        }
        return result;
    }
}

