/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.core.vocab.SH;
import org.openrdf.model.URI;

public enum NodeKind {
    IRI(SH.IRI, 1),
    BlankNode(SH.BlankNode, 2),
    BlankNodeOrIRI(SH.BlankNodeOrIRI, 3),
    Literal(SH.Literal, 4),
    IRIOrLiteral(SH.IRIOrLiteral, 5),
    BlankNodeOrLiteral(SH.BlankNodeOrLiteral, 6);

    private URI uri;
    private int index;

    private NodeKind(URI uri, int index) {
        this.uri = uri;
        this.index = index;
    }

    public URI getURI() {
        return this.uri;
    }

    public static NodeKind or(NodeKind a, NodeKind b) {
        int index = ((a == null ? 0 : a.index) | (b == null ? 0 : b.index)) - 1;
        return index < 0 ? null : NodeKind.values()[index];
    }

    public static NodeKind fromURI(URI uri) {
        if (NodeKind.IRI.uri.equals((Object)uri)) {
            return IRI;
        }
        if (NodeKind.BlankNode.uri.equals((Object)uri)) {
            return BlankNode;
        }
        if (NodeKind.Literal.uri.equals((Object)uri)) {
            return Literal;
        }
        if (NodeKind.BlankNodeOrIRI.uri.equals((Object)uri)) {
            return BlankNodeOrIRI;
        }
        return null;
    }
}

