/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.annotation.RdfProperty;
import io.konig.core.Path;
import io.konig.core.Term;
import io.konig.core.UidGenerator;
import io.konig.core.impl.KonigLiteral;
import io.konig.core.vocab.Konig;
import io.konig.formula.Formula2PathTranslator;
import io.konig.formula.Path2FormulaTranslator;
import io.konig.formula.QuantifiedExpression;
import io.konig.schema.Person;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PredicatePath;
import io.konig.shacl.PropertyPath;
import io.konig.shacl.RelationshipDegree;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class PropertyConstraint
implements Cloneable {
    private Resource id;
    private PropertyPath path;
    private List<Value> in;
    private Integer minCount;
    private Integer maxCount;
    private Integer minLength;
    private Integer maxLength;
    private Integer decimalPrecision;
    private Integer decimalScale;
    private Number minExclusive;
    private Number maxExclusive;
    private Number minInclusive;
    private Number maxInclusive;
    private Boolean uniqueLang;
    private URI datatype;
    private URI directType;
    private Shape shape;
    private NodeKind nodeKind;
    private Set<Value> hasValue;
    private String pattern;
    private Resource valueClass;
    private String documentation;
    private List<Value> knownValue;
    private boolean uniqueCountKey;
    private URI dimensionTerm;
    private boolean timeParam;
    private URI stereotype;
    private String fromAggregationSource;
    private Path sourcePath;
    private Path partitionOf;
    private QuantifiedExpression formula;
    private URI idFormat;
    private List<URI> qualifiedSecurityClassification;
    private RelationshipDegree relationshipDegree;
    private Person dataSteward;
    private String name;
    private URI equals;
    private URI preferredTabularShape;
    private Term term;
    private URI termStatus;

    public PropertyConstraint(URI predicate) {
        this.id = new BNodeImpl(UidGenerator.INSTANCE.next());
        this.path = new PredicatePath(predicate);
    }

    public PropertyConstraint(PropertyPath path) {
        this.id = new BNodeImpl(UidGenerator.INSTANCE.next());
        this.path = path;
    }

    public PropertyConstraint(Resource id, PropertyPath path) {
        this.id = id;
        this.path = path;
    }

    public PropertyConstraint(Resource id, URI predicate) {
        this.id = id;
        this.path = new PredicatePath(predicate);
    }

    public PropertyConstraint() {
    }

    @RdfProperty(value="http://schema.org/name")
    public String getName() {
        return this.name;
    }

    @RdfProperty(value="http://schema.org/name")
    public void setName(String name) {
        this.name = name;
    }

    public void setId(Resource id) {
        this.id = id;
    }

    public PropertyConstraint clone() {
        try {
            return (PropertyConstraint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public PropertyConstraint deepClone() {
        PropertyConstraint clone = this.clone();
        if (this.shape != null) {
            clone.setShape(this.shape.deepClone());
        }
        return clone;
    }

    public Resource getId() {
        return this.id;
    }

    public String getComment() {
        return this.documentation;
    }

    public void setComment(String comment) {
        this.documentation = comment;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Number getMinExclusive() {
        return this.minExclusive;
    }

    public void setMinExclusive(Number minExclusive) {
        this.minExclusive = minExclusive;
    }

    public Number getMaxExclusive() {
        return this.maxExclusive;
    }

    public void setMaxExclusive(Number maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public Number getMinInclusive() {
        return this.minInclusive;
    }

    public void setMinInclusive(Number minInclusive) {
        this.minInclusive = minInclusive;
    }

    public Number getMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMaxInclusive(Number maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public URI getPredicate() {
        return this.path instanceof PredicatePath ? ((PredicatePath)this.path).getPredicate() : null;
    }

    public void setPredicate(URI predicate) {
        this.path = new PredicatePath(predicate);
    }

    public void setPath(PropertyPath path) {
        this.path = path;
    }

    public void setPath(URI predicate) {
        this.path = new PredicatePath(predicate);
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    public void setNodeKind(NodeKind nodeKind) {
        this.nodeKind = nodeKind;
    }

    public void addIn(Value value) {
        if (this.in == null) {
            this.in = new ArrayList<Value>();
        }
        this.in.add(value);
    }

    public void setIn(List<Value> list) {
        this.in = list;
    }

    public void addKnownValue(Value value) {
        if (this.knownValue == null) {
            this.knownValue = new ArrayList<Value>();
        }
        this.knownValue.add(value);
    }

    public List<Value> getKnownValue() {
        return this.knownValue;
    }

    public void addHasValue(Value value) {
        Literal literal;
        URI datatype;
        if (this.hasValue == null) {
            this.hasValue = new HashSet<Value>();
        }
        if (value instanceof Literal && (datatype = (literal = (Literal)value).getDatatype()) != null && XMLSchema.STRING.equals((Object)datatype)) {
            value = new KonigLiteral(literal.stringValue());
        }
        this.hasValue.add((Value)value);
    }

    public Set<Value> getHasValue() {
        return this.hasValue;
    }

    public void setHasValue(Set<Value> set) {
        this.hasValue = set;
    }

    public List<Value> getIn() {
        return this.in;
    }

    public Integer getMinCount() {
        return this.minCount;
    }

    public void setMinCount(Integer minCount) {
        this.minCount = minCount;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public URI getDatatype() {
        return this.datatype;
    }

    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    public URI getDirectValueType() {
        return this.directType;
    }

    public void setDirectValueType(URI directType) {
        this.directType = directType;
    }

    public Resource getShapeId() {
        return this.shape == null ? null : this.shape.getId();
    }

    public Shape getShape() {
        return this.shape;
    }

    public Shape getShape(ShapeManager manager) {
        return this.shape;
    }

    public void setShape(Shape valueShape) {
        this.shape = valueShape;
    }

    public String toString() {
        StringWriter out = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator json = factory.createGenerator((Writer)out);
            json.useDefaultPrettyPrinter();
            HashSet<Shape> memory = new HashSet<Shape>();
            this.toJson(memory, json);
            json.flush();
        }
        catch (IOException e) {
            return "ERROR:" + e.getMessage();
        }
        return out.toString();
    }

    public Person dataSteward() {
        if (this.dataSteward == null) {
            this.dataSteward = new Person();
        }
        return this.dataSteward;
    }

    public void toJson(Set<Shape> memory, JsonGenerator json) throws IOException {
        json.writeStartObject();
        if (this.path instanceof PredicatePath) {
            json.writeStringField("predicate", this.getPredicate().toString());
        } else if (this.path != null) {
            json.writeStringField("path", this.path.toString());
        }
        if (this.minCount != null) {
            json.writeNumberField("minCount", this.minCount.intValue());
        }
        if (this.maxCount != null) {
            json.writeNumberField("maxCount", this.maxCount.intValue());
        }
        if (this.datatype != null) {
            json.writeStringField("datatype", this.datatype.stringValue());
        }
        if (this.directType != null) {
            json.writeStringField("directType", this.directType.stringValue());
        }
        if (this.minInclusive != null) {
            json.writeNumberField("minInclusive", this.minInclusive.doubleValue());
        }
        if (this.maxInclusive != null) {
            json.writeNumberField("maxInclusive", this.maxInclusive.doubleValue());
        }
        if (this.nodeKind != null) {
            json.writeStringField("nodeKind", "sh:" + this.nodeKind.getURI().getLocalName());
        }
        if (this.valueClass != null) {
            json.writeStringField("class", this.valueClass.stringValue());
        }
        if (this.shape != null) {
            json.writeFieldName("valueShape");
            if (memory.contains(this.shape)) {
                json.writeString(this.shape.getId().toString());
            } else {
                this.shape.toJson(memory, json);
            }
        }
        json.writeEndObject();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @RdfProperty(value="http://www.w3.org/ns/shacl#class")
    public Resource getValueClass() {
        return this.valueClass;
    }

    @RdfProperty(value="http://www.w3.org/ns/shacl#class")
    public void setValueClass(Resource valueClass) {
        this.valueClass = valueClass;
    }

    public boolean isRequired() {
        return this.minCount != null && this.minCount > 0;
    }

    public boolean isUniqueCountKey() {
        return this.uniqueCountKey;
    }

    public void setUniqueCountKey(boolean uniqueCountKey) {
        this.uniqueCountKey = uniqueCountKey;
    }

    public URI getDimensionTerm() {
        return this.dimensionTerm;
    }

    public void setDimensionTerm(URI dimensionTerm) {
        this.dimensionTerm = dimensionTerm;
    }

    public boolean isTimeParam() {
        return this.timeParam;
    }

    public void setTimeParam(boolean timeParam) {
        this.timeParam = timeParam;
    }

    public URI getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(URI stereotype) {
        this.stereotype = stereotype;
    }

    public void setMeasure(URI measure) {
        this.path = new PredicatePath(measure);
        this.stereotype = Konig.measure;
    }

    public void setDimension(URI dimension) {
        this.path = new PredicatePath(dimension);
        this.stereotype = Konig.dimension;
    }

    public void setAttribute(URI attribute) {
        this.path = new PredicatePath(attribute);
        this.stereotype = Konig.attribute;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/equivalentPath")
    public Path getEquivalentPath() {
        return Formula2PathTranslator.getInstance().toPath(this.formula);
    }

    public void setEquivalentPath(Path path) {
        this.formula = Path2FormulaTranslator.getInstance().toQuantifiedExpression(path);
    }

    @RdfProperty(value="http://www.konig.io/ns/core/sourcePath")
    public Path getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(Path sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getFromAggregationSource() {
        return this.fromAggregationSource;
    }

    public void setFromAggregationSource(String fromAggregationSource) {
        this.fromAggregationSource = fromAggregationSource;
    }

    public PropertyPath getPath() {
        return this.path;
    }

    public QuantifiedExpression getFormula() {
        return this.formula;
    }

    public void setFormula(QuantifiedExpression formula) {
        this.formula = formula;
    }

    public URI getIdFormat() {
        return this.idFormat;
    }

    public void setIdFormat(URI idFormat) {
        this.idFormat = idFormat;
    }

    public URI getTermStatus() {
        return this.termStatus;
    }

    public void setTermStatus(URI termStatus) {
        this.termStatus = termStatus;
    }

    public boolean isRequiredSingleValue() {
        return this.minCount != null && this.minCount == 1 && this.maxCount != null && this.maxCount == 1;
    }

    public Integer getDecimalPrecision() {
        return this.decimalPrecision;
    }

    public void setDecimalPrecision(Integer decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
    }

    public Integer getDecimalScale() {
        return this.decimalScale;
    }

    public void setDecimalScale(Integer decimalScale) {
        this.decimalScale = decimalScale;
    }

    public List<URI> getQualifiedSecurityClassification() {
        return this.qualifiedSecurityClassification;
    }

    public void setQualifiedSecurityClassification(List<URI> qualifiedSecurityClassification) {
        this.qualifiedSecurityClassification = qualifiedSecurityClassification;
    }

    public Boolean getUniqueLang() {
        return this.uniqueLang;
    }

    public void setUniqueLang(Boolean uniqueLang) {
        this.uniqueLang = uniqueLang;
    }

    public Person getDataSteward() {
        return this.dataSteward;
    }

    public void setDataSteward(Person dataSteward) {
        this.dataSteward = dataSteward;
    }

    public RelationshipDegree getRelationshipDegree() {
        return this.relationshipDegree;
    }

    public void setRelationshipDegree(RelationshipDegree relationshipDegree) {
        this.relationshipDegree = relationshipDegree;
    }

    public URI getEquals() {
        return this.equals;
    }

    public void setEquals(URI equals) {
        this.equals = equals;
    }

    @RdfProperty(value="http://www.konig.io/shapes/preferredTabularShape")
    public URI getPreferredTabularShape() {
        return this.preferredTabularShape;
    }

    public void setPreferredTabularShape(URI preferredTabularShape) {
        this.preferredTabularShape = preferredTabularShape;
    }
}

