/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.core.Path;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class PropertyStructure {
    private URI predicate;
    private Resource domain;
    private Resource datatype;
    private Resource valueClass;
    private Integer maxCount;
    private Integer minCount;
    private Set<Resource> domainIncludes;
    private boolean domainLocked;
    private boolean domainIncludesLocked;
    private Set<Shape> usedInShape = new HashSet<Shape>();
    private String description;
    private Path equivalentPath;

    public PropertyStructure(URI predicate) {
        this.predicate = predicate;
    }

    public boolean isDomainIncludesLocked() {
        return this.domainIncludesLocked;
    }

    public void setDomainIncludesLocked(boolean domainIncludesLocked) {
        this.domainIncludesLocked = domainIncludesLocked;
    }

    public Set<Resource> getDomainIncludes() {
        return this.domainIncludes;
    }

    public void addShape(Shape shape) {
        this.usedInShape.add(shape);
    }

    public Set<Shape> getUsedInShape() {
        return this.usedInShape;
    }

    public boolean isDomainLocked() {
        return this.domainLocked;
    }

    public void setDomainLocked(boolean domainLocked) {
        this.domainLocked = domainLocked;
    }

    public void domainIncludes(Resource owlClass) {
        if (this.domainIncludes == null) {
            this.domainIncludes = new HashSet<Resource>();
        }
        this.domainIncludes.add(owlClass);
    }

    public URI getPredicate() {
        return this.predicate;
    }

    public Resource getDomain() {
        return this.domain;
    }

    public void setDomain(Resource domain) {
        this.domain = domain;
    }

    public Resource getDatatype() {
        return this.datatype;
    }

    public void setDatatype(Resource datatype) {
        this.datatype = datatype;
    }

    public Resource getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Resource valueClass) {
        this.valueClass = valueClass;
    }

    public Integer getMinCount() {
        return this.minCount;
    }

    public void setMinCount(Integer minCount) {
        this.minCount = minCount;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String description() {
        if (this.description != null) {
            return this.description;
        }
        String result = null;
        for (Shape shape : this.usedInShape) {
            PropertyConstraint p = shape.getPropertyConstraint(this.predicate);
            if (p == null) continue;
            String comment = p.getComment();
            if (result == null) {
                result = comment;
                continue;
            }
            if (result.equals(comment)) continue;
            return null;
        }
        return result;
    }

    public PropertyConstraint asPropertyConstraint() {
        PropertyConstraint p = new PropertyConstraint(this.predicate);
        if (this.datatype instanceof URI) {
            p.setDatatype((URI)this.datatype);
        }
        p.setValueClass(this.valueClass);
        p.setMaxCount(this.maxCount);
        p.setMinCount(this.minCount);
        return p;
    }

    public Path getEquivalentPath() {
        return this.equivalentPath;
    }

    public void setEquivalentPath(Path equivalentPath) {
        this.equivalentPath = equivalentPath;
    }

    public List<URI> domainIncludes() {
        ArrayList<URI> result = new ArrayList<URI>();
        if (this.domainIncludes == null) {
            if (this.domain instanceof URI) {
                result.add((URI)this.domain);
            }
        } else {
            for (Resource resource : this.domainIncludes) {
                if (!(resource instanceof URI)) continue;
                result.add((URI)resource);
            }
        }
        return result;
    }

    public List<URI> rangeIncludes() {
        ArrayList<URI> result = new ArrayList<URI>();
        if (this.datatype instanceof URI) {
            result.add((URI)this.datatype);
        }
        if (this.valueClass instanceof URI) {
            result.add((URI)this.valueClass);
        }
        return result;
    }
}

