/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.annotation.RdfList;
import io.konig.core.KonigException;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.shacl.PredicatePath;
import io.konig.shacl.PropertyPath;
import java.util.ArrayList;
import org.openrdf.model.URI;

@RdfList
public class SequencePath
extends ArrayList<PropertyPath>
implements PropertyPath {
    private static final long serialVersionUID = 1L;

    public static SequencePath fromPathExpression(PathExpression e) throws KonigException {
        SequencePath sequence = new SequencePath();
        for (PathStep step : e.getStepList()) {
            if (step instanceof DirectionStep) {
                DirectionStep dirStep = (DirectionStep)step;
                if (dirStep.getDirection() == Direction.IN) {
                    throw new KonigException("Inverse paths not supported: " + e.simpleText());
                }
                URI term = dirStep.getTerm().getIri();
                sequence.add(new PredicatePath(term));
                continue;
            }
            throw new KonigException("Invalid sequence path: " + e.simpleText());
        }
        return sequence;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        String space = "";
        for (PropertyPath path : this) {
            builder.append(space);
            builder.append(path.toString());
            space = " ";
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public PropertyPath getLast() {
        PropertyPath result = null;
        if (!this.isEmpty() && (result = (PropertyPath)this.get(this.size() - 1)) instanceof SequencePath) {
            result = ((SequencePath)result).getLast();
        }
        return result;
    }
}

