/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.activity.Activity;
import io.konig.annotation.RdfProperty;
import io.konig.cadl.Cube;
import io.konig.core.Context;
import io.konig.core.UidGenerator;
import io.konig.core.io.PrettyPrintWriter;
import io.konig.core.util.IriTemplate;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.SH;
import io.konig.datasource.DataSource;
import io.konig.formula.Expression;
import io.konig.formula.QuantifiedExpression;
import io.konig.shacl.AndConstraint;
import io.konig.shacl.NodeKind;
import io.konig.shacl.NotConstraint;
import io.konig.shacl.OrConstraint;
import io.konig.shacl.PredicatePath;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.PropertyPath;
import io.konig.shacl.ShapeMaxRowLength;
import io.konig.shacl.XoneConstraint;
import io.konig.shacl.impl.EmptyList;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.BNodeImpl;

public class Shape
implements Cloneable {
    private static final List<PropertyConstraint> EMPTY_PROPERTY_LIST = new EmptyList<PropertyConstraint>();
    private Resource id;
    private URI targetClass;
    private List<PropertyConstraint> property;
    private List<PropertyConstraint> derivedProperty;
    private List<PropertyConstraint> variable;
    private Context jsonldContext;
    private URI equivalentRelationalShape;
    private NodeKind nodeKind;
    private String comment;
    private URI termStatus;
    private Cube nodeShapeCube;
    private AndConstraint and;
    private OrConstraint or;
    private XoneConstraint xone;
    private NotConstraint not;
    private Activity wasGeneratedBy;
    private String bigQueryTableId;
    private Set<URI> type;
    private IriTemplate iriTemplate;
    private QuantifiedExpression iriFormula;
    private URI idFormat;
    private List<DataSource> shapeDataSource;
    private Expression updateWhen;
    private int ordinal;
    private URI preferredJsonldContext;
    private URI preferredJsonSchema;
    private List<URI> defaultShapeFor;
    private List<Expression> constraint;
    private URI aggregationOf;
    private URI rollUpBy;
    private String mediaTypeBaseName;
    private List<URI> inputShapeOf;
    private Shape tabularOriginShape;
    private URI usesAbbreviationScheme;
    private List<ShapeMaxRowLength> shapeMaxRowLengthList;
    private Set<URI> shapeProcessing;
    private Set<Shape> explicitDerivedFrom;
    private Set<URI> broader;
    private String idComment;

    public List<URI> getInputShapeOf() {
        return this.inputShapeOf;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/inputShapeOf")
    public void setInputShapeOf(List<URI> inputShapeOf) {
        this.inputShapeOf = inputShapeOf;
    }

    public void addInputShapeOf(URI uri) {
        if (this.inputShapeOf == null) {
            this.inputShapeOf = new ArrayList<URI>();
        }
        this.inputShapeOf.add(uri);
    }

    public Shape() {
        String bnodeId = UidGenerator.INSTANCE.next();
        this.id = new BNodeImpl(bnodeId);
        this.addType(SH.Shape);
    }

    public Shape(Resource id) {
        this.id = id;
        this.addType(SH.Shape);
    }

    public Shape clone() {
        try {
            return (Shape)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Shape deepClone() {
        Shape clone = this.clone();
        ArrayList<PropertyConstraint> propertyList = new ArrayList<PropertyConstraint>();
        clone.property = propertyList;
        for (PropertyConstraint p : this.getProperty()) {
            propertyList.add(p.deepClone());
        }
        if (this.and != null) {
            AndConstraint cloneAnd = new AndConstraint();
            clone.setAnd(cloneAnd);
            for (Shape shape : this.and.getShapes()) {
                cloneAnd.add(shape.deepClone());
            }
        }
        if (this.or != null) {
            OrConstraint cloneOr = new OrConstraint();
            clone.setOr(cloneOr);
            for (Shape shape : this.or.getShapes()) {
                cloneOr.add(shape.deepClone());
            }
        }
        if (this.xone != null) {
            XoneConstraint cloneXone = new XoneConstraint();
            clone.setXone(cloneXone);
            for (Shape s : this.xone.getShapes()) {
                cloneXone.add(s.deepClone());
            }
        }
        if (this.not != null) {
            NotConstraint cloneNot = new NotConstraint();
            clone.setNot(cloneNot);
            cloneNot.setShape(this.not.getShape().deepClone());
        }
        return clone;
    }

    public List<PropertyConstraint> getProperty() {
        return this.property == null ? EMPTY_PROPERTY_LIST : this.property;
    }

    public void setPropertyList(List<PropertyConstraint> list) {
        this.property = list;
    }

    public AndConstraint getAnd() {
        return this.and;
    }

    public void setAnd(AndConstraint and) {
        this.and = and;
        if (and != null) {
            and.setDeclaringShape(this);
        }
    }

    @RdfProperty(value="http://www.w3.org/ns/shacl#or")
    public OrConstraint getOr() {
        return this.or;
    }

    public void setOr(OrConstraint or) {
        this.or = or;
        if (or != null) {
            or.setDeclaringShape(this);
        }
    }

    public PropertyConstraint getTimeParam() {
        if (this.property != null) {
            for (PropertyConstraint c : this.property) {
                if (!c.isTimeParam()) continue;
                return c;
            }
        }
        return null;
    }

    public PropertyConstraint getDimensionConstraint(URI dimension) {
        if (this.property != null) {
            for (PropertyConstraint c : this.property) {
                URI d = c.getDimensionTerm();
                if (!dimension.equals((Object)d)) continue;
                return c;
            }
        }
        return null;
    }

    public PropertyConstraint getPropertyConstraint(URI predicate) {
        if (this.property != null) {
            for (PropertyConstraint c : this.property) {
                if (!predicate.equals((Object)c.getPredicate())) continue;
                return c;
            }
        }
        return null;
    }

    public boolean hasPropertyConstraint(URI predicate) {
        if (this.getPropertyConstraint(predicate) != null) {
            return true;
        }
        if (this.and != null && this.and.hasPropertyConstraint(predicate)) {
            return true;
        }
        return this.or != null && this.or.hasPropertyConstraint(predicate);
    }

    public PropertyConstraint property(URI predicate) {
        if (this.property != null) {
            for (PropertyConstraint p : this.property) {
                if (!p.getPredicate().equals((Object)predicate)) continue;
                return p;
            }
        }
        return null;
    }

    @RdfProperty(value="http://www.w3.org/ns/shacl#property")
    public void addProperty(PropertyConstraint c) {
        this.add(c);
    }

    @RdfProperty(value="http://www.w3.org/ns/shacl#property")
    public Shape add(PropertyConstraint c) {
        if (this.property == null) {
            this.property = new ArrayList<PropertyConstraint>();
        }
        URI id = c.getPredicate();
        for (PropertyConstraint p : this.property) {
            URI predicate = p.getPredicate();
            if (predicate == null || !predicate.equals((Object)id)) continue;
            return this;
        }
        this.property.add(c);
        return this;
    }

    public Shape updatePropertyConstraint(PropertyConstraint c) {
        if (this.property == null) {
            return this;
        }
        URI id = c.getPredicate();
        for (int i = 0; i < this.property.size(); ++i) {
            PropertyConstraint p = this.property.get(i);
            URI predicate = p.getPredicate();
            if (predicate == null || !predicate.equals((Object)id)) continue;
            p = c;
            this.property.set(i, p);
        }
        return this;
    }

    public URI getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(URI targetClass) {
        this.targetClass = targetClass;
    }

    public URI getIri() {
        return this.id instanceof URI ? (URI)this.id : null;
    }

    public Resource getId() {
        return this.id;
    }

    public void setId(Resource id) {
        this.id = id;
    }

    public String toString() {
        StringWriter out = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator json = factory.createGenerator((Writer)out);
            json.useDefaultPrettyPrinter();
            HashSet<Shape> memory = new HashSet<Shape>();
            this.toJson(memory, json);
            json.flush();
        }
        catch (Throwable e) {
            return "ERROR: " + e.getMessage();
        }
        return out.toString();
    }

    public void toJson(Set<Shape> memory, JsonGenerator json) throws IOException {
        json.writeStartObject();
        json.writeStringField("id", this.id.toString());
        if (this.targetClass != null) {
            json.writeStringField("targetClass", this.targetClass.stringValue());
        }
        if (this.nodeKind != null) {
            json.writeStringField("nodeKind", this.nodeKind.getURI().getLocalName());
        }
        if (!memory.contains(this)) {
            memory.add(this);
            if (this.property != null && !this.property.isEmpty()) {
                json.writeFieldName("property");
                json.writeStartArray();
                for (PropertyConstraint p : this.property) {
                    p.toJson(memory, json);
                }
                json.writeEndArray();
            }
        }
        json.writeEndObject();
    }

    public Context getJsonldContext() {
        return this.jsonldContext;
    }

    public void setJsonldContext(Context jsonldContext) {
        this.jsonldContext = jsonldContext;
    }

    public URI getEquivalentRelationalShape() {
        return this.equivalentRelationalShape;
    }

    public void setEquivalentRelationalShape(URI equivalentRelationalShape) {
        this.equivalentRelationalShape = equivalentRelationalShape;
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    public void setNodeKind(NodeKind nodeKind) {
        this.nodeKind = nodeKind;
    }

    public URI getAggregationOf() {
        return this.aggregationOf;
    }

    public void setAggregationOf(URI aggregationOf) {
        this.aggregationOf = aggregationOf;
    }

    public URI getRollUpBy() {
        return this.rollUpBy;
    }

    public void setRollUpBy(URI rollUpBy) {
        this.rollUpBy = rollUpBy;
    }

    public Activity getWasGeneratedBy() {
        return this.wasGeneratedBy;
    }

    public void setWasGeneratedBy(Activity wasGeneratedBy) {
        this.wasGeneratedBy = wasGeneratedBy;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/bigQueryTableId")
    public String getBigQueryTableId() {
        return this.bigQueryTableId;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/bigQueryTableId")
    public void setBigQueryTableId(String bigQueryTableId) {
        this.bigQueryTableId = bigQueryTableId;
    }

    public void addType(URI type) {
        if (this.type == null) {
            this.type = new LinkedHashSet<URI>();
        }
        if (!this.type.contains(type)) {
            this.type.add(type);
        }
    }

    @RdfProperty(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    public Set<URI> getType() {
        return this.type == null ? Collections.emptySet() : this.type;
    }

    public void setType(Set<URI> type) {
        this.type = type;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/iriTemplate")
    public IriTemplate getIriTemplate() {
        return this.iriTemplate;
    }

    public void setIriTemplate(IriTemplate iriTemplate) {
        this.iriTemplate = iriTemplate;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/shapeDataSource")
    public List<DataSource> getShapeDataSource() {
        return this.shapeDataSource == null ? Collections.emptyList() : this.shapeDataSource;
    }

    public void addShapeDataSource(DataSource dataSource) {
        if (this.shapeDataSource == null) {
            this.shapeDataSource = new ArrayList<DataSource>();
        }
        this.shapeDataSource.add(dataSource);
    }

    @RdfProperty(value="http://www.konig.io/ns/core/shapeDataSource")
    public void setShapeDataSource(List<DataSource> shapeDataSource) {
        this.shapeDataSource = shapeDataSource;
    }

    public boolean hasDataSourceType(URI type) {
        if (this.shapeDataSource != null) {
            for (DataSource s : this.shapeDataSource) {
                if (!s.isA(type)) continue;
                return true;
            }
        }
        return false;
    }

    public String bigQueryTableId() {
        String result = null;
        if (this.shapeDataSource != null) {
            for (DataSource s : this.shapeDataSource) {
                if (!s.isA(Konig.GoogleBigQueryTable)) continue;
                result = s.getIdentifier();
                if (!(s.getId() instanceof URI)) break;
                result = ((URI)s.getId()).getLocalName();
                break;
            }
        }
        return result;
    }

    public URI getIdFormat() {
        return this.idFormat;
    }

    public void setIdFormat(URI idFormat) {
        this.idFormat = idFormat;
    }

    public Expression getUpdateWhen() {
        return this.updateWhen;
    }

    public void setUpdateWhen(Expression updateWhen) {
        this.updateWhen = updateWhen;
    }

    public PropertyConstraint getDerivedPropertyByPredicate(URI predicate) {
        if (this.derivedProperty != null) {
            for (PropertyConstraint p : this.derivedProperty) {
                if (!predicate.equals((Object)p.getPredicate())) continue;
                return p;
            }
        }
        return null;
    }

    public List<PropertyConstraint> getDerivedProperty() {
        return this.derivedProperty == null ? Collections.emptyList() : this.derivedProperty;
    }

    public void setDerivedProperty(List<PropertyConstraint> derivedProperty) {
        this.derivedProperty = derivedProperty;
    }

    public void addDerivedProperty(PropertyConstraint p) {
        if (this.derivedProperty == null) {
            this.derivedProperty = new ArrayList<PropertyConstraint>();
        }
        this.derivedProperty.add(p);
    }

    public void addVariable(PropertyConstraint p) {
        if (this.variable == null) {
            this.variable = new ArrayList<PropertyConstraint>();
        }
        this.variable.add(p);
    }

    public PropertyConstraint getVariableById(URI id) {
        if (this.variable != null) {
            for (PropertyConstraint p : this.variable) {
                URI predicate = p.getPredicate();
                if (predicate == null || !predicate.equals((Object)id)) continue;
                return p;
            }
        }
        return null;
    }

    public PropertyConstraint getVariableByName(String name) {
        if (this.variable != null) {
            for (PropertyConstraint p : this.variable) {
                URI predicate = p.getPredicate();
                if (predicate == null || !name.equals(predicate.getLocalName())) continue;
                return p;
            }
        }
        return null;
    }

    public List<PropertyConstraint> getVariable() {
        return this.variable == null ? Collections.EMPTY_LIST : this.variable;
    }

    public void setVariable(List<PropertyConstraint> variable) {
        this.variable = variable;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public URI getPreferredJsonldContext() {
        return this.preferredJsonldContext;
    }

    public void setPreferredJsonldContext(URI preferredJsonldContext) {
        this.preferredJsonldContext = preferredJsonldContext;
    }

    public URI getPreferredJsonSchema() {
        return this.preferredJsonSchema;
    }

    public void setPreferredJsonSchema(URI preferredJsonSchema) {
        this.preferredJsonSchema = preferredJsonSchema;
    }

    public List<Expression> getConstraint() {
        return this.constraint;
    }

    public void addConstraint(Expression expr) {
        if (this.constraint == null) {
            this.constraint = new ArrayList<Expression>();
        }
        this.constraint.add(expr);
    }

    public void setConstraint(List<Expression> constraint) {
        this.constraint = constraint;
    }

    public void addDefaultShapeFor(URI app) {
        if (this.defaultShapeFor == null) {
            this.defaultShapeFor = new ArrayList<URI>();
        }
        this.defaultShapeFor.add(app);
    }

    public List<URI> getDefaultShapeFor() {
        return this.defaultShapeFor;
    }

    public void setDefaultShapeFor(List<URI> defaultShapeFor) {
        this.defaultShapeFor = defaultShapeFor;
    }

    public String getMediaTypeBaseName() {
        return this.mediaTypeBaseName;
    }

    public void setMediaTypeBaseName(String mediaTypeBaseName) {
        this.mediaTypeBaseName = mediaTypeBaseName;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/iriFormula")
    public QuantifiedExpression getIriFormula() {
        return this.iriFormula;
    }

    public void setIriFormula(QuantifiedExpression iriFormula) {
        this.iriFormula = iriFormula;
    }

    public String summaryText() {
        StringWriter buffer = new StringWriter();
        PrettyPrintWriter out = new PrettyPrintWriter(buffer);
        out.print("SHAPE: <");
        if (this.id != null) {
            out.print(this.id.stringValue());
        }
        out.println(">");
        this.printSummaryProperties(this, out);
        return buffer.toString();
    }

    private void printSummaryProperties(Shape shape, PrettyPrintWriter out) {
        out.pushIndent();
        for (PropertyConstraint p : shape.getProperty()) {
            PropertyPath path = p.getPath();
            if (!(path instanceof PredicatePath)) continue;
            PredicatePath pp = (PredicatePath)path;
            URI predicate = pp.getPredicate();
            out.indent();
            out.println(predicate.getLocalName());
            Shape nested = p.getShape();
            if (nested == null) continue;
            this.printSummaryProperties(nested, out);
        }
        out.popIndent();
    }

    public DataSource findDataSourceByType(URI type) {
        if (this.shapeDataSource != null) {
            for (DataSource ds : this.shapeDataSource) {
                if (!ds.isA(type)) continue;
                return ds;
            }
        }
        return null;
    }

    public <T> T findDataSource(Class<T> type) {
        if (this.shapeDataSource != null) {
            for (DataSource ds : this.shapeDataSource) {
                if (!type.isAssignableFrom(ds.getClass())) continue;
                return (T)ds;
            }
        }
        return null;
    }

    public Shape getTabularOriginShape() {
        return this.tabularOriginShape;
    }

    public void setTabularOriginShape(Shape tabularOriginShape) {
        this.tabularOriginShape = tabularOriginShape;
        this.addType(Konig.TabularNodeShape);
    }

    public URI getUsesAbbreviationScheme() {
        return this.usesAbbreviationScheme;
    }

    public void setUsesAbbreviationScheme(URI usesAbbreviationScheme) {
        this.usesAbbreviationScheme = usesAbbreviationScheme;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/shapeMaxRowLength")
    public List<ShapeMaxRowLength> getShapeMaxRowLengthList() {
        return this.shapeMaxRowLengthList;
    }

    public void setShapeMaxRowLengthList(List<ShapeMaxRowLength> shapeMaxRowLengthList) {
        this.shapeMaxRowLengthList = shapeMaxRowLengthList;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/termStatus")
    public URI getTermStatus() {
        return this.termStatus;
    }

    public void setTermStatus(URI termStatus) {
        this.termStatus = termStatus;
    }

    public Set<URI> getShapeProcessing() {
        return this.shapeProcessing == null ? Collections.emptySet() : this.shapeProcessing;
    }

    public void addShapeProcessing(URI shapeProcessing) {
        if (shapeProcessing != null) {
            if (this.shapeProcessing == null) {
                this.shapeProcessing = new LinkedHashSet<URI>();
            }
            this.shapeProcessing.add(shapeProcessing);
        }
    }

    public void setShapeProcessing(Set<URI> shapeProcessing) {
        this.shapeProcessing = shapeProcessing;
    }

    @RdfProperty(value="http://www.w3.org/ns/shacl#xone")
    public XoneConstraint getXone() {
        return this.xone;
    }

    public void setXone(XoneConstraint xone) {
        this.xone = xone;
        if (xone != null) {
            xone.setDeclaringShape(this);
        }
    }

    public NotConstraint getNot() {
        return this.not;
    }

    public void setNot(NotConstraint not) {
        this.not = not;
        if (not != null) {
            not.setDeclaringShape(this);
        }
    }

    public void addExplicitDerivedFrom(Shape sourceShape) {
        if (this.explicitDerivedFrom == null) {
            this.explicitDerivedFrom = new HashSet<Shape>();
        }
        this.explicitDerivedFrom.add(sourceShape);
    }

    @RdfProperty(value="http://www.konig.io/ns/core/explicitDerivedFrom")
    public Set<Shape> getExplicitDerivedFrom() {
        return this.explicitDerivedFrom == null ? Collections.emptySet() : this.explicitDerivedFrom;
    }

    public Set<URI> getBroader() {
        return this.broader == null ? Collections.emptySet() : this.broader;
    }

    @RdfProperty(value="http://www.w3.org/2004/02/skos/core#broader")
    public void addBroader(URI skosConcept) {
        if (this.broader == null) {
            this.broader = new LinkedHashSet<URI>();
        }
        this.broader.add(skosConcept);
    }

    @RdfProperty(value="http://www.konig.io/ns/core/nodeShapeCube")
    public Cube getNodeShapeCube() {
        return this.nodeShapeCube;
    }

    public void setNodeShapeCube(Cube nodeShapeCube) {
        this.nodeShapeCube = nodeShapeCube;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/idComment")
    public String getIdComment() {
        return this.idComment;
    }

    public void setIdComment(String idComment) {
        this.idComment = idComment;
    }
}

