/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.activity.Activity;
import io.konig.core.KonigException;
import io.konig.core.Path;
import io.konig.core.util.IriTemplate;
import io.konig.datasource.DataSource;
import io.konig.formula.FormulaBuilder;
import io.konig.formula.FormulaParser;
import io.konig.formula.QuantifiedExpression;
import io.konig.shacl.AndConstraint;
import io.konig.shacl.NodeKind;
import io.konig.shacl.OrConstraint;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeConsumer;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.XoneConstraint;
import io.konig.shacl.impl.MemoryShapeManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFParseException;

public class ShapeBuilder {
    private PropertyBuilder propertyBuilder;
    private ShapeManager shapeManager;
    private ValueFactory valueFactory = new ValueFactoryImpl();
    private List<Object> stack = new ArrayList<Object>();

    public ShapeBuilder(PropertyBuilder propertyBuilder, ShapeManager shapeManager, ValueFactory valueFactory, Shape shape) {
        this.propertyBuilder = propertyBuilder;
        this.shapeManager = shapeManager;
        this.valueFactory = valueFactory;
        this.stack.add(shape);
    }

    public ShapeBuilder(ShapeManager shapeManager, ValueFactory valueFactory, Shape shape) {
        this.shapeManager = shapeManager;
        this.valueFactory = valueFactory;
        this.stack.add(shape);
    }

    public ShapeBuilder nodeKind(NodeKind kind) {
        this.peekShape().setNodeKind(kind);
        return this;
    }

    public ShapeBuilder derivedFrom(URI ... shapeId) {
        for (URI sId : shapeId) {
            Shape s = this.produceShape(sId);
            this.peekShape().addExplicitDerivedFrom(s);
        }
        return this;
    }

    public PropertyBuilder endValueShape() {
        return this.propertyBuilder;
    }

    public <T> T beginDataSource(Class<T> builderType) {
        Constructor<?> ctor = builderType.getConstructors()[0];
        try {
            return (T)ctor.newInstance(this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Shape getShape(URI uri) {
        return this.shapeManager.getShapeById((Resource)uri);
    }

    public Shape getShape(String uri) {
        return this.shapeManager.getShapeById((Resource)new URIImpl(uri));
    }

    private ShapeConsumer peekConsumer() {
        Object result = this.peek();
        return result instanceof ShapeConsumer ? (ShapeConsumer)result : null;
    }

    private Object peek() {
        return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
    }

    public Shape peekShape() {
        Object result = this.peek();
        return result instanceof Shape ? (Shape)result : null;
    }

    public ShapeBuilder(Shape shape) {
        this.shapeManager = new MemoryShapeManager();
        this.stack.add(shape);
        this.shapeManager.addShape(shape);
    }

    public ShapeBuilder() {
        this.shapeManager = new MemoryShapeManager();
    }

    public ShapeBuilder(ShapeManager shapeManager) {
        this.shapeManager = shapeManager;
    }

    public ShapeBuilder or(Resource ... shapeId) {
        OrConstraint constraint = this.peekShape().getOr();
        if (constraint == null) {
            constraint = new OrConstraint();
            this.peekShape().setOr(constraint);
        }
        for (Resource id : shapeId) {
            Shape shape = this.shapeManager.getShapeById(id);
            if (shape == null) {
                shape = new Shape(id);
                this.shapeManager.addShape(shape);
            }
            constraint.add(shape);
        }
        return this;
    }

    public ShapeBuilder xone(Resource ... shapeId) {
        XoneConstraint constraint = this.peekShape().getXone();
        if (constraint == null) {
            constraint = new XoneConstraint();
            this.peekShape().setXone(constraint);
        }
        for (Resource id : shapeId) {
            Shape shape = this.shapeManager.getShapeById(id);
            if (shape == null) {
                shape = new Shape(id);
                this.shapeManager.addShape(shape);
            }
            constraint.add(shape);
        }
        return this;
    }

    public ShapeBuilder(String shapeId) {
        this((Resource)new URIImpl(shapeId));
    }

    public ShapeBuilder(Resource shapeId) {
        this(new Shape(shapeId));
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    public ShapeBuilder documentation(String text) {
        return this;
    }

    public ShapeBuilder shape(String shapeIRI) {
        return this.beginShape((Resource)new URIImpl(shapeIRI));
    }

    public ShapeBuilder targetClass(URI type) {
        this.peekShape().setTargetClass(type);
        return this;
    }

    public ShapeBuilder tabularOriginShape(URI shapeId) {
        this.beginShape((Resource)shapeId);
        this.endShape();
        Shape shape = this.shapeManager.getShapeById((Resource)shapeId);
        this.peekShape().setTabularOriginShape(shape);
        return this;
    }

    public PropertyBuilder beginProperty(URI predicate) {
        return this.property(predicate);
    }

    public PropertyBuilder beginDerivedProperty(URI predicate) {
        BNode id = this.valueFactory.createBNode();
        PropertyConstraint p = new PropertyConstraint((Resource)id, predicate);
        this.peekShape().addDerivedProperty(p);
        return new PropertyBuilder(this, p);
    }

    public PropertyBuilder property(URI predicate) {
        BNode id = this.valueFactory.createBNode();
        PropertyConstraint p = new PropertyConstraint((Resource)id, predicate);
        this.peekShape().add(p);
        return new PropertyBuilder(this, p);
    }

    private Shape produceShape(URI shapeId) {
        Shape shape = this.shapeManager.getShapeById((Resource)shapeId);
        if (shape == null) {
            shape = new Shape((Resource)shapeId);
            this.shapeManager.addShape(shape);
        }
        return shape;
    }

    public ShapeBuilder wasGeneratedBy(Activity activity) {
        Shape shape = this.peekShape();
        shape.setWasGeneratedBy(activity);
        return this;
    }

    public ShapeBuilder beginOr() {
        OrConstraint constraint = new OrConstraint();
        this.peekShape().setOr(constraint);
        this.stack.add(constraint);
        return this;
    }

    public ShapeBuilder endOr() {
        return this.pop();
    }

    public ShapeBuilder beginAnd() {
        AndConstraint constraint = new AndConstraint();
        this.peekShape().setAnd(constraint);
        this.stack.add(constraint);
        return this;
    }

    public ShapeBuilder endAnd() {
        return this.pop();
    }

    public ShapeBuilder beginShape(Resource resource) {
        Shape shape = resource instanceof URI ? this.produceShape((URI)resource) : new Shape(resource);
        ShapeConsumer consumer = this.peekConsumer();
        if (consumer != null) {
            consumer.add(shape);
        }
        this.stack.add(shape);
        return this;
    }

    public ShapeBuilder beginShape(String iri) {
        URI uri = this.valueFactory.createURI(iri);
        return this.beginShape((Resource)uri);
    }

    public ShapeBuilder beginShape() {
        BNode shapeId = this.valueFactory.createBNode();
        Shape shape = new Shape((Resource)shapeId);
        this.shapeManager.addShape(shape);
        ShapeConsumer consumer = this.peekConsumer();
        if (consumer != null) {
            consumer.add(shape);
        }
        this.stack.add(shape);
        return this;
    }

    public ShapeBuilder datasource(DataSource ds) {
        this.peekShape().addShapeDataSource(ds);
        return this;
    }

    public ShapeBuilder endShape() {
        return this.pop();
    }

    private ShapeBuilder pop() {
        if (!this.stack.isEmpty()) {
            this.stack.remove(this.stack.size() - 1);
        }
        return this;
    }

    public Shape shape() {
        return this.peekShape();
    }

    public ShapeBuilder iriTemplate(String value) {
        IriTemplate template = new IriTemplate(value);
        this.peekShape().setIriTemplate(template);
        return this;
    }

    public static class PropertyBuilder {
        private ShapeBuilder parent;
        private PropertyConstraint property;

        PropertyBuilder(ShapeBuilder parent, PropertyConstraint property) {
            this.parent = parent;
            this.property = property;
        }

        public PropertyConstraint getPropertyConstraint() {
            return this.property;
        }

        public ShapeBuilder beginValueShape(String iri) {
            URI uri = this.parent.valueFactory.createURI(iri);
            return this.beginValueShape(uri);
        }

        public ShapeBuilder beginValueShape() {
            return this.beginValueShape((URI)null);
        }

        public ShapeBuilder endProperty() {
            return this.parent;
        }

        public PropertyBuilder preferredTabularShape(URI shapeId) {
            this.property.setPreferredTabularShape(shapeId);
            return this;
        }

        public PropertyBuilder endValueShape() {
            return this.parent.endValueShape();
        }

        public ShapeBuilder beginValueShape(URI shapeId) {
            Shape shape = null;
            if (shapeId != null) {
                shape = this.parent.shapeManager.getShapeById((Resource)shapeId);
            }
            if (shape == null) {
                shape = new Shape((Resource)shapeId);
                if (shapeId != null) {
                    this.parent.shapeManager.addShape(shape);
                }
            }
            this.property.setShape(shape);
            return new ShapeBuilder(this, this.parent.shapeManager, this.parent.valueFactory, shape);
        }

        public PropertyBuilder stereotype(URI stereotype) {
            this.property.setStereotype(stereotype);
            return this;
        }

        public PropertyBuilder isTimeParam(boolean truth) {
            this.property.setTimeParam(truth);
            return this;
        }

        public PropertyBuilder comment(String text) {
            this.property.setComment(text);
            return this;
        }

        public PropertyBuilder nodeKind(NodeKind kind) {
            this.property.setNodeKind(kind);
            return this;
        }

        public PropertyBuilder allowedValue(Value value) {
            this.property.addIn(value);
            return this;
        }

        public PropertyBuilder allowedIRI(String iri) {
            this.property.addIn((Value)new URIImpl(iri));
            return this;
        }

        public PropertyBuilder minInclusive(double value) {
            this.property.setMinInclusive(value);
            return this;
        }

        public PropertyBuilder maxInclusive(double value) {
            this.property.setMaxInclusive(value);
            return this;
        }

        public PropertyBuilder datatype(URI type) {
            this.property.setDatatype(type);
            return this;
        }

        public PropertyBuilder dimension(URI dimension) {
            this.property.setDimensionTerm(dimension);
            return this;
        }

        public PropertyBuilder maxCount(int value) {
            this.property.setMaxCount(value);
            return this;
        }

        public PropertyBuilder minCount(int value) {
            this.property.setMinCount(value);
            return this;
        }

        public PropertyBuilder equivalentPath(Path value) {
            this.property.setEquivalentPath(value);
            return this;
        }

        public PropertyBuilder formula(String text, URI ... terms) {
            StringBuilder builder = new StringBuilder();
            for (URI term : terms) {
                builder.append("@term ");
                builder.append(term.getLocalName());
                builder.append(" <");
                builder.append(term.stringValue());
                builder.append(">\n");
            }
            builder.append(text);
            return this.formula(builder.toString());
        }

        public PropertyBuilder formula(String text) {
            FormulaParser parser = new FormulaParser();
            try {
                QuantifiedExpression formula = parser.quantifiedExpression(text);
                this.property.setFormula(formula);
            }
            catch (IOException | RDFParseException e) {
                throw new KonigException(e);
            }
            return this;
        }

        public FormulaBuilder beginFormula() {
            return new FormulaBuilder(this);
        }

        public PropertyBuilder valueShape(URI shapeId) {
            Shape shape = this.parent.shapeManager.getShapeById((Resource)shapeId);
            if (shape == null) {
                shape = new Shape((Resource)shapeId);
                this.parent.shapeManager.addShape(shape);
            }
            this.property.setShape(shape);
            return this;
        }

        public PropertyBuilder valueClass(URI type) {
            this.property.setValueClass((Resource)type);
            return this;
        }

        public PropertyBuilder directType(URI type) {
            this.property.setDirectValueType(type);
            return this;
        }

        public PropertyBuilder property(URI predicate) {
            return this.parent.property(predicate);
        }

        public ShapeBuilder shape(String shapeIRI) {
            return this.parent.shape(shapeIRI);
        }

        public Shape shape() {
            return this.parent.shape();
        }

        public ShapeBuilder endShape() {
            return this.parent.endShape();
        }

        public PropertyBuilder in(Object ... objects) {
            ArrayList<Value> list = new ArrayList<Value>();
            for (Object v : objects) {
                if (v instanceof String) {
                    String text = (String)v;
                    list.add((Value)new LiteralImpl(text));
                    continue;
                }
                if (!(v instanceof URI)) continue;
                list.add((Value)((URI)v));
            }
            this.property.setIn(list);
            return this;
        }

        public ShapeBuilder endDerivedProperty() {
            return this.endProperty();
        }
    }
}

