/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.ShapePropertyPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class ShapeReasoner {
    private ShapeManager shapeManager;
    private Map<URI, PropertyInfo> propertyInfo;

    public ShapeReasoner(ShapeManager shapeManager) {
        this.shapeManager = shapeManager;
    }

    public PropertyInfo getPropertyInfo(URI predicate) {
        this.collectPropertyInfo();
        return this.propertyInfo.get(predicate);
    }

    public Set<URI> valueType(URI predicate) {
        this.collectPropertyInfo();
        PropertyInfo result = this.propertyInfo.get(predicate);
        if (result == null) {
            result = new PropertyInfo(predicate);
            this.propertyInfo.put(predicate, result);
        }
        return result.getValueTypes();
    }

    public Set<URI> predicates() {
        this.collectPropertyInfo();
        return this.propertyInfo.keySet();
    }

    private void collectPropertyInfo() {
        if (this.propertyInfo == null) {
            this.propertyInfo = new HashMap<URI, PropertyInfo>();
            for (Shape shape : this.shapeManager.listShapes()) {
                for (PropertyConstraint p : shape.getProperty()) {
                    URI property = p.getPredicate();
                    if (property == null) continue;
                    PropertyInfo info = this.propertyInfo.get(property);
                    if (info == null) {
                        info = new PropertyInfo(property);
                        this.propertyInfo.put(property, info);
                    }
                    this.add(info.getValueTypes(), (Resource)p.getDatatype());
                    this.add(info.getValueTypes(), p.getValueClass());
                    info.addUsage(new ShapePropertyPair(shape, p));
                    Shape valueShape = p.getShape();
                    if (valueShape == null) continue;
                    this.add(info.getValueTypes(), (Resource)valueShape.getTargetClass());
                }
            }
        }
    }

    private void add(Set<URI> set, Resource element) {
        if (element instanceof URI) {
            set.add((URI)element);
        }
    }

    public static class PropertyInfo {
        private URI predicate;
        private List<ShapePropertyPair> usage = new ArrayList<ShapePropertyPair>();
        private Set<URI> values = new HashSet<URI>();

        public PropertyInfo(URI predicate) {
            this.predicate = predicate;
        }

        public void addUsage(ShapePropertyPair pair) {
            this.usage.add(pair);
        }

        public void addValue(URI valueType) {
            this.values.add(valueType);
        }

        public URI getPredicate() {
            return this.predicate;
        }

        public List<ShapePropertyPair> getUsage() {
            return this.usage;
        }

        public Set<URI> getValueTypes() {
            return this.values;
        }
    }
}

