/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.core.Edge;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.path.PathImpl;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Severity;
import io.konig.shacl.Shape;
import io.konig.shacl.ValidationReport;
import io.konig.shacl.ValidationResult;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;

public class ShapeValidator {
    private boolean failFast = true;
    private boolean closed = false;

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean conforms(Vertex focusNode, Shape shape) {
        return this.validate(focusNode, shape, null);
    }

    public boolean validate(Vertex focusNode, Shape shape, ValidationReport report) {
        Context context = report == null ? null : new Context(report, focusNode, shape);
        return this.doValidate(focusNode, shape, context);
    }

    private boolean doValidate(Vertex focusNode, Shape shape, Context context) {
        boolean ok = true;
        List<PropertyConstraint> list = shape.getProperty();
        for (PropertyConstraint p : list) {
            if (this.validateProperty(focusNode, shape, p, context)) continue;
            ok = false;
            if (!this.failFast) continue;
            break;
        }
        if (this.closed) {
            Set<Map.Entry<URI, Set<Edge>>> out = focusNode.outEdges();
            for (Map.Entry<URI, Set<Edge>> e : out) {
                PropertyConstraint p;
                URI predicate = e.getKey();
                if (predicate.equals((Object)RDF.TYPE)) continue;
                if (context != null) {
                    context.push(predicate);
                }
                if ((p = shape.getPropertyConstraint(predicate)) == null) {
                    ok = false;
                    if (context != null) {
                        context.violation("Property not permitted in closed shape");
                    }
                    if (this.failFast) {
                        return ok;
                    }
                }
                if (context == null) continue;
                context.pop();
            }
        }
        return ok;
    }

    private boolean validateProperty(Vertex focusNode, Shape shape, PropertyConstraint p, Context context) {
        boolean ok = true;
        URI predicate = p.getPredicate();
        if (predicate != null) {
            Integer maxCount;
            if (context != null) {
                context.push(predicate);
            }
            Set<Edge> set = focusNode.outProperty(predicate);
            Integer minCount = p.getMinCount();
            if (minCount != null && set.size() < minCount) {
                ok = false;
                if (context != null) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Expected at least ");
                    msg.append(minCount);
                    msg.append(minCount == 1 ? " value but found " : " values but found ");
                    msg.append(set.size());
                    context.violation().setMessage(msg.toString());
                    if (this.failFast) {
                        return false;
                    }
                }
            }
            if ((maxCount = p.getMaxCount()) != null && set.size() > maxCount) {
                ok = false;
                if (context != null) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Expected at most ");
                    msg.append(maxCount);
                    msg.append(maxCount == 1 ? " value but found " : " values but found ");
                    msg.append(set.size());
                    context.violation().setMessage(msg.toString());
                    if (this.failFast) {
                        return false;
                    }
                }
            }
            URI datatype = p.getDatatype();
            Shape childShape = p.getShape();
            NodeKind nodeKind = p.getNodeKind();
            for (Edge edge : set) {
                StringBuilder msg;
                Value object = edge.getObject();
                if (datatype != null) {
                    if (object instanceof Literal) {
                        Literal literal = (Literal)object;
                        URI type = literal.getDatatype();
                        if (type == null) {
                            type = XMLSchema.STRING;
                        }
                        if (!datatype.equals((Object)type)) {
                            ok = false;
                            if (context != null) {
                                StringBuilder msg2 = new StringBuilder();
                                msg2.append("Expected value of type ");
                                msg2.append(context.curie(datatype));
                                msg2.append(" but found ");
                                msg2.append(context.curie(type));
                                context.violation(msg2.toString());
                            }
                            if (this.failFast) {
                                return ok;
                            }
                        }
                    } else {
                        ok = false;
                        if (context != null) {
                            msg = new StringBuilder();
                            msg.append("Expected value of type ");
                            msg.append(context.curie(datatype));
                            msg.append(" but found ");
                            if (object instanceof BNode) {
                                msg.append(" a BNode");
                            } else {
                                msg.append(" <");
                                msg.append(object.stringValue());
                                msg.append(">");
                            }
                            context.violation(msg.toString());
                        }
                        if (this.failFast) {
                            return ok;
                        }
                    }
                }
                if (childShape != null) {
                    if (object instanceof Literal) {
                        ok = false;
                        if (context != null) {
                            msg = new StringBuilder();
                            msg.append("Value must not be a literal but found '");
                            msg.append(object.stringValue());
                            msg.append("'");
                            context.violation(msg.toString());
                        }
                        if (this.failFast) {
                            return ok;
                        }
                    } else {
                        Vertex child = context.getVertex(object);
                        if (child == null) {
                            throw new KonigException("Resource not found: " + object.stringValue());
                        }
                        ok = this.doValidate(child, childShape, context);
                        if (!ok && this.failFast) {
                            return ok;
                        }
                    }
                }
                if (nodeKind == null) continue;
                switch (nodeKind) {
                    case BlankNode: {
                        if (object instanceof BNode) break;
                        ok = false;
                        if (context != null) {
                            msg = new StringBuilder();
                            msg.append("Expected a BNode but found ");
                            if (object instanceof URI) {
                                msg.append("<");
                                msg.append(object.stringValue());
                                msg.append('>');
                            } else {
                                msg.append("'");
                                msg.append(object.stringValue());
                                msg.append("'");
                            }
                            context.violation(msg.toString());
                        }
                        if (!this.failFast) break;
                        return ok;
                    }
                    case BlankNodeOrIRI: {
                        if (!(object instanceof Literal)) break;
                        ok = false;
                        if (context != null) {
                            msg = new StringBuilder();
                            msg.append("Expected a BNode or IRI but found '");
                            msg.append(object.stringValue());
                            msg.append("'");
                            context.violation(msg.toString());
                        }
                        if (!this.failFast) break;
                        return ok;
                    }
                    case IRI: {
                        if (object instanceof URI) break;
                        ok = false;
                        if (context != null) {
                            msg = new StringBuilder();
                            msg.append("Expected an IRI but found ");
                            if (object instanceof BNode) {
                                msg.append(" a BNode");
                            } else {
                                msg.append("'");
                                msg.append(object.stringValue());
                                msg.append("'");
                            }
                            context.violation(msg.toString());
                        }
                        if (!this.failFast) break;
                        return ok;
                    }
                    case Literal: {
                        if (object instanceof Literal) break;
                        ok = false;
                        if (context != null) {
                            msg = new StringBuilder();
                            msg.append("Expected a Literal but found ");
                            if (object instanceof URI) {
                                msg.append("<");
                                msg.append(object.stringValue());
                                msg.append('>');
                            } else {
                                msg.append("a BNode");
                            }
                            context.violation(msg.toString());
                        }
                        if (!this.failFast) break;
                        return ok;
                    }
                }
            }
            if (context != null) {
                context.pop();
            }
        }
        return ok;
    }

    static class Context {
        PathImpl path;
        ValidationReport report;
        Vertex focusNode;
        Shape sourceShape;

        public Context(ValidationReport report, Vertex focusNode, Shape sourceShape) {
            this.focusNode = focusNode;
            this.sourceShape = sourceShape;
            this.report = report;
            this.path = new PathImpl();
        }

        public Vertex getVertex(Value object) {
            if (object instanceof Resource) {
                return this.focusNode.getGraph().getVertex((Resource)object);
            }
            return null;
        }

        public void push(URI predicate) {
            this.path.out(predicate);
        }

        public void pop() {
            this.path.remove(this.path.length() - 1);
        }

        public Object curie(URI uri) {
            NamespaceManager nsManager = this.focusNode.getGraph().getNamespaceManager();
            if (nsManager == null) {
                return "<" + uri.stringValue() + ">";
            }
            return RdfUtil.optionalCurie(nsManager, uri);
        }

        void violation(String message) {
            this.violation().setMessage(message);
        }

        ValidationResult violation() {
            ValidationResult result = new ValidationResult();
            result.setFocusNode(this.focusNode.getId());
            result.setPath(this.path.copy());
            result.setSeverity(Severity.VIOLATION);
            result.setSourceShape(this.sourceShape.getId());
            this.report.addValidationResult(result);
            return result;
        }
    }
}

