/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.shacl.ShapeNamer;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class SimpleShapeNamer
implements ShapeNamer {
    private String baseURL;
    private NamespaceManager nsManager;
    private String prefix = "";
    private String suffix = "";

    public SimpleShapeNamer(NamespaceManager nsManager, String baseURL) {
        this.nsManager = nsManager;
        this.baseURL = baseURL;
    }

    public SimpleShapeNamer(NamespaceManager nsManager, String baseURL, String suffix) {
        this.nsManager = nsManager;
        this.baseURL = baseURL;
        this.suffix = suffix;
    }

    public SimpleShapeNamer(NamespaceManager nsManager, String baseURL, String prefix, String suffix) {
        this.nsManager = nsManager;
        this.baseURL = baseURL;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public URI shapeName(URI scopeClass) throws KonigException {
        String namespace = scopeClass.getNamespace();
        Namespace ns = this.nsManager.findByName(namespace);
        if (ns == null) {
            throw new KonigException("Prefix not found for namespace " + namespace);
        }
        StringBuilder builder = new StringBuilder(this.baseURL);
        builder.append(ns.getPrefix());
        builder.append('/');
        builder.append(this.prefix);
        builder.append(scopeClass.getLocalName());
        builder.append(this.suffix);
        return new URIImpl(builder.toString());
    }
}

