/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.annotation.RdfList;
import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.shacl.Constraint;
import io.konig.shacl.GraphFilter;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeConsumer;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.URI;

@RdfList
public class XoneConstraint
implements Constraint,
ShapeConsumer {
    private List<Shape> shapes = new ArrayList<Shape>();
    private Shape declaringShape;

    @Override
    public List<Shape> getShapes() {
        return this.shapes;
    }

    @Override
    public XoneConstraint add(Shape shape) {
        if (shape == null) {
            throw new KonigException("shape cannot be null");
        }
        if (!this.shapes.contains(shape)) {
            this.shapes.add(shape);
        }
        return this;
    }

    @Override
    public boolean accept(Vertex v) {
        GraphFilter filter = GraphFilter.INSTANCE;
        int count = 0;
        for (Shape s : this.shapes) {
            if (!filter.matches(v, s)) continue;
            ++count;
        }
        return count == 1;
    }

    @Override
    public boolean hasPropertyConstraint(URI predicate) {
        for (Shape s : this.shapes) {
            if (!s.hasPropertyConstraint(predicate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Shape findShapeByTargetClass(URI targetClass) {
        for (Shape s : this.shapes) {
            if (!targetClass.equals((Object)s.getTargetClass())) continue;
            return s;
        }
        return null;
    }

    @Override
    public Shape getDeclaringShape() {
        return this.declaringShape;
    }

    public void setDeclaringShape(Shape s) {
        this.declaringShape = s;
    }
}

