/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.impl;

import io.konig.core.KonigException;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.shacl.AndConstraint;
import io.konig.shacl.OrConstraint;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDFS;

public class ClassAnalyzer {
    private static final Integer ZERO = new Integer(0);
    private ShapeManager shapeManager;
    private OwlReasoner owlReasoner;

    public ClassAnalyzer(ShapeManager shapeManager, OwlReasoner owlReasoner) {
        this.shapeManager = shapeManager;
        this.owlReasoner = owlReasoner;
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    public Shape aggregate(Resource classId) {
        HashMap<String, Shape> map = new HashMap<String, Shape>();
        return this.aggregate(map, classId);
    }

    public void pullDown(Shape shape) {
        AndConstraint and = shape.getAnd();
        if (and != null) {
            HashSet<Shape> memory = new HashSet<Shape>();
            Map<URI, PropertyConstraint> map = this.mapShape(shape);
            LinkedList<Shape> queue = new LinkedList<Shape>();
            for (Shape s : and.getShapes()) {
                queue.add(s);
            }
            while (!queue.isEmpty()) {
                Shape s = (Shape)queue.remove();
                if (memory.contains(s)) continue;
                memory.add(s);
                this.pullDown(s, shape, map);
                and = s.getAnd();
                if (and == null) continue;
                for (Shape t : and.getShapes()) {
                    queue.add(t);
                }
            }
            shape.setAnd(null);
        }
    }

    private void pullDown(Shape s, Shape target, Map<URI, PropertyConstraint> map) {
        for (PropertyConstraint a : s.getProperty()) {
            URI predicate = a.getPredicate();
            if (predicate == null) continue;
            PropertyConstraint b = map.get(predicate);
            if (b == null) {
                PropertyConstraint c = new PropertyConstraint(predicate);
                c.setMinCount(a.getMinCount());
                c.setMaxCount(a.getMaxCount());
                c.setDatatype(a.getDatatype());
                c.setValueClass(this.valueClass(a));
                target.add(c);
                map.put(predicate, c);
                continue;
            }
            this.mergeMinCount(b, a);
            this.mergeMaxCount(b, a);
            this.mergeDatatype(target, b, a);
            Resource valueClassA = this.valueClass(a);
            Resource valueClassB = this.valueClass(b);
            if (valueClassA == null) continue;
            if (valueClassB == null) {
                b.setValueClass(valueClassA);
                continue;
            }
            if (!this.owlReasoner.isSubClassOf(valueClassA, valueClassB)) continue;
            b.setValueClass(valueClassA);
        }
    }

    private Map<URI, PropertyConstraint> mapShape(Shape shape) {
        HashMap<URI, PropertyConstraint> map = new HashMap<URI, PropertyConstraint>();
        for (PropertyConstraint p : shape.getProperty()) {
            map.put(p.getPredicate(), p);
        }
        return map;
    }

    public void pushUp(Shape shape) {
        HashSet<Shape> memory = new HashSet<Shape>();
        HashMap<URI, PropertyConstraint> map = new HashMap<URI, PropertyConstraint>();
        this.addDerivedProperties(memory, map, shape);
        Iterator<PropertyConstraint> sequence = shape.getProperty().iterator();
        while (sequence.hasNext()) {
            PropertyConstraint b = sequence.next();
            PropertyConstraint a = (PropertyConstraint)map.get(b.getPredicate());
            if (a == null) continue;
            URI datatypeA = a.getDatatype();
            URI datatypeB = b.getDatatype();
            if (datatypeB != null && datatypeA != null) {
                if (datatypeB.equals((Object)datatypeA)) {
                    sequence.remove();
                    continue;
                }
                throw new KonigException("Incompatible datatype");
            }
            Resource valueClassA = this.valueClass(a);
            Resource valueClassB = this.valueClass(b);
            if (valueClassA == null || valueClassB == null || !this.owlReasoner.isSubClassOf(valueClassA, valueClassB)) continue;
            sequence.remove();
        }
    }

    private void addDerivedProperties(Set<Shape> memory, Map<URI, PropertyConstraint> map, Shape shape) {
        if (!memory.contains(shape)) {
            memory.add(shape);
            AndConstraint and = shape.getAnd();
            if (and != null) {
                for (Shape s : and.getShapes()) {
                    List<PropertyConstraint> plist = s.getProperty();
                    for (PropertyConstraint p : plist) {
                        URI predicate = p.getPredicate();
                        if (map.containsKey(predicate)) continue;
                        map.put(predicate, p);
                    }
                }
                for (Shape s : and.getShapes()) {
                    this.addDerivedProperties(memory, map, s);
                }
            }
        }
    }

    public void merge(Shape shape) {
        if (shape.getOr() != null) {
            ArrayList<PropertyConstraint> sink = new ArrayList<PropertyConstraint>();
            shape.setPropertyList(sink);
            Map<URI, List<PropertyConstraint>> map = this.orPropertyMap(shape);
            shape.setOr(null);
            for (Map.Entry<URI, List<PropertyConstraint>> e : map.entrySet()) {
                URI predicate = e.getKey();
                List<PropertyConstraint> list = e.getValue();
                PropertyConstraint a = null;
                for (PropertyConstraint b : list) {
                    if (a == null) {
                        a = new PropertyConstraint(predicate);
                        a.setMinCount(this.minCount(b));
                        a.setMaxCount(b.getMaxCount());
                        a.setDatatype(b.getDatatype());
                        a.setValueClass(this.valueClass(b));
                        sink.add(a);
                        continue;
                    }
                    this.mergeMinCount(a, b);
                    this.mergeMaxCount(a, b);
                    this.mergeDatatype(shape, a, b);
                    this.mergeValueClass(a, b);
                }
            }
        }
    }

    private void mergeMaxCount(PropertyConstraint a, PropertyConstraint b) {
        Integer maxCountA = a.getMaxCount();
        Integer maxCountB = b.getMaxCount();
        if (maxCountB == null || maxCountA != null && maxCountB > maxCountA) {
            a.setMaxCount(maxCountB);
        }
    }

    private void mergeMinCount(PropertyConstraint a, PropertyConstraint b) {
        Integer minCountA = a.getMinCount();
        Integer minCountB = this.minCount(b);
        if (minCountB > minCountA) {
            a.setMinCount(minCountB);
        }
    }

    private void mergeValueClass(PropertyConstraint a, PropertyConstraint b) {
        Resource valueClassA = a.getValueClass();
        Resource valueClassB = this.valueClass(b);
        Resource c = this.owlReasoner.leastCommonSuperClass(valueClassA, valueClassB);
        a.setValueClass(c);
    }

    private void mergeDatatype(Shape shape, PropertyConstraint a, PropertyConstraint b) {
        URI typeB = b.getDatatype();
        if (typeB != null) {
            URI typeA = a.getDatatype();
            if (typeA != null && !typeB.equals((Object)typeA)) {
                throw new KonigException("Conflicting datatype: targetClass=" + shape.getTargetClass() + ", predicate=" + a.getPredicate());
            }
            a.setDatatype(typeB);
        }
    }

    private Integer minCount(PropertyConstraint p) {
        Integer minCount = p.getMinCount();
        return minCount == null ? ZERO : minCount;
    }

    private Resource valueClass(PropertyConstraint a) {
        Shape valueShape;
        Resource valueClass = a.getValueClass();
        if (valueClass == null && (valueShape = a.getShape(this.shapeManager)) != null && (valueClass = valueShape.getTargetClass()) == null && valueShape.getOr() != null) {
            valueClass = this.mergeTargetClass(valueShape.getOr().getShapes());
        }
        return valueClass;
    }

    public Resource mergeTargetClass(List<Shape> shapes) {
        URI result = null;
        for (Shape s : shapes) {
            URI targetClass = s.getTargetClass();
            if (result == null) {
                result = targetClass;
                continue;
            }
            result = this.owlReasoner.leastCommonSuperClass((Resource)result, (Resource)targetClass);
        }
        return result;
    }

    private Map<URI, List<PropertyConstraint>> orPropertyMap(Shape shape) {
        HashMap<URI, List<PropertyConstraint>> map = new HashMap<URI, List<PropertyConstraint>>();
        for (Shape s : shape.getOr().getShapes()) {
            for (PropertyConstraint p : s.getProperty()) {
                URI predicate = p.getPredicate();
                ArrayList<PropertyConstraint> list = (ArrayList<PropertyConstraint>)map.get(predicate);
                if (list == null) {
                    list = new ArrayList<PropertyConstraint>();
                    map.put(predicate, list);
                }
                list.add(p);
            }
        }
        return map;
    }

    private Shape aggregate(Map<String, Shape> map, Resource classId) {
        Shape result = map.get(classId.stringValue());
        if (result == null) {
            URI owlClass = classId instanceof URI ? (URI)classId : null;
            List<Object> list = owlClass == null ? new ArrayList() : this.shapeManager.getShapesByTargetClass(owlClass);
            OrConstraint orList = new OrConstraint();
            result = new Shape();
            result.setTargetClass(owlClass);
            result.setOr(orList);
            for (Shape shape : list) {
                orList.add(shape);
            }
            this.buildHierarchy(map, result);
        }
        return result;
    }

    private void buildHierarchy(Map<String, Shape> map, Shape targetShape) {
        URI id = targetShape.getTargetClass();
        String idValue = id.stringValue();
        if (!map.containsKey(idValue)) {
            map.put(idValue, targetShape);
            List<Vertex> superList = this.owlReasoner.getGraph().v((Resource)id).out(RDFS.SUBCLASSOF).toVertexList();
            AndConstraint andList = new AndConstraint();
            targetShape.setAnd(andList);
            for (Vertex superVertex : superList) {
                if (OWL.CLASS.equals((Object)superVertex.getId())) continue;
                Shape superShape = this.aggregate(map, superVertex.getId());
                this.merge(superShape);
                andList.add(superShape);
            }
        }
    }
}

