/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.impl;

import io.konig.core.KonigException;
import io.konig.core.impl.MemoryNamespaceManager;
import io.konig.shacl.impl.MemoryShapeManager;
import io.konig.shacl.io.ShapeLoader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ClasspathShapeManager
extends MemoryShapeManager {
    private static final String RESOURCE_FOLDER = "konig/showl";
    private static ClasspathShapeManager INSTANCE;

    public static ClasspathShapeManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new ClasspathShapeManager();
            INSTANCE.load(RESOURCE_FOLDER);
        }
        return INSTANCE;
    }

    public void load(String path) throws KonigException {
        MemoryNamespaceManager nsManager = new MemoryNamespaceManager();
        ShapeLoader shapeLoader = new ShapeLoader(null, this, nsManager);
        this.load(shapeLoader, path);
    }

    private void load(ShapeLoader loader, String path) {
        try {
            if (path.endsWith(".ttl")) {
                this.loadTurtle(loader, path);
            } else {
                path = path + "/";
                List<String> list = this.getResourceFiles(path);
                for (String resource : list) {
                    this.load(loader, path + resource);
                }
            }
        }
        catch (Throwable e) {
            throw new KonigException("Failed to load " + path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTurtle(ShapeLoader loader, String path) {
        InputStream input = this.getResourceAsStream(path);
        try {
            loader.loadTurtle(input);
        }
        finally {
            this.close(input);
        }
    }

    private void close(Closeable input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private List<String> getResourceFiles(String path) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        try (InputStream in = this.getResourceAsStream(path);
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String resource;
            while ((resource = br.readLine()) != null) {
                filenames.add(resource);
            }
        }
        return filenames;
    }

    private InputStream getResourceAsStream(String resource) {
        InputStream in = this.getContextClassLoader().getResourceAsStream(resource);
        return in == null ? this.getClass().getResourceAsStream(resource) : in;
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

