/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.impl;

import io.konig.core.KonigException;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class MemoryShapeManager
implements ShapeManager {
    private Map<String, Shape> shapeMap = new LinkedHashMap<String, Shape>();

    @Override
    public Shape getShapeById(Resource shapeId) {
        return this.shapeMap.get(shapeId.stringValue());
    }

    @Override
    public void addShape(Shape shape) {
        if (shape.getId() == null) {
            throw new KonigException("Shape has no id value");
        }
        this.shapeMap.put(shape.getId().stringValue(), shape);
    }

    public List<Shape> getShapesByPredicate(URI predicate) {
        ArrayList<Shape> list = new ArrayList<Shape>();
        for (Shape s : this.shapeMap.values()) {
            if (!s.hasPropertyConstraint(predicate)) continue;
            list.add(s);
        }
        return list;
    }

    public void link() {
        ArrayList<Shape> list = new ArrayList<Shape>(this.shapeMap.values());
        for (Shape shape : list) {
            List<PropertyConstraint> constraints = shape.getProperty();
            for (PropertyConstraint p : constraints) {
                Resource resource = p.getShapeId();
                if (!(resource instanceof URI)) continue;
                URI uri = (URI)resource;
                Shape valueShape = this.getShapeById((Resource)uri);
                if (valueShape == null) {
                    throw new KonigException("Shape not found: " + uri);
                }
                p.setShape(valueShape);
            }
        }
    }

    @Override
    public List<Shape> getShapesByTargetClass(URI targetClass) {
        ArrayList<Shape> list = new ArrayList<Shape>();
        for (Shape s : this.shapeMap.values()) {
            if (!targetClass.equals((Object)s.getTargetClass())) continue;
            list.add(s);
        }
        return list;
    }

    @Override
    public List<Shape> listShapes() {
        return new ArrayList<Shape>(this.shapeMap.values());
    }
}

