/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.io;

import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.core.project.ProjectFile;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import io.konig.datasource.TableDataSource;
import io.konig.shacl.Shape;
import io.konig.shacl.io.ShapeEmitter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;

public class DdlFileEmitter
implements ShapeEmitter {
    private Set<URI> datasourceType = new HashSet<URI>();

    public DdlFileEmitter(URI ... acceptDatasourceType) {
        for (URI uri : acceptDatasourceType) {
            this.acceptDatasourceType(uri);
        }
    }

    public void acceptDatasourceType(URI datasourceType) {
        this.datasourceType.add(datasourceType);
    }

    @Override
    public void emitShape(Shape shape, Graph graph) {
        List<DataSource> datasourceList = shape.getShapeDataSource();
        if (datasourceList != null) {
            for (DataSource ds : datasourceList) {
                if (!(ds instanceof TableDataSource)) continue;
                for (URI typeId : ds.getType()) {
                    TableDataSource table;
                    ProjectFile ddlFile;
                    if (!this.datasourceType.contains(typeId) || (ddlFile = (table = (TableDataSource)ds).getDdlFile()) == null) continue;
                    Vertex fileNode = graph.vertex();
                    graph.edge(ds.getId(), Konig.ddlFile, (Value)fileNode.getId());
                    fileNode.addProperty(Konig.baseProject, (Value)ddlFile.getBaseProject().getId());
                    fileNode.addProperty(Konig.relativePath, (Value)this.literal(ddlFile.getRelativePath()));
                }
            }
        }
    }

    private Literal literal(String value) {
        return new LiteralImpl(value);
    }
}

