/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.io;

import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.RdfUtil;
import io.konig.shacl.Shape;
import io.konig.shacl.io.ShapeEmitter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openrdf.rio.RDFHandlerException;

public class ShapeAuxiliaryWriter {
    private List<ShapeEmitter> emitterList = null;
    private File outFile;

    public ShapeAuxiliaryWriter(File outFile) {
        this.outFile = outFile;
    }

    public void addShapeEmitter(ShapeEmitter emitter) {
        if (this.emitterList == null) {
            this.emitterList = new ArrayList<ShapeEmitter>();
        }
        this.emitterList.add(emitter);
    }

    public List<ShapeEmitter> getEmitterList() {
        return this.emitterList == null ? Collections.emptyList() : this.emitterList;
    }

    public void writeAll(NamespaceManager nsManager, Collection<Shape> shapeList) throws IOException, RDFHandlerException {
        if (this.outFile != null && this.emitterList != null && !this.emitterList.isEmpty()) {
            MemoryGraph target = new MemoryGraph(nsManager);
            for (Shape shape : shapeList) {
                for (ShapeEmitter emitter : this.emitterList) {
                    emitter.emitShape(shape, target);
                }
            }
            this.outFile.getParentFile().mkdirs();
            RdfUtil.prettyPrintTurtle(nsManager, (Graph)target, this.outFile);
        }
    }
}

