/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.io;

import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.io.FileGetter;
import java.io.File;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;

public class ShapeFileGetter
implements FileGetter {
    private File baseDir;
    private NamespaceManager nsManager;

    public ShapeFileGetter(File baseDir, NamespaceManager nsManager) {
        this.baseDir = baseDir;
        this.nsManager = nsManager;
    }

    public NamespaceManager getNamespaceManager() {
        return this.nsManager;
    }

    @Override
    public File getFile(URI shapeId) {
        Namespace n = this.nsManager.findByName(shapeId.getNamespace());
        if (n == null) {
            return this.nestedShapeFile(shapeId);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(n.getPrefix());
        builder.append('_');
        builder.append(shapeId.getLocalName());
        builder.append(".ttl");
        return new File(this.baseDir, builder.toString());
    }

    private File nestedShapeFile(URI shapeId) {
        String iriValue = shapeId.stringValue();
        int end = iriValue.lastIndexOf(47);
        while (end > 0) {
            int mark = end + 1;
            String namespaceName = iriValue.substring(0, mark);
            Namespace ns = this.nsManager.findByName(namespaceName);
            if (ns != null) {
                String fileName = iriValue.substring(mark).replace('/', '.');
                StringBuilder builder = new StringBuilder();
                builder.append(ns.getPrefix());
                builder.append('_');
                builder.append(fileName);
                builder.append(".ttl");
                return new File(this.baseDir, builder.toString());
            }
            end = iriValue.lastIndexOf(47, end - 1);
        }
        throw new KonigException("Prefix for namespace not found: " + shapeId.getNamespace());
    }
}

