/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.io;

import io.konig.core.ContextManager;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.KonigValueFactory;
import io.konig.core.NamespaceManager;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.RdfUtil;
import io.konig.core.io.GraphLoadHandler;
import io.konig.core.io.JsonldLoader;
import io.konig.core.pojo.PojoContext;
import io.konig.core.pojo.PojoListener;
import io.konig.core.pojo.SimplePojoFactory;
import io.konig.core.pojo.impl.BasicPojoHandler;
import io.konig.core.pojo.impl.PojoInfo;
import io.konig.core.vocab.SH;
import io.konig.datasource.DataSource;
import io.konig.datasource.DataSourceManager;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.io.MasterDataSourcePojoHandler;
import io.konig.shacl.io.ShapeLoadException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.turtle.TurtleParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeLoader {
    private static final Logger logger = LoggerFactory.getLogger(ShapeLoader.class);
    public static final PojoContext CONTEXT = new PojoContext();
    private ContextManager contextManager;
    private ShapeManager shapeManager;
    private NamespaceManager namespaceManager;
    private ValueFactory valueFactory;
    private RDFHandler listener;

    public ShapeLoader(ContextManager contextManager, ShapeManager shapeManager) {
        this(contextManager, shapeManager, null, null);
    }

    public ShapeLoader(ShapeManager shapeManager) {
        this(null, shapeManager, null, null);
    }

    public ShapeLoader(ContextManager contextManager, ShapeManager shapeManager, NamespaceManager namespaceManager) {
        this(contextManager, shapeManager, namespaceManager, null);
    }

    public ShapeLoader(ContextManager contextManager, ShapeManager shapeManager, NamespaceManager namespaceManager, ValueFactory valueFactory) {
        if (valueFactory == null) {
            valueFactory = new KonigValueFactory();
        }
        this.contextManager = contextManager;
        this.shapeManager = shapeManager;
        this.namespaceManager = namespaceManager;
        this.valueFactory = valueFactory;
    }

    public RDFHandler getListener() {
        return this.listener;
    }

    public void setListener(RDFHandler listener) {
        this.listener = listener;
    }

    public void loadAll(File source) throws ShapeLoadException {
        MemoryGraph graph = new MemoryGraph();
        try {
            RdfUtil.loadTurtle(source, (Graph)graph, this.namespaceManager);
        }
        catch (IOException | RDFHandlerException | RDFParseException e1) {
            throw new ShapeLoadException(e1);
        }
        this.load(graph);
    }

    public void loadTurtle(InputStream input) throws ShapeLoadException {
        this.loadTurtle(input, null);
    }

    public void loadTurtle(InputStream input, URI context) throws ShapeLoadException {
        MemoryGraph graph = new MemoryGraph();
        graph.setNamespaceManager(this.namespaceManager);
        GraphLoadHandler handler = new GraphLoadHandler(graph);
        handler.setQuadContext(context);
        TurtleParser turtle = new TurtleParser();
        turtle.setRDFHandler((RDFHandler)handler);
        try {
            turtle.parse(input, "");
        }
        catch (Throwable oops) {
            throw new ShapeLoadException(oops);
        }
        this.load(graph);
    }

    public void loadJsonld(InputStream input) throws ShapeLoadException {
        MemoryGraph graph = new MemoryGraph();
        JsonldLoader loader = new JsonldLoader();
        try {
            loader.load(input, (Graph)graph, this.contextManager, this.namespaceManager);
            this.load(graph);
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            throw new ShapeLoadException(e);
        }
    }

    public void load(Graph graph) throws ShapeLoadException {
        PojoContext context = new PojoContext(CONTEXT);
        context.putPojoHandler(Shape.class, new ShapePojoHandler(this.shapeManager));
        context.putPojoHandler(DataSource.class, new MasterDataSourcePojoHandler());
        context.setListener(new PojoListener(){

            @Override
            public void map(Resource id, Object pojo) {
                if (pojo instanceof Shape && id instanceof URI) {
                    ShapeLoader.this.shapeManager.addShape((Shape)pojo);
                }
            }
        });
        SimplePojoFactory factory = new SimplePojoFactory(context);
        factory.createAll(graph);
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    static {
        CONTEXT.mapClass((Resource)SH.Shape, Shape.class);
    }

    private static class ShapePojoHandler
    extends BasicPojoHandler {
        private ShapeManager shapeManager;

        public ShapePojoHandler(ShapeManager shapeManager) {
            super(Shape.class);
            this.shapeManager = shapeManager;
        }

        @Override
        protected Object newInstance(PojoInfo pojoInfo) throws KonigException {
            Resource id = pojoInfo.getVertex().getId();
            Shape shape = this.shapeManager.getShapeById(id);
            if (shape != null) {
                return shape;
            }
            DataSource ds = DataSourceManager.getInstance().findDataSourceById(id);
            if (ds != null) {
                return ds;
            }
            return super.newInstance(pojoInfo);
        }
    }
}

