/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.io.json;

import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.Schema;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.io.json.ValueSelector;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class JsonWriter {
    private JsonGenerator json;
    private ValueSelector valueSelector;
    private Graph graph;
    private OwlReasoner owlReasoner;
    private NamespaceManager nsManager;

    public JsonWriter(OwlReasoner reasoner, JsonGenerator json) {
        this.owlReasoner = reasoner;
        this.graph = this.owlReasoner.getGraph();
        this.nsManager = this.graph.getNamespaceManager();
        this.json = json;
    }

    public JsonWriter(JsonGenerator json, ValueSelector valueSelector) {
        this.json = json;
        this.valueSelector = valueSelector;
    }

    public ValueSelector getValueSelector() {
        return this.valueSelector;
    }

    public void setValueSelector(ValueSelector valueSelector) {
        this.valueSelector = valueSelector;
    }

    public void write(Shape shape, Vertex subject) throws IOException {
        Graph g = subject.getGraph();
        this.json.writeStartObject();
        this.writeId(shape, subject);
        List<PropertyConstraint> list = shape.getProperty();
        for (PropertyConstraint p : list) {
            this.writeProperty(subject, p);
        }
        this.json.writeEndObject();
    }

    private void writeProperty(Vertex subject, PropertyConstraint p) throws IOException {
        Integer maxCount = p.getMaxCount();
        Set<Value> set = subject.getValueSet(p.getPredicate());
        boolean isMultiValue = maxCount == null || maxCount > 1;
        URI predicate = p.getPredicate();
        this.json.writeFieldName(predicate.getLocalName());
        if (isMultiValue) {
            this.json.writeStartArray();
            for (Value v : set) {
                this.writeValue(subject, p, v);
            }
            this.json.writeEndArray();
        } else if (set.isEmpty()) {
            this.json.writeNull();
        } else {
            Value value = null;
            if (set.size() == 1) {
                value = set.iterator().next();
            } else if (this.valueSelector != null) {
                value = this.valueSelector.select(subject, predicate, set);
            } else {
                StringBuilder msg = new StringBuilder();
                msg.append("Expected single value for ");
                msg.append(predicate.getLocalName());
                msg.append(" property of ");
                msg.append(subject.getId().stringValue());
                msg.append(" but found ");
                for (Value v : set) {
                    msg.append(v.stringValue());
                    msg.append(' ');
                }
                throw new KonigException(msg.toString());
            }
            this.writeValue(subject, p, value);
        }
    }

    private void writeValue(Vertex subject, PropertyConstraint p, Value value) throws IOException {
        if (value == null) {
            this.json.writeNull();
        } else if (value instanceof Literal) {
            Literal literal = (Literal)value;
            String text = literal.stringValue();
            URI datatype = literal.getDatatype();
            if (datatype != null) {
                if (this.owlReasoner.isBooleanType(datatype)) {
                    this.json.writeBoolean("true".equalsIgnoreCase(text));
                } else if (this.owlReasoner.isIntegerDatatype(datatype)) {
                    this.json.writeNumber(Long.parseLong(text));
                } else if (this.owlReasoner.isRealNumber(datatype)) {
                    this.json.writeNumber(Double.parseDouble(text));
                } else {
                    this.json.writeString(text);
                }
            } else {
                this.json.writeString(text);
            }
        } else if (value instanceof Resource) {
            Resource id = (Resource)value;
            Vertex object = subject.getGraph().getVertex(id);
            if (object == null) {
                throw new KonigException("Resource not found: " + id);
            }
            if (p.getShapeId() != null) {
                Shape shape = p.getShape();
                if (shape == null) {
                    throw new KonigException("Shape not found: " + p.getShapeId());
                }
                this.write(shape, object);
            } else if (this.nsManager != null && id instanceof URI && this.owlReasoner.instanceOf(id, Schema.Enumeration)) {
                URI uri = (URI)id;
                String namespace = uri.getNamespace();
                Namespace ns = this.nsManager.findByName(namespace);
                if (ns == null) {
                    this.json.writeString(id.stringValue());
                } else {
                    this.json.writeString(uri.getLocalName());
                }
            } else {
                this.json.writeString(id.stringValue());
            }
        }
    }

    private void writeId(Shape shape, Vertex subject) throws IOException {
        NodeKind nodeKind = shape.getNodeKind();
        if (nodeKind == NodeKind.IRI || nodeKind == NodeKind.BlankNodeOrIRI) {
            Resource id = subject.getId();
            if (id instanceof URI) {
                URI uri = (URI)id;
                String idValue = null;
                URI idFormat = shape.getIdFormat();
                idValue = Konig.Curie.equals((Object)idFormat) ? RdfUtil.curie(uri, this.nsManager) : (Konig.LocalName.equals((Object)idFormat) ? uri.getLocalName() : uri.stringValue());
                this.json.writeStringField("id", idValue);
            } else if (nodeKind == NodeKind.IRI) {
                throw new KonigException("Invalid shape: expecting IRI id");
            }
        }
    }
}

