/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.sample;

import io.konig.core.Context;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.path.HasStep;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.RandomGenerator;
import io.konig.core.util.SimpleValueMap;
import io.konig.core.util.ValueFormat;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.LocalTime;
import org.joda.time.format.ISODateTimeFormat;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SampleGenerator.class);
    private int maxValueCount = 3;
    private int stringWordCount = 4;
    private long startDate = 1492418400000L;
    private long endDate = 1493023200000L;
    private long maxDuration = 120000L;
    private int maxDouble = 10000;
    private int maxInt = 100;
    private boolean failWhenEnumHasNoMembers = false;
    private String undefinedFieldType = "?";
    private static final String[] languageCodes = new String[]{"en", "de", "fr", "ja"};
    private OwlReasoner reasoner;

    public SampleGenerator(OwlReasoner reasoner) {
        this.reasoner = reasoner;
    }

    public String getUndefinedFieldType() {
        return this.undefinedFieldType;
    }

    public void setUndefinedFieldType(String undefinedFieldType) {
        this.undefinedFieldType = undefinedFieldType;
    }

    public boolean isFailWhenEnumHasNoMembers() {
        return this.failWhenEnumHasNoMembers;
    }

    public void setFailWhenEnumHasNoMembers(boolean failWhenEnumerationHasNoMembers) {
        this.failWhenEnumHasNoMembers = failWhenEnumerationHasNoMembers;
    }

    public Vertex generate(Shape shape, Graph graph) {
        Worker worker = new Worker(graph);
        return worker.generate(shape);
    }

    private class Worker {
        private Graph graph;
        private RandomGenerator random;
        private Set<Shape> memory = new HashSet<Shape>();

        public Worker(Graph graph) {
            this.graph = graph;
        }

        public Vertex generate(Shape shape) {
            this.random = new RandomGenerator(shape.getId().hashCode());
            return this.generateShape(shape);
        }

        private Vertex generateShape(Shape shape) {
            Vertex v = this.generateVertex(shape);
            if (!this.memory.contains(shape)) {
                this.memory.add(shape);
                this.addProperties(v, shape);
            }
            return v;
        }

        private void addProperties(Vertex v, Shape shape) {
            for (PropertyConstraint p : shape.getProperty()) {
                Set<Edge> set;
                if (p.getPredicate() == null || (set = v.outProperty(p.getPredicate())) != null && !set.isEmpty()) continue;
                this.addProperty(shape, p, v);
            }
        }

        private void addProperty(Shape shape, PropertyConstraint p, Vertex v) {
            int valueCount;
            Integer maxCount = p.getMaxCount();
            Integer minCount = p.getMinCount();
            int n = valueCount = maxCount == null ? SampleGenerator.this.maxValueCount : Math.min(SampleGenerator.this.maxValueCount, maxCount);
            if (valueCount == 0) {
                return;
            }
            if (minCount != null) {
                valueCount = Math.max(valueCount, minCount);
            }
            for (int i = 0; i < valueCount; ++i) {
                Value object = this.generateValue(shape, p);
                v.addProperty(p.getPredicate(), object);
            }
        }

        private Value generateValue(Shape shape, PropertyConstraint p) {
            URI datatype = p.getDatatype();
            if (datatype != null) {
                String value = null;
                if (XMLSchema.STRING.equals((Object)datatype) || XMLSchema.NORMALIZEDSTRING.equals((Object)datatype)) {
                    value = this.random.loremIpsum(SampleGenerator.this.stringWordCount);
                } else if (XMLSchema.ANYURI.equals((Object)datatype)) {
                    value = this.randomURI("resource").stringValue();
                } else if (XMLSchema.BOOLEAN.equals((Object)datatype)) {
                    value = Boolean.toString(this.random.nextBoolean());
                } else if (XMLSchema.BYTE.equals((Object)datatype)) {
                    value = Byte.toString(this.random.nextByte());
                } else if (XMLSchema.DATE.equals((Object)datatype)) {
                    value = this.nextDate();
                } else if (XMLSchema.DATETIME.equals((Object)datatype)) {
                    value = this.nextDateTime();
                } else if (XMLSchema.DAYTIMEDURATION.equals((Object)datatype)) {
                    value = this.nextDuration();
                } else if (XMLSchema.DOUBLE.equals((Object)datatype) || XMLSchema.DECIMAL.equals((Object)datatype) || XMLSchema.FLOAT.equals((Object)datatype)) {
                    value = this.nextDouble();
                } else if (XMLSchema.INT.equals((Object)datatype) || XMLSchema.INTEGER.equals((Object)datatype) || XMLSchema.LONG.equals((Object)datatype) || XMLSchema.NON_NEGATIVE_INTEGER.equals((Object)datatype) || XMLSchema.POSITIVE_INTEGER.equals((Object)datatype)) {
                    value = this.nextInt();
                } else if (XMLSchema.NEGATIVE_INTEGER.equals((Object)datatype) || XMLSchema.NON_POSITIVE_INTEGER.equals((Object)datatype)) {
                    value = this.nextNegativeInt();
                } else if (XMLSchema.SHORT.equals((Object)datatype)) {
                    value = this.nextShort();
                } else if (XMLSchema.TIME.equals((Object)datatype)) {
                    value = this.nextTime();
                } else if (XMLSchema.TOKEN.equals((Object)datatype)) {
                    value = this.random.loremIpsum(1);
                } else if (XMLSchema.DURATION.equals((Object)datatype)) {
                    value = this.random.nextDuration();
                } else if (XMLSchema.GYEAR.equals((Object)datatype)) {
                    int currentYear = GregorianCalendar.getInstance().get(1);
                    int future = this.random.nextInt(10);
                    value = Integer.toString(currentYear - 3 + future);
                } else {
                    if (RDF.LANGSTRING.equals((Object)datatype)) {
                        value = this.random.loremIpsum(SampleGenerator.this.stringWordCount);
                        String lang = languageCodes[this.random.nextInt(languageCodes.length)];
                        return new LiteralImpl(value, lang);
                    }
                    String msg = MessageFormat.format("On shape <{0}>, unsupported datatype: <{1}>", shape.getId().stringValue(), datatype.stringValue());
                    throw new KonigException(msg);
                }
                return new LiteralImpl(value, datatype);
            }
            Shape valueShape = p.getShape();
            if (valueShape != null) {
                return this.generateShape(valueShape).getId();
            }
            Resource valueClass = p.getValueClass();
            if (valueClass != null) {
                return this.iriReference(valueClass);
            }
            if (RDF.TYPE.equals((Object)p.getPredicate()) && shape.getTargetClass() != null) {
                return this.iriReference((Resource)shape.getTargetClass());
            }
            if (SampleGenerator.this.undefinedFieldType != null) {
                return new LiteralImpl(SampleGenerator.this.undefinedFieldType);
            }
            String msg = MessageFormat.format("On shape <{0}>, unsupported property: <{1}>", shape.getId().stringValue(), p.getPredicate().stringValue());
            throw new KonigException(msg);
        }

        private Value iriReference(Resource valueClass) {
            if (SampleGenerator.this.reasoner.isEnumerationClass(valueClass)) {
                Vertex owlClass = SampleGenerator.this.reasoner.getGraph().getVertex(valueClass);
                if (owlClass == null) {
                    throw new KonigException("Enumeration values not defined for " + valueClass);
                }
                List<Value> list = owlClass.asTraversal().in(RDF.TYPE).toValueList();
                if (list.isEmpty()) {
                    if (SampleGenerator.this.failWhenEnumHasNoMembers) {
                        throw new KonigException("Enumeration values not defined for " + valueClass);
                    }
                    logger.warn("Enumeration values not defined for {}", (Object)valueClass.stringValue());
                } else {
                    int index = this.random.nextInt(list.size());
                    return list.get(index);
                }
            }
            String typeName = "resource";
            if (valueClass instanceof URI) {
                URI uri = (URI)valueClass;
                typeName = uri.getLocalName();
            }
            return this.randomURI(typeName);
        }

        private String nextTime() {
            long instant = this.random.nextLong(SampleGenerator.this.startDate, SampleGenerator.this.endDate);
            LocalTime time = new LocalTime(instant);
            return time.toString();
        }

        private String nextShort() {
            short value = (short)this.random.nextInt(Short.MAX_VALUE);
            return Short.toString(value);
        }

        private String nextNegativeInt() {
            int value = -this.random.nextInt(SampleGenerator.this.maxInt);
            return Integer.toString(value);
        }

        private String nextInt() {
            int value = this.random.nextInt(SampleGenerator.this.maxInt);
            return Integer.toString(value);
        }

        private String nextDouble() {
            double value = (double)this.random.nextInt(SampleGenerator.this.maxDouble) / 100.0;
            return Double.toString(value);
        }

        private String nextDuration() {
            Duration duration = new Duration(this.random.nextLong(1000L, SampleGenerator.this.maxDuration));
            return duration.toString();
        }

        private String nextDateTime() {
            long instant = this.random.nextLong(SampleGenerator.this.startDate, SampleGenerator.this.endDate);
            DateTime localTime = new DateTime(instant).toDateTime(DateTimeZone.UTC);
            return localTime.toString();
        }

        private String nextDate() {
            long instant = this.random.nextLong(SampleGenerator.this.startDate, SampleGenerator.this.endDate);
            DateTime localTime = new DateTime(instant).toDateTime(DateTimeZone.UTC);
            return localTime.toString(ISODateTimeFormat.date());
        }

        private Vertex generateVertex(Shape shape) {
            IriTemplate template = shape.getIriTemplate();
            if (template == null) {
                if (shape.getNodeKind() == NodeKind.IRI || shape.getNodeKind() == NodeKind.BlankNodeOrIRI) {
                    String typeName = shape.getTargetClass() == null ? "resource" : shape.getTargetClass().getLocalName();
                    return this.graph.vertex((Resource)this.randomURI(typeName));
                }
            } else {
                URI id = this.generateIri(shape);
                return this.graph.vertex((Resource)id);
            }
            return this.graph.vertex((Resource)new BNodeImpl(this.random.alphanumeric(8)));
        }

        private URI generateIri(Shape shape) {
            IriTemplate template = shape.getIriTemplate();
            List<? extends ValueFormat.Element> list = template.toList();
            ArrayList<HasStep.PredicateValuePair> valueList = new ArrayList<HasStep.PredicateValuePair>();
            SimpleValueMap map = new SimpleValueMap();
            Context context = template.getContext();
            for (ValueFormat.Element element : list) {
                if (element.getType() != ValueFormat.ElementType.VARIABLE) continue;
                String propertyName = element.getText();
                String propertyIri = context.expandIRI(propertyName);
                URIImpl predicate = new URIImpl(propertyIri);
                PropertyConstraint p = shape.getPropertyConstraint((URI)predicate);
                if (p == null) {
                    throw new KonigException("On shape <" + shape.getId() + "> property not found: " + propertyName);
                }
                Value value = this.generateIdValue(shape, p);
                valueList.add(new HasStep.PredicateValuePair((URI)predicate, value));
                map.put(propertyName, value.stringValue());
            }
            URI subject = null;
            try {
                subject = template.expand(map);
            }
            catch (Throwable throwable) {
                String text = template.format(map);
                if (shape.getId() instanceof URI) {
                    String shapeId = shape.getId().stringValue();
                    if (shapeId.endsWith("#") || shapeId.endsWith("/")) {
                        shapeId = shapeId.substring(0, shapeId.length() - 1);
                    }
                    subject = new URIImpl(shapeId + "/" + text);
                }
                subject = shape.getTargetClass() != null ? new URIImpl("http://example.com/" + shape.getTargetClass().getLocalName() + this.random.alphanumeric(5)) : new URIImpl("http://example.com/resource/" + this.random.alphanumeric(5));
            }
            for (HasStep.PredicateValuePair pair : valueList) {
                URI predicate = pair.getPredicate();
                Value object = pair.getValue();
                this.graph.edge((Resource)subject, predicate, object);
            }
            return subject;
        }

        private Value generateIdValue(Shape shape, PropertyConstraint p) {
            URI datatype = p.getDatatype();
            if (datatype != null && (XMLSchema.STRING.equals((Object)datatype) || XMLSchema.NORMALIZEDSTRING.equals((Object)datatype) || XMLSchema.TOKEN.equals((Object)datatype))) {
                String value = this.random.alphanumeric(9);
                return new LiteralImpl(value, datatype);
            }
            return this.generateValue(shape, p);
        }

        private URI randomURI(String typeName) {
            StringBuilder builder = new StringBuilder();
            builder.append("http://example.com/");
            builder.append(typeName);
            builder.append('/');
            builder.append(this.random.alphanumeric(8));
            return new URIImpl(builder.toString());
        }
    }
}

