/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.services;

import io.konig.core.Vertex;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.ShapeValidator;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class ShapeMatcher {
    private ShapeManager shapeManager;
    private ShapeValidator validator;

    public ShapeMatcher(ShapeManager shapeManager) {
        this.shapeManager = shapeManager;
        this.validator = new ShapeValidator();
        this.validator.setClosed(true);
    }

    public Shape bestMatch(List<Vertex> individuals, URI owlClass) {
        List<Shape> candidates = this.shapeManager.getShapesByTargetClass(owlClass);
        Shape bestShape = null;
        int minPropertyCount = Integer.MAX_VALUE;
        for (Shape shape : candidates) {
            for (Vertex v : individuals) {
                Resource bestShapeId;
                Resource shapeId;
                if (!this.validator.conforms(v, shape)) continue;
                int count = this.propertyCount(shape);
                if (bestShape == null || count < minPropertyCount) {
                    bestShape = shape;
                    minPropertyCount = count;
                    continue;
                }
                if (bestShape == null || count != minPropertyCount || (shapeId = shape.getId()) == null || (bestShapeId = bestShape.getId()) != null && shapeId.stringValue().compareTo(bestShapeId.stringValue()) >= 0) continue;
                bestShape = shape;
                minPropertyCount = count;
            }
        }
        return bestShape;
    }

    private int propertyCount(Shape shape) {
        int count = 0;
        for (PropertyConstraint p : shape.getProperty()) {
            if (p.getPredicate() == null) continue;
            ++count;
            Shape childShape = p.getShape();
            if (childShape == null) continue;
            count += this.propertyCount(childShape);
        }
        return count;
    }
}

