/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.services;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.SimpleValueMap;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.ShapeVisitor;
import io.konig.shacl.services.ShapeMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;

public class ShapeProducer {
    private NamespaceManager nsManager;
    private ShapeMatcher matcher;
    private ShapeVisitor visitor;

    public ShapeProducer(NamespaceManager nsManager, ShapeManager shapeManager) {
        this.nsManager = nsManager;
        this.matcher = new ShapeMatcher(shapeManager);
    }

    public ShapeVisitor getVisitor() {
        return this.visitor;
    }

    public void setVisitor(ShapeVisitor visitor) {
        this.visitor = visitor;
    }

    public Shape produceShape(Vertex targetClass, IriTemplate shapeIdTemplate) {
        return this.produceShape(targetClass, null, shapeIdTemplate);
    }

    public Shape produceShape(Vertex targetClass, URI shapeId) {
        return this.produceShape(targetClass, shapeId, null);
    }

    private Shape produceShape(Vertex targetClass, URI shapeId, IriTemplate shapeIdTemplate) {
        Worker worker = new Worker(targetClass);
        return worker.produceShape(targetClass, shapeId, shapeIdTemplate);
    }

    private class Worker {
        private SimpleValueMap valueMap;
        private Vertex targetClass;
        private URI shapeId;
        private OwlReasoner reasoner;

        public Worker(Vertex targetClass) {
            this.targetClass = targetClass;
            this.valueMap = new SimpleValueMap();
            this.reasoner = new OwlReasoner(this.graph());
        }

        Graph graph() {
            return this.targetClass.getGraph();
        }

        public Shape produceShape(Vertex targetClass, URI shapeId, IriTemplate shapeIdTemplate) {
            Shape shape = null;
            Resource id = targetClass.getId();
            if (id instanceof URI) {
                URI targetClassId = (URI)id;
                List<Vertex> individuals = targetClass.asTraversal().in(RDF.TYPE).toVertexList();
                shape = ShapeProducer.this.matcher.bestMatch(individuals, targetClassId);
                if (shape == null) {
                    if (shapeId == null) {
                        shapeId = this.shapeId(targetClassId, shapeIdTemplate);
                    }
                    if (this.shapeId == null) {
                        this.shapeId = shapeId;
                    }
                    shape = new Shape((Resource)shapeId);
                    shape.setNodeKind(NodeKind.IRI);
                    shape.setTargetClass(targetClassId);
                    HashMap<URI, List<Vertex>> bnodeMap = new HashMap<URI, List<Vertex>>();
                    this.addProperties(shape, individuals, bnodeMap);
                    this.handleBNodes(shape, bnodeMap);
                    if (ShapeProducer.this.visitor != null) {
                        ShapeProducer.this.visitor.visit(shape);
                    }
                }
            }
            return shape;
        }

        private void handleBNodes(Shape shape, Map<URI, List<Vertex>> bnodeMap) {
            for (Map.Entry<URI, List<Vertex>> e : bnodeMap.entrySet()) {
                URI predicate = e.getKey();
                List<Vertex> list = e.getValue();
                PropertyConstraint p = shape.getPropertyConstraint(predicate);
                URI targetClass = this.range(p.getPredicate());
                Shape valueShape = null;
                if (targetClass != null) {
                    valueShape = ShapeProducer.this.matcher.bestMatch(list, targetClass);
                }
                if (valueShape == null) {
                    URI shapeId = this.nestedShapeId(shape, p);
                    valueShape = new Shape((Resource)shapeId);
                    valueShape.setTargetClass(targetClass);
                    HashMap<URI, List<Vertex>> map = new HashMap<URI, List<Vertex>>();
                    this.addProperties(valueShape, list, map);
                    if (ShapeProducer.this.visitor != null) {
                        ShapeProducer.this.visitor.visit(valueShape);
                    }
                }
                p.setShape(valueShape);
            }
        }

        private URI nestedShapeId(Shape shape, PropertyConstraint p) {
            StringBuilder builder = new StringBuilder();
            builder.append(shape.getId().stringValue());
            builder.append('/');
            builder.append(p.getPredicate().getLocalName());
            return new URIImpl(builder.toString());
        }

        private URI range(URI predicate) {
            Value range;
            Vertex v;
            if (predicate != null && (v = this.graph().getVertex((Resource)predicate)) != null && (range = v.getValue(RDFS.RANGE)) instanceof URI) {
                return (URI)range;
            }
            return null;
        }

        private void addProperties(Shape shape, List<Vertex> individuals, Map<URI, List<Vertex>> bnodeMap) {
            for (Vertex v : individuals) {
                this.handleIndividual(shape, v, bnodeMap);
            }
        }

        private void handleIndividual(Shape shape, Vertex v, Map<URI, List<Vertex>> bnodeMap) {
            Set<Map.Entry<URI, Set<Edge>>> set = v.outEdges();
            for (Map.Entry<URI, Set<Edge>> e : set) {
                URI predicate = e.getKey();
                if (predicate == RDF.TYPE) continue;
                Set<Edge> edges = e.getValue();
                PropertyConstraint p = shape.getPropertyConstraint(predicate);
                boolean unbounded = false;
                if (p == null) {
                    p = new PropertyConstraint(predicate);
                    shape.add(p);
                } else {
                    unbounded = p.getMaxCount() == null;
                }
                p.setMinCount(0);
                p.setMaxCount(edges.size() == 1 && !unbounded ? Integer.valueOf(1) : null);
                for (Edge edge : edges) {
                    this.setValueType(shape, p, edge, bnodeMap);
                }
            }
        }

        private void setValueType(Shape shape, PropertyConstraint p, Edge edge, Map<URI, List<Vertex>> bnodeMap) {
            URI priorDatatype = p.getDatatype();
            Value object = edge.getObject();
            if (object instanceof Literal) {
                Literal literal = (Literal)object;
                URI datatype = literal.getDatatype();
                if (datatype == null) {
                    datatype = XMLSchema.STRING;
                }
                if (priorDatatype == null) {
                    p.setDatatype(datatype);
                } else if (!priorDatatype.equals((Object)datatype)) {
                    StringBuilder err = new StringBuilder();
                    err.append("Conflicting datatypes for ");
                    err.append(this.localName(shape));
                    err.append('.');
                    err.append(p.getPredicate().getLocalName());
                    err.append(": <");
                    err.append(priorDatatype.stringValue());
                    err.append("> and <");
                    err.append(datatype.stringValue());
                    err.append(">");
                    throw new KonigException(err.toString());
                }
            } else if (object instanceof BNode) {
                NodeKind kind = p.getNodeKind();
                p.setNodeKind(NodeKind.or(kind, NodeKind.BlankNode));
                URI predicate = edge.getPredicate();
                Vertex v = this.graph().getVertex((Resource)object);
                List<Vertex> list = bnodeMap.get(predicate);
                if (list == null) {
                    list = new ArrayList<Vertex>();
                    bnodeMap.put(predicate, list);
                }
                list.add(v);
            } else {
                NodeKind kind = p.getNodeKind();
                p.setNodeKind(NodeKind.or(kind, NodeKind.IRI));
                URI objectId = (URI)object;
                Resource valueClass = p.getValueClass();
                if (valueClass == null) {
                    valueClass = this.range(p.getPredicate());
                }
                URI objectType = this.type((Resource)objectId);
                valueClass = this.reasoner.leastCommonSuperClass(valueClass, (Resource)objectType);
                p.setValueClass(valueClass);
            }
        }

        private URI type(Resource objectId) {
            Vertex v = this.graph().getVertex(objectId);
            if (v != null) {
                Set<Edge> out = v.outProperty(RDF.TYPE);
                Resource best = null;
                for (Edge edge : out) {
                    Resource type = (Resource)edge.getObject();
                    if (best == null) {
                        best = type;
                        continue;
                    }
                    best = this.reasoner.leastCommonSuperClass(best, type);
                }
                if (best instanceof URI) {
                    return (URI)best;
                }
            }
            return null;
        }

        private String localName(Shape shape) {
            return ((URI)shape.getId()).getLocalName();
        }

        private URI shapeId(URI targetClassId, IriTemplate shapeIdTemplate) {
            String classLocalName = targetClassId.getLocalName();
            String classNamespaceIri = targetClassId.getNamespace();
            Namespace n = ShapeProducer.this.nsManager.findByName(classNamespaceIri);
            String classNamespacePrefix = n == null ? null : n.getPrefix();
            this.valueMap.put("classLocalName", classLocalName);
            this.valueMap.put("classNamespacePrefix", classNamespacePrefix);
            return shapeIdTemplate.expand(this.valueMap);
        }
    }
}

