/*
 * Decompiled with CFR 0.152.
 */
package io.konig.validation;

import io.konig.core.NamespaceManager;
import io.konig.validation.ClassReport;
import io.konig.validation.IdNamePair;
import io.konig.validation.ModelStatistics;
import io.konig.validation.ModelValidationRequest;
import io.konig.validation.NamedIndividualReport;
import io.konig.validation.NodeShapeReport;
import io.konig.validation.PropertyReport;
import io.konig.validation.PropertyShapeReference;
import io.konig.validation.ReportElement;
import io.konig.validation.Sum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class ModelValidationReport
implements ReportElement {
    private NamespaceManager namespaceManager;
    private Map<URI, ClassReport> classReports = new HashMap<URI, ClassReport>();
    private Map<URI, PropertyReport> propertyReports = new HashMap<URI, PropertyReport>();
    private Map<URI, NamedIndividualReport> individualReports = new HashMap<URI, NamedIndividualReport>();
    private ModelValidationRequest request;
    private List<URI> classPropertyDisjointViolation = new ArrayList<URI>();
    private List<NodeShapeReport> shapeReports = new ArrayList<NodeShapeReport>();
    private List<PropertyShapeReference> propertyShapeCaseViolation = new ArrayList<PropertyShapeReference>();
    private IdNamePair project;
    private GregorianCalendar createdTimestamp = (GregorianCalendar)GregorianCalendar.getInstance();
    private ModelStatistics statistics;

    public ClassReport findClassReport(URI classId) {
        return this.classReports.get(classId);
    }

    public void add(ClassReport report) {
        this.classReports.put(report.getClassId(), report);
    }

    public Collection<ClassReport> getClassReports() {
        return this.classReports.values();
    }

    public Collection<PropertyReport> getPropertyReports() {
        return this.propertyReports.values();
    }

    public void add(PropertyReport report) {
        this.propertyReports.put(report.getPropertyId(), report);
    }

    public PropertyReport findPropertyReport(URI propertyId) {
        return this.propertyReports.get(propertyId);
    }

    public Collection<NamedIndividualReport> getNamedIndividualReports() {
        return this.individualReports.values();
    }

    public void add(NamedIndividualReport report) {
        this.individualReports.put(report.getIndividualId(), report);
    }

    public NamedIndividualReport findNamedIndividualReport(URI individualId) {
        return this.individualReports.get(individualId);
    }

    public List<PropertyShapeReference> getPropertyShapeCaseViolation() {
        return this.propertyShapeCaseViolation;
    }

    public List<URI> getClassPropertyDisjointViolation() {
        return this.classPropertyDisjointViolation;
    }

    public NodeShapeReport findNodeReport(Resource shapeId) {
        for (NodeShapeReport n : this.shapeReports) {
            if (!shapeId.equals(n.getShapeId())) continue;
            return n;
        }
        return null;
    }

    public List<NodeShapeReport> getShapeReports() {
        return this.shapeReports;
    }

    public void add(NodeShapeReport shapeReport) {
        this.shapeReports.add(shapeReport);
    }

    public ModelStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(ModelStatistics statistics) {
        this.statistics = statistics;
    }

    public ModelValidationRequest getRequest() {
        return this.request;
    }

    public void setRequest(ModelValidationRequest request) {
        this.request = request;
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    @Override
    public int errorCount() {
        return Sum.size(this.classPropertyDisjointViolation, this.propertyShapeCaseViolation) + Sum.errorCount(this.classReports.values(), this.individualReports.values(), this.propertyReports.values(), this.shapeReports);
    }

    public GregorianCalendar getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(GregorianCalendar createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public IdNamePair getProject() {
        return this.project;
    }

    public void setProject(IdNamePair project) {
        this.project = project;
    }
}

