/*
 * Decompiled with CFR 0.152.
 */
package io.konig.validation;

import io.konig.core.OwlReasoner;
import io.konig.shacl.ShapeManager;
import io.konig.validation.CaseStyleConventions;
import io.konig.validation.CommentConventions;
import io.konig.validation.NamespaceValidationConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModelValidationRequest {
    private ShapeManager shapeManager;
    private OwlReasoner owl;
    private CaseStyleConventions caseStyle = new CaseStyleConventions();
    private CommentConventions commentConventions;
    private Set<String> tabularPropertyNamespaces;
    private Map<String, NamespaceValidationConfig> namespaceMap = new HashMap<String, NamespaceValidationConfig>();

    public ModelValidationRequest(OwlReasoner owl, ShapeManager shapeManager) {
        this.owl = owl;
        this.shapeManager = shapeManager;
    }

    public OwlReasoner getOwl() {
        return this.owl;
    }

    public NamespaceValidationConfig getNamespaceConfig(String namespaceName) {
        return this.namespaceMap.get(namespaceName);
    }

    public void addAll(NamespaceValidationConfig[] array) {
        if (array != null) {
            for (NamespaceValidationConfig config : array) {
                this.namespaceMap.put(config.getNamespaceName(), config);
            }
        }
    }

    public void add(NamespaceValidationConfig config) {
        this.namespaceMap.put(config.getNamespaceName(), config);
    }

    public void addTabularPropertyNamespace(String namespace) {
        if (this.tabularPropertyNamespaces == null) {
            this.tabularPropertyNamespaces = new HashSet<String>();
        }
        this.tabularPropertyNamespaces.add(namespace);
    }

    public Set<String> getTabularPropertyNamespaces() {
        return this.tabularPropertyNamespaces == null ? Collections.emptySet() : this.tabularPropertyNamespaces;
    }

    public CaseStyleConventions getCaseStyle() {
        return this.caseStyle;
    }

    public void setCaseStyle(CaseStyleConventions caseStyle) {
        this.caseStyle = caseStyle;
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    public CommentConventions getCommentConventions() {
        return this.commentConventions;
    }

    public void setCommentConventions(CommentConventions commentConventions) {
        this.commentConventions = commentConventions;
    }
}

