/*
 * Decompiled with CFR 0.152.
 */
package io.konig.validation;

import io.konig.validation.ModelValidationReport;
import io.konig.validation.ModelValidationReportWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ModelValidationSummaryWriter
implements ModelValidationReportWriter {
    private static final String PROJECT_ID = "projectId";
    private static final String PROJECT_NAME = "projectName";
    private static final String DATE = "Date";
    private static final String NUMBER_OF_TERMS = "termCount";
    private static final String TERMS_WITH_DESCRIPTION = "termDescriptionCount";
    private static final String NUMBER_OF_CLASSES = "classCount";
    private static final String CLASSES_WITH_DESCRIPTION = "classDescriptionCount";
    private static final String NUMBER_OF_PROPERTIES = "propertyCount";
    private static final String PROPERTIES_WITH_DESCRIPTION = "propertyDescripionCount";
    private static final String NUMBER_OF_NAMED_INDIVIDUALS = "namedIndividualCount";
    private static final String NAMED_INDIVIDUALS_WITH_DESCRIPTION = "namedIndividualDescriptionCount";
    private static final String NUMBER_OF_ERRORS = "errorCount";
    private boolean withHeader;

    public ModelValidationSummaryWriter(boolean withHeader) {
        this.withHeader = withHeader;
    }

    @Override
    public void writeReport(ModelValidationReport report, Writer out) throws IOException {
        CSVPrinter csv = this.csvPrinter(out);
        csv.print((Object)report.getProject().getId());
        csv.print((Object)report.getProject().getName());
        csv.print((Object)this.date(report));
        csv.print((Object)report.getStatistics().getNumberOfTerms());
        csv.print((Object)Float.valueOf(report.getStatistics().getTermsWithDescription().asPercentage()));
        csv.print((Object)report.getStatistics().getNumberOfClasses());
        csv.print((Object)Float.valueOf(report.getStatistics().getClassesWithDescription().asPercentage()));
        csv.print((Object)report.getStatistics().getNumberOfProperties());
        csv.print((Object)Float.valueOf(report.getStatistics().getPropertiesWithDescription().asPercentage()));
        csv.print((Object)report.getStatistics().getNumberOfNamedIndividuals());
        csv.print((Object)Float.valueOf(report.getStatistics().getNamedIndividualsWithDescription().asPercentage()));
        csv.print((Object)report.getStatistics().getNumberOfErrors());
        csv.flush();
    }

    private String date(ModelValidationReport report) {
        Date created = report.getCreatedTimestamp().getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(created);
    }

    private CSVPrinter csvPrinter(Writer out) throws IOException {
        CSVFormat format = CSVFormat.DEFAULT;
        if (this.withHeader) {
            format = format.withHeader(new String[]{PROJECT_ID, PROJECT_NAME, DATE, NUMBER_OF_TERMS, TERMS_WITH_DESCRIPTION, NUMBER_OF_CLASSES, CLASSES_WITH_DESCRIPTION, NUMBER_OF_PROPERTIES, PROPERTIES_WITH_DESCRIPTION, NUMBER_OF_NAMED_INDIVIDUALS, NAMED_INDIVIDUALS_WITH_DESCRIPTION, NUMBER_OF_ERRORS});
        }
        BufferedWriter buf = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        return new CSVPrinter((Appendable)buf, format);
    }
}

