/*
 * Decompiled with CFR 0.152.
 */
package io.konig.validation;

import io.konig.core.Graph;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.util.StringUtil;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.validation.CaseStyle;
import io.konig.validation.ClassReport;
import io.konig.validation.CommentConventions;
import io.konig.validation.ModelStatistics;
import io.konig.validation.ModelValidationReport;
import io.konig.validation.ModelValidationRequest;
import io.konig.validation.NamedIndividualReport;
import io.konig.validation.NamespaceValidationConfig;
import io.konig.validation.NodeShapeReport;
import io.konig.validation.PropertyInfo;
import io.konig.validation.PropertyReport;
import io.konig.validation.PropertyShapeReference;
import io.konig.validation.PropertyShapeReport;
import io.konig.validation.RangeInfo;
import io.konig.validation.RationalNumber;
import io.konig.validation.TypeConflict;
import io.konig.validation.XmlSchemaTerms;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class ModelValidator {
    public ModelValidationReport process(ModelValidationRequest request) {
        Worker worker = new Worker(request);
        return worker.run();
    }

    private class Worker {
        private ModelValidationRequest request;
        private ModelValidationReport report = new ModelValidationReport();
        private Graph graph;
        private Map<URI, PropertyInfo> propertyMap = new HashMap<URI, PropertyInfo>();

        public Worker(ModelValidationRequest request) {
            this.request = request;
            this.graph = request.getOwl().getGraph();
            this.report.setRequest(request);
        }

        public ModelValidationReport run() {
            this.setDefaults();
            this.applyInferencing();
            this.validateCase();
            this.validateClassPropertyDisjoint();
            this.validateDatatypeRange();
            this.validateShapes();
            this.validatePropertyRanges();
            this.computeStatistics();
            return this.report;
        }

        private NamespaceValidationConfig getNamespaceConfig(String namespaceName) {
            return this.request.getNamespaceConfig(namespaceName);
        }

        private void validatePropertyRanges() {
            OwlReasoner owl = this.request.getOwl();
            Iterator<Map.Entry<URI, PropertyInfo>> sequence = this.propertyMap.entrySet().iterator();
            while (sequence.hasNext()) {
                Map.Entry<URI, PropertyInfo> e = sequence.next();
                PropertyInfo info = e.getValue();
                if (!info.isConflict(owl)) {
                    sequence.remove();
                    continue;
                }
                NamespaceValidationConfig config = this.getNamespaceConfig(info.getProperty().getNamespace());
                if (config != null && config.isIgnoreRangeConflicts() || !this.isRangeConflict(info)) continue;
                this.producePropertyReport(e.getKey()).setRangeConflict(info.getRangeInfo());
            }
        }

        private boolean isRangeConflict(PropertyInfo info) {
            URI rdfPropertyRange = info.rdfPropertyRange();
            URI top = null;
            for (RangeInfo r : info.getRangeInfo()) {
                if (r.getParentShapeId() == null) continue;
                URI range = r.getDatatype();
                if (range == null) {
                    range = r.getOwlClass();
                }
                if (range == null) continue;
                if (rdfPropertyRange != null && range != null) {
                    if (this.owl().isSubClassOf((Resource)range, (Resource)rdfPropertyRange)) continue;
                    return true;
                }
                if (top == null) {
                    top = range;
                    continue;
                }
                if (this.owl().isSubClassOf((Resource)top, (Resource)range)) {
                    top = range;
                    continue;
                }
                if (this.owl().isSubClassOf((Resource)range, (Resource)top)) continue;
                return true;
            }
            return false;
        }

        private OwlReasoner owl() {
            return this.request.getOwl();
        }

        private void setDefaults() {
            if (this.request.getCommentConventions() == null) {
                this.request.setCommentConventions(new CommentConventions());
            }
        }

        private void validateDatatypeRange() {
            for (Vertex v : this.graph.vertices()) {
                if (!(v.getId() instanceof URI)) continue;
                URI propertyId = (URI)v.getId();
                Vertex range = v.getVertex(RDFS.RANGE);
                if (range == null || !(range.getId() instanceof URI)) continue;
                URI rangeId = (URI)range.getId();
                this.addPropertyInfo(propertyId, rangeId);
                if (!rangeId.getNamespace().equals("http://www.w3.org/2001/XMLSchema#") || XmlSchemaTerms.isXmlSchemaTerm(rangeId)) continue;
                this.producePropertyReport(propertyId).setInvalidXmlSchemaDatatype(rangeId);
            }
        }

        private void addPropertyInfo(URI propertyId, URI rangeId) {
            if (!this.request.getTabularPropertyNamespaces().contains(propertyId.getNamespace())) {
                URI datatype = null;
                URI owlClass = null;
                if (this.request.getOwl().isSubclassOfLiteral((Resource)rangeId)) {
                    datatype = rangeId;
                } else {
                    owlClass = rangeId;
                }
                PropertyInfo info = this.producePropertyInfo(propertyId);
                info.add(new RangeInfo(null, datatype, owlClass));
            }
        }

        private PropertyInfo producePropertyInfo(URI propertyId) {
            PropertyInfo info = this.propertyMap.get(propertyId);
            if (info == null) {
                info = new PropertyInfo(propertyId);
                this.propertyMap.put(propertyId, info);
                Vertex v = this.graph.getVertex((Resource)propertyId);
                if (v != null && v.getValue(RDFS.COMMENT) != null) {
                    info.setHasDefinition(true);
                }
            }
            return info;
        }

        private void applyInferencing() {
            ShapeManager shapeManager = this.request.getShapeManager();
            OwlReasoner owl = this.request.getOwl();
            owl.inferClassFromSubclassOf();
            owl.inferRdfPropertiesFromPropertyConstraints(shapeManager, this.graph);
            owl.inferClassesFromShapes(shapeManager, this.graph);
        }

        private void computeStatistics() {
            ShapeManager shapeManager = this.request.getShapeManager();
            OwlReasoner owl = this.request.getOwl();
            List<Vertex> owlClasses = owl.owlClassList();
            Set<Vertex> namedIndividuals = owl.allNamedIndividuals();
            int classesCount = owlClasses.size();
            int propertyCount = owl.allRdfOwlAndShaclProperties(shapeManager).size();
            int namedIndividualCount = namedIndividuals.size();
            int shapeCount = shapeManager.listShapes().size();
            ModelStatistics stats = new ModelStatistics();
            stats.setNumberOfClasses(classesCount);
            stats.setNumberOfNamedIndividuals(namedIndividualCount);
            stats.setNumberOfProperties(propertyCount);
            stats.setNumberOfShapes(shapeCount);
            this.report.setStatistics(stats);
            this.evaluateClassDescriptions(owlClasses);
            this.evaluateNamedIndividualDescriptions(namedIndividuals);
            this.evaluatePropertyDescriptions();
            stats.setNumberOfErrors(this.report.errorCount());
        }

        private void evaluatePropertyDescriptions() {
            if (!this.propertyMap.isEmpty()) {
                int count = 0;
                for (PropertyInfo info : this.propertyMap.values()) {
                    if (!info.isHasDefinition()) continue;
                    ++count;
                }
                RationalNumber number = new RationalNumber(count, this.propertyMap.size());
                this.report.getStatistics().setPropertiesWithDescription(number);
            }
        }

        private void evaluateNamedIndividualDescriptions(Set<Vertex> namedIndividuals) {
            int noDescription = 0;
            for (Vertex v : namedIndividuals) {
                Resource id = v.getId();
                if (!(id instanceof URI) || v.getValue(RDFS.COMMENT) != null) continue;
                URI iri = (URI)id;
                if (this.request.getCommentConventions().getRequireNamedIndividualComments()) {
                    NamedIndividualReport r = this.produceNamedIndividualReport(iri);
                    r.setRequiresDescription(true);
                }
                ++noDescription;
            }
            int totalCount = namedIndividuals.size();
            int withDescription = totalCount - noDescription;
            this.report.getStatistics().setNamedIndividualsWithDescription(new RationalNumber(withDescription, totalCount));
        }

        private void evaluateClassDescriptions(List<Vertex> owlClasses) {
            int noDescription = 0;
            for (Vertex v : owlClasses) {
                Resource id = v.getId();
                if (!(id instanceof URI) || v.getValue(RDFS.COMMENT) != null) continue;
                URI iri = (URI)id;
                if (this.request.getCommentConventions().getRequireClassComments()) {
                    ClassReport r = this.produceClassReport(iri);
                    r.setRequiresDescription(true);
                }
                ++noDescription;
            }
            int totalClasses = owlClasses.size();
            int withDescription = totalClasses - noDescription;
            this.report.getStatistics().setClassesWithDescription(new RationalNumber(withDescription, totalClasses));
        }

        private void validateShapes() {
            CaseStyle expectedStyle = this.request.getCaseStyle().getNodeShapes();
            ShapeManager shapeManager = this.request.getShapeManager();
            if (shapeManager != null) {
                for (Shape shape : shapeManager.listShapes()) {
                    CaseStyle actualStyle;
                    NodeShapeReport shapeReport = new NodeShapeReport(shape.getId());
                    if (expectedStyle != null && expectedStyle != (actualStyle = this.caseStyle(shape.getId()))) {
                        shapeReport.setNameHasWrongCase(true);
                    }
                    if (shape.getProperty().isEmpty()) {
                        shapeReport.setNoProperties(true);
                    }
                    for (PropertyConstraint p : shape.getProperty()) {
                        this.validatePropertyConstraint(shapeReport, p);
                    }
                    if (shapeReport.isValid()) continue;
                    this.report.add(shapeReport);
                }
            }
        }

        private CaseStyle caseStyle(Resource id) {
            return id instanceof URI ? this.caseStyle((URI)id) : null;
        }

        private void validatePropertyConstraint(NodeShapeReport shapeReport, PropertyConstraint p) {
            Vertex predicateVertex;
            Vertex v;
            URI predicate = p.getPredicate();
            if (predicate == null) {
                return;
            }
            PropertyShapeReport report = new PropertyShapeReport(p);
            OwlReasoner owl = this.request.getOwl();
            if (p.getValueClass() != null && p.getShape() == null && p.getNodeKind() != NodeKind.IRI) {
                report.setRequiresShapeOrIriNodeKind(true);
            }
            if (p.getMinCount() == null) {
                report.setRequiresMinCount(true);
            }
            if (p.getComment() == null && ((v = this.graph.getVertex((Resource)predicate)) == null || v.getValue(RDFS.COMMENT) == null) && this.request.getCommentConventions().getRequirePropertyShapeComments()) {
                report.setRequiresDescription(true);
            }
            PropertyInfo info = this.producePropertyInfo(predicate);
            info.add(new RangeInfo(shapeReport.getShapeId(), p.getDatatype(), this.valueClass(p)));
            if (p.getComment() != null) {
                info.setHasDefinition(true);
            }
            if (p.getDatatype() != null) {
                URI datatype = p.getDatatype();
                if (datatype.getNamespace().equals("http://www.w3.org/2001/XMLSchema#") && !XmlSchemaTerms.isXmlSchemaTerm(datatype)) {
                    report.setInvalidXmlSchemaDatatype(datatype);
                }
                if (p.getValueClass() != null) {
                    report.setDatatypeWithClass(true);
                }
                if (p.getShape() != null) {
                    report.setDatatypeWithShape(true);
                }
                if (p.getNodeKind() == NodeKind.IRI) {
                    report.setDatatypeWithIriNodeKind(true);
                }
            }
            if (p.getDatatype() == null && p.getShape() == null && p.getValueClass() == null) {
                report.setRequiresDatatypeClassOrShape(true);
            }
            if (predicate != null && (predicateVertex = this.graph.getVertex((Resource)predicate)) != null) {
                Set<Value> rangeSet = predicateVertex.getValueSet(RDFS.RANGE);
                if (rangeSet.size() == 1) {
                    Value range = rangeSet.iterator().next();
                    if (range instanceof URI) {
                        Resource valueClass;
                        URI rangeId = (URI)range;
                        boolean datatypeRange = owl.isSubclassOfLiteral((Resource)rangeId);
                        if (p.getDatatype() != null && !datatypeRange) {
                            report.setTypeConflict(new TypeConflict(p.getDatatype(), rangeId));
                        }
                        if ((valueClass = p.getValueClass()) == null && p.getShape() != null) {
                            valueClass = p.getShape().getId();
                        }
                        if (datatypeRange && valueClass instanceof URI) {
                            report.setTypeConflict(new TypeConflict((URI)valueClass, rangeId));
                        }
                    }
                } else if (rangeSet.size() > 1) {
                    // empty if block
                }
            }
            if (!report.isValid()) {
                shapeReport.add(report);
            }
        }

        private URI valueClass(PropertyConstraint p) {
            if (p.getValueClass() instanceof URI) {
                return (URI)p.getValueClass();
            }
            Shape valueShape = p.getShape();
            if (valueShape != null && valueShape.getTargetClass() != null) {
                return valueShape.getTargetClass();
            }
            return null;
        }

        private void validateClassPropertyDisjoint() {
            Set<URI> propertySet = this.request.getOwl().allRdfOwlAndShaclProperties(this.request.getShapeManager());
            Set<URI> classSet = this.request.getOwl().allClassIds();
            classSet.retainAll(propertySet);
            if (!classSet.isEmpty()) {
                this.report.getClassPropertyDisjointViolation().addAll(classSet);
            }
        }

        private void validateCase() {
            this.validateClassCase();
            this.validatePropertyCase();
            this.validateNamedIndividualCase();
            this.validatePropertyShapeCase();
        }

        private void validatePropertyShapeCase() {
            ShapeManager shapeManager;
            CaseStyle expectedStyle = this.request.getCaseStyle().getProperties();
            if (expectedStyle != null && (shapeManager = this.request.getShapeManager()) != null) {
                List<Shape> shapeList = shapeManager.listShapes();
                List<PropertyShapeReference> violationList = this.report.getPropertyShapeCaseViolation();
                for (Shape shape : shapeList) {
                    Resource shapeId = shape.getId();
                    List<PropertyConstraint> propertyList = shape.getProperty();
                    for (PropertyConstraint p : propertyList) {
                        CaseStyle actualStyle;
                        URI predicate = p.getPredicate();
                        if (predicate == null || expectedStyle.equals((Object)(actualStyle = this.caseStyle(predicate)))) continue;
                        violationList.add(new PropertyShapeReference(shapeId, predicate));
                    }
                }
            }
        }

        private void validateNamedIndividualCase() {
            CaseStyle expectedStyle = this.request.getCaseStyle().getNamedIndividuals();
            if (expectedStyle != null) {
                Set<Vertex> individualList = this.request.getOwl().allNamedIndividuals();
                for (Vertex v : individualList) {
                    URI iri;
                    CaseStyle actualStyle;
                    Resource id = v.getId();
                    if (!(id instanceof URI) || expectedStyle.equals((Object)(actualStyle = this.caseStyle(iri = (URI)id)))) continue;
                    NamedIndividualReport nir = this.produceNamedIndividualReport(iri);
                    nir.setNameHasWrongCase(true);
                }
            }
        }

        private NamedIndividualReport produceNamedIndividualReport(URI iri) {
            NamedIndividualReport result = this.report.findNamedIndividualReport(iri);
            if (result == null) {
                result = new NamedIndividualReport(iri);
                this.report.add(result);
            }
            return result;
        }

        private void validatePropertyCase() {
            CaseStyle expectedStyle = this.request.getCaseStyle().getProperties();
            if (expectedStyle != null) {
                Set<Vertex> propertyList = this.request.getOwl().allRdfAndOwlProperties();
                for (Vertex v : propertyList) {
                    URI iri;
                    CaseStyle actualStyle;
                    Resource id = v.getId();
                    if (!(id instanceof URI) || expectedStyle.equals((Object)(actualStyle = this.caseStyle(iri = (URI)id)))) continue;
                    PropertyReport p = this.producePropertyReport(iri);
                    p.setNameHasWrongCase(true);
                }
            }
        }

        private PropertyReport producePropertyReport(URI iri) {
            PropertyReport p = this.report.findPropertyReport(iri);
            if (p == null) {
                p = new PropertyReport(iri);
                this.report.add(p);
            }
            return p;
        }

        private void validateClassCase() {
            Vertex classVertex;
            CaseStyle expectedStyle = this.request.getCaseStyle().getClasses();
            if (expectedStyle != null && (classVertex = this.graph.getVertex((Resource)OWL.CLASS)) != null) {
                List<Vertex> classList = classVertex.asTraversal().in(RDF.TYPE).toVertexList();
                for (Vertex v : classList) {
                    CaseStyle actualStyle;
                    Resource id = v.getId();
                    if (!(id instanceof URI)) continue;
                    URI iri = (URI)id;
                    if (this.request.getOwl().isDatatype((Resource)iri) || expectedStyle.equals((Object)(actualStyle = this.caseStyle(iri)))) continue;
                    this.produceClassReport(iri).setNameHasWrongCase(true);
                }
            }
        }

        private ClassReport produceClassReport(URI iri) {
            ClassReport result = this.report.findClassReport(iri);
            if (result == null) {
                result = new ClassReport(iri);
                this.report.add(result);
            }
            return result;
        }

        private CaseStyle caseStyle(URI id) {
            String localName = id.getLocalName();
            String camelCase = StringUtil.camelCase(localName);
            if (camelCase.equals(localName)) {
                return CaseStyle.camelCase;
            }
            String PascalCase = StringUtil.PascalCase(localName);
            if (PascalCase.equals(localName)) {
                return CaseStyle.PascalCase;
            }
            String SNAKE_CASE = StringUtil.SNAKE_CASE(localName);
            if (SNAKE_CASE.equals(localName)) {
                return CaseStyle.UPPER_SNAKE_CASE;
            }
            String snake_case = SNAKE_CASE.toLowerCase();
            if (snake_case.equals(localName)) {
                return CaseStyle.lower_snake_case;
            }
            return null;
        }
    }
}

