/*
 * Decompiled with CFR 0.152.
 */
package io.konig.validation;

import io.konig.validation.PropertyShapeReport;
import io.konig.validation.ReportElement;
import io.konig.validation.Sum;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class NodeShapeReport
implements Comparable<NodeShapeReport>,
ReportElement {
    private Resource shapeId;
    private List<PropertyShapeReport> propertyReports = new ArrayList<PropertyShapeReport>();
    private boolean nameHasWrongCase;
    private boolean noProperties;

    public NodeShapeReport(Resource shapeId) {
        this.shapeId = shapeId;
    }

    public Resource getShapeId() {
        return this.shapeId;
    }

    public void add(PropertyShapeReport r) {
        this.propertyReports.add(r);
    }

    public List<PropertyShapeReport> getPropertyReports() {
        return this.propertyReports;
    }

    public boolean isValid() {
        return !this.nameHasWrongCase && !this.noProperties && !this.hasNonEmptyPropertyReport();
    }

    public boolean hasNonEmptyPropertyReport() {
        for (PropertyShapeReport r : this.propertyReports) {
            if (r.isValid()) continue;
            return true;
        }
        return false;
    }

    public PropertyShapeReport findPropertyReport(URI propertyId) {
        for (PropertyShapeReport r : this.propertyReports) {
            URI predicate = r.getPropertyShape().getPredicate();
            if (!propertyId.equals((Object)predicate)) continue;
            return r;
        }
        return null;
    }

    public boolean getNameHasWrongCase() {
        return this.nameHasWrongCase;
    }

    public void setNameHasWrongCase(boolean wrongCase) {
        this.nameHasWrongCase = wrongCase;
    }

    @Override
    public int compareTo(NodeShapeReport o) {
        return this.shapeId.stringValue().compareTo(o.getShapeId().stringValue());
    }

    @Override
    public int errorCount() {
        return Sum.whereTrue(this.nameHasWrongCase) + Sum.errorCount(this.propertyReports);
    }

    public boolean isNoProperties() {
        return this.noProperties;
    }

    public void setNoProperties(boolean noProperties) {
        this.noProperties = noProperties;
    }
}

