/*
 * Decompiled with CFR 0.152.
 */
package io.konig.validation;

import io.konig.core.impl.RdfUtil;
import io.konig.core.io.PrettyPrintWriter;
import io.konig.validation.CaseStyle;
import io.konig.validation.ClassReport;
import io.konig.validation.ModelValidationReport;
import io.konig.validation.ModelValidationReportWriter;
import io.konig.validation.NamedIndividualReport;
import io.konig.validation.NodeShapeReport;
import io.konig.validation.PropertyReport;
import io.konig.validation.PropertyShapeReport;
import io.konig.validation.RangeInfo;
import io.konig.validation.RationalNumber;
import io.konig.validation.TypeConflict;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;

public class PlainTextModelValidationReportWriter
implements ModelValidationReportWriter {
    @Override
    public void writeReport(ModelValidationReport report, Writer out) throws IOException {
        PrettyPrintWriter pretty = new PrettyPrintWriter(out);
        Worker worker = new Worker(report, pretty);
        worker.doWrite();
    }

    private static class Worker {
        private ModelValidationReport report;
        private PrettyPrintWriter out;
        private DecimalFormat percent = new DecimalFormat("###.#%");

        public Worker(ModelValidationReport report, PrettyPrintWriter out) {
            this.report = report;
            this.out = out;
        }

        private String percentage(String label, RationalNumber number) {
            String pattern = label + ": {0} ({1})";
            return MessageFormat.format(pattern, number.getNumerator(), this.percent.format(number.getValue()));
        }

        private void doWrite() {
            String classesWithDescription = this.percentage("Number of OWL Classes with description", this.report.getStatistics().getClassesWithDescription());
            String individualsWithDescription = this.percentage("Number of Named Individuals with description", this.report.getStatistics().getNamedIndividualsWithDescription());
            this.out.println("Data Model Statistics");
            this.out.println("=====================");
            this.out.println();
            this.out.print("Number of OWL Classes: ");
            this.out.println(this.report.getStatistics().getNumberOfClasses());
            this.out.println(classesWithDescription);
            this.out.println();
            this.out.print("Number of Properties: ");
            this.out.println(this.report.getStatistics().getNumberOfProperties());
            this.out.println();
            this.out.print("Number of Named Individuals: ");
            this.out.println(this.report.getStatistics().getNumberOfNamedIndividuals());
            this.out.println(individualsWithDescription);
            this.out.println();
            this.out.print("Number of Node Shapes: ");
            this.out.println(this.report.getStatistics().getNumberOfShapes());
            this.out.println();
            this.printClassReports(this.report, this.out);
            this.printPropertyReports(this.report, this.out);
            this.printNamedIndividualReports(this.report, this.out);
            this.printShapeReports(this.report, this.out);
            this.out.flush();
        }

        private void printNamedIndividualReports(ModelValidationReport report, PrettyPrintWriter out) {
            if (report.getNamedIndividualReports().isEmpty()) {
                return;
            }
            out.println("Named Individuals");
            out.println("=================");
            CaseStyle expectedStyle = report.getRequest().getCaseStyle().getNamedIndividuals();
            out.println();
            ArrayList<NamedIndividualReport> list = new ArrayList<NamedIndividualReport>(report.getNamedIndividualReports());
            Collections.sort(list);
            for (NamedIndividualReport p : list) {
                out.print('<');
                out.print(p.getIndividualId().stringValue());
                out.println('>');
                out.pushIndent();
                if (p.getNameHasWrongCase()) {
                    this.wrongCaseMessage(expectedStyle);
                }
                out.popIndent();
            }
            out.println();
        }

        private void printPropertyReports(ModelValidationReport report, PrettyPrintWriter out) {
            if (report.getPropertyReports().isEmpty()) {
                return;
            }
            out.println("Properties");
            out.println("==========");
            CaseStyle expectedStyle = report.getRequest().getCaseStyle().getProperties();
            out.println();
            ArrayList<PropertyReport> list = new ArrayList<PropertyReport>(report.getPropertyReports());
            Collections.sort(list);
            for (PropertyReport p : list) {
                out.print('<');
                out.print(p.getPropertyId().stringValue());
                out.println('>');
                out.pushIndent();
                if (p.getNameHasWrongCase()) {
                    this.wrongCaseMessage(expectedStyle);
                }
                if (p.getInvalidXmlSchemaDatatype() != null) {
                    this.invalidXmlSchemaDatatypeMessage(p);
                }
                this.printRangeConflict(p);
                out.popIndent();
            }
            out.println();
        }

        private void printRangeConflict(PropertyReport p) {
            List<RangeInfo> rangeConflict = p.getRangeConflict();
            if (!rangeConflict.isEmpty()) {
                this.out.indent();
                this.out.println("Incompatible values for range:");
                this.out.pushIndent();
                for (RangeInfo info : rangeConflict) {
                    URI datatype = info.getDatatype();
                    URI owlClass = info.getOwlClass();
                    URI type = datatype == null ? owlClass : datatype;
                    Resource shapeId = info.getParentShapeId();
                    URI source = shapeId == null ? RDFS.RANGE : shapeId;
                    this.out.indent();
                    this.out.print(this.compactId((Resource)type));
                    this.out.print(" defined by ");
                    this.out.println(this.compactId((Resource)source));
                }
                this.out.popIndent();
            }
        }

        private String compactId(Resource id) {
            return RdfUtil.compactId(id, this.report.getNamespaceManager());
        }

        private void invalidXmlSchemaDatatypeMessage(PropertyReport p) {
            this.out.indent();
            this.out.print("Invalid XML Schema datatype: ");
            this.out.println(p.getInvalidXmlSchemaDatatype().getLocalName());
        }

        private void printClassReports(ModelValidationReport report, PrettyPrintWriter out) {
            if (report.getClassReports().isEmpty()) {
                return;
            }
            out.println("Classes");
            out.println("=======");
            CaseStyle expectedStyle = report.getRequest().getCaseStyle().getClasses();
            out.println();
            ArrayList<ClassReport> list = new ArrayList<ClassReport>(report.getClassReports());
            Collections.sort(list);
            for (ClassReport c : list) {
                out.print('<');
                out.print(c.getClassId().stringValue());
                out.println('>');
                out.pushIndent();
                if (c.getNameHasWrongCase()) {
                    this.wrongCaseMessage(expectedStyle);
                }
                if (c.getRequiresDescription()) {
                    out.indent();
                    out.println("SHOULD have a definition given by rdfs:comment");
                }
                out.println();
                out.popIndent();
            }
            out.println();
        }

        private void printShapeReports(ModelValidationReport report, PrettyPrintWriter out) {
            if (report.getShapeReports().isEmpty()) {
                return;
            }
            out.println("Node Shapes");
            out.println("===========");
            CaseStyle expectedStyle = report.getRequest().getCaseStyle().getNodeShapes();
            out.println();
            ArrayList<NodeShapeReport> list = new ArrayList<NodeShapeReport>(report.getShapeReports());
            Collections.sort(list);
            for (NodeShapeReport c : list) {
                out.print('<');
                out.print(c.getShapeId().stringValue());
                out.println('>');
                out.pushIndent();
                if (c.getNameHasWrongCase()) {
                    this.wrongCaseMessage(expectedStyle);
                }
                if (c.isNoProperties()) {
                    this.noPropertiesMessage();
                }
                out.popIndent();
                this.printAllPropertyShapeReports(c, out);
            }
        }

        private void noPropertiesMessage() {
            String msg = "SHOULD declare at least one property, but has none";
            this.out.indent();
            this.out.println(msg);
            this.out.println();
        }

        private void wrongCaseMessage(CaseStyle expectedStyle) {
            String msg = MessageFormat.format("SHOULD use {0} for the local name", expectedStyle.name());
            this.out.indent();
            this.out.println(msg);
            this.out.println();
        }

        private void printAllPropertyShapeReports(NodeShapeReport nodeReport, PrettyPrintWriter out) {
            if (!nodeReport.hasNonEmptyPropertyReport()) {
                return;
            }
            List<PropertyShapeReport> list = nodeReport.getPropertyReports();
            Collections.sort(list);
            out.pushIndent();
            out.indent();
            out.println("Property Constraints");
            out.indent();
            out.println("====================");
            out.pushIndent();
            for (PropertyShapeReport p : list) {
                String msg;
                String datatype;
                out.indent();
                out.print('<');
                out.print(p.getPropertyShape().getPredicate().stringValue());
                out.println('>');
                out.pushIndent();
                if (p.isDatatypeWithClass()) {
                    datatype = this.iriRef((Resource)p.getPropertyShape().getDatatype());
                    String classId = this.iriRef(p.getPropertyShape().getValueClass());
                    msg = MessageFormat.format("MUST NOT define both (sh:datatype {0}) and (sh:class {1})", datatype, classId);
                    out.indent();
                    out.println(msg);
                }
                if (p.isDatatypeWithIriNodeKind()) {
                    datatype = this.iriRef((Resource)p.getPropertyShape().getDatatype());
                    String msg2 = MessageFormat.format("MUST NOT define both (sh:datatype {0}) and (sh:nodeKind sh:IRI)", datatype);
                    out.indent();
                    out.println(msg2);
                }
                if (p.isDatatypeWithShape()) {
                    datatype = this.iriRef((Resource)p.getPropertyShape().getDatatype());
                    String shapeId = this.iriRef(p.getPropertyShape().getShape().getId());
                    msg = MessageFormat.format("MUST NOT define both (sh:datatype {0}) and (sh:shape {1})", datatype, shapeId);
                    out.indent();
                    out.println(msg);
                }
                if (p.isRequiresDatatypeClassOrShape()) {
                    out.indent();
                    out.println("MUST specify one of sh:datatype, sh:class, OR sh:shape");
                }
                if (p.isRequiresMinCount()) {
                    out.indent();
                    out.println("MUST define the sh:minCount attribute");
                }
                if (p.isRequiresShapeOrIriNodeKind()) {
                    out.indent();
                    out.println("MUST define sh:shape or set (sh:nodeKind sh:IRI) since sh:class is defined");
                }
                if (p.getRequiresDescription()) {
                    out.indent();
                    out.println("SHOULD define rdfs:comment");
                }
                if (p.getInvalidXmlSchemaDatatype() != null) {
                    out.indent();
                    out.print("Invalid XML Schema datatype: ");
                    out.println(p.getInvalidXmlSchemaDatatype().getLocalName());
                }
                if (p.getTypeConflict() != null) {
                    TypeConflict conflict = p.getTypeConflict();
                    out.indent();
                    out.println("Type Conflict:");
                    out.pushIndent();
                    out.indent();
                    out.print("Property Range: ");
                    out.println(this.iriRef((Resource)conflict.getRange()));
                    out.indent();
                    out.print("Property Constraint: ");
                    out.println(this.iriRef((Resource)conflict.getPropertyShapeType()));
                    out.popIndent();
                }
                out.popIndent();
                out.println();
            }
            out.popIndent();
            out.popIndent();
        }

        private String iriRef(Resource id) {
            return RdfUtil.compactName(this.report.getRequest().getOwl().getGraph().getNamespaceManager(), id);
        }
    }
}

