/*
 * Decompiled with CFR 0.152.
 */
package io.konig.validation;

import io.konig.core.OwlReasoner;
import io.konig.validation.RangeInfo;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class PropertyInfo {
    private URI property;
    private List<RangeInfo> rangeInfo = new ArrayList<RangeInfo>();
    private boolean hasDefinition;

    public PropertyInfo(URI property) {
        this.property = property;
    }

    public URI getProperty() {
        return this.property;
    }

    public List<RangeInfo> getRangeInfo() {
        return this.rangeInfo;
    }

    public void add(RangeInfo range) {
        this.rangeInfo.add(range);
    }

    public boolean isConflict(OwlReasoner reasoner) {
        URI datatype1 = null;
        URI owlClass1 = null;
        for (RangeInfo range : this.rangeInfo) {
            URI datatype2 = range.getDatatype();
            if (datatype1 == null) {
                datatype1 = datatype2;
            } else if (datatype2 != null && !datatype2.equals((Object)datatype1)) {
                return true;
            }
            URI owlClass2 = range.getOwlClass();
            if (owlClass1 == null) {
                owlClass1 = owlClass2;
                continue;
            }
            if (owlClass2 == null || reasoner.isSubClassOf((Resource)owlClass2, (Resource)owlClass1) || reasoner.isSubClassOf((Resource)owlClass1, (Resource)owlClass2)) continue;
            return true;
        }
        return false;
    }

    public URI rdfPropertyRange() {
        for (RangeInfo r : this.rangeInfo) {
            if (r.getParentShapeId() != null) continue;
            if (r.getDatatype() != null) {
                return r.getDatatype();
            }
            return r.getOwlClass();
        }
        return null;
    }

    public boolean isHasDefinition() {
        return this.hasDefinition;
    }

    public void setHasDefinition(boolean hasDefinition) {
        this.hasDefinition = hasDefinition;
    }
}

