/*
 * Decompiled with CFR 0.152.
 */
package io.konig.validation;

import io.konig.validation.RangeInfo;
import io.konig.validation.ReportElement;
import io.konig.validation.Sum;
import java.util.Collections;
import java.util.List;
import org.openrdf.model.URI;

public class PropertyReport
implements Comparable<PropertyReport>,
ReportElement {
    private URI propertyId;
    private boolean nameHasWrongCase;
    private URI invalidXmlSchemaDatatype;
    private List<RangeInfo> rangeConflict;

    public PropertyReport(URI propertyId) {
        this.propertyId = propertyId;
    }

    public boolean getNameHasWrongCase() {
        return this.nameHasWrongCase;
    }

    public void setNameHasWrongCase(boolean nameHasWrongCase) {
        this.nameHasWrongCase = nameHasWrongCase;
    }

    public URI getPropertyId() {
        return this.propertyId;
    }

    @Override
    public int compareTo(PropertyReport o) {
        return this.propertyId.stringValue().compareTo(o.getPropertyId().stringValue());
    }

    public URI getInvalidXmlSchemaDatatype() {
        return this.invalidXmlSchemaDatatype;
    }

    public void setInvalidXmlSchemaDatatype(URI invalidXmlSchemaDatatype) {
        this.invalidXmlSchemaDatatype = invalidXmlSchemaDatatype;
    }

    public List<RangeInfo> getRangeConflict() {
        return this.rangeConflict == null ? Collections.emptyList() : this.rangeConflict;
    }

    public void setRangeConflict(List<RangeInfo> rangeConflict) {
        this.rangeConflict = rangeConflict;
    }

    @Override
    public int errorCount() {
        return Sum.whereTrue(this.nameHasWrongCase) + Sum.whereNonNull(this.invalidXmlSchemaDatatype) + this.getRangeConflict().size();
    }
}

