/*
 * Decompiled with CFR 0.152.
 */
package io.konig.validation;

public class RationalNumber {
    public static RationalNumber UNDEFINED = new RationalNumber(0, 0);
    private int numerator;
    private int denominator;

    public RationalNumber(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public static RationalNumber combine(RationalNumber ... value) {
        int numerator = 0;
        int denominator = 0;
        for (RationalNumber number : value) {
            if (number == null) continue;
            numerator += number.getNumerator();
            denominator += number.getDenominator();
        }
        return new RationalNumber(numerator, denominator);
    }

    public static RationalNumber safeValue(RationalNumber value) {
        return value == null ? UNDEFINED : value;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public float getValue() {
        return this.denominator == 0 ? 0.0f : (float)this.numerator / (float)this.denominator;
    }

    public float asPercentage() {
        return this.getValue() * 100.0f;
    }
}

