/*
 * Decompiled with CFR 0.152.
 */
package io.konig.validation;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;

public class XmlSchemaTerms {
    private static Set<URI> terms;

    public static boolean isXmlSchemaTerm(URI term) {
        if (term.getNamespace().equals("http://www.w3.org/2001/XMLSchema#")) {
            Set<URI> termSet = XmlSchemaTerms.termSet();
            return termSet.contains(term);
        }
        return false;
    }

    private static Set<URI> termSet() {
        if (terms == null) {
            Field[] fieldList;
            terms = new HashSet<URI>();
            for (Field field : fieldList = XMLSchema.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !URI.class.isAssignableFrom(field.getType())) continue;
                try {
                    terms.add((URI)field.get(null));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return terms;
    }
}

