/*
 * Decompiled with CFR 0.152.
 */
package io.konig.data.app.gae;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import io.konig.dao.core.ShapeReadService;
import io.konig.data.app.common.DataAppServlet;
import io.konig.sql.runtime.BigQueryShapeReadService;
import io.konig.sql.runtime.ClasspathEntityStructureService;
import io.konig.sql.runtime.EntityStructureService;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;

public class GaeDataAppServlet
extends DataAppServlet {
    private static final long serialVersionUID = 1L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ShapeReadService createShapeReadService() throws ServletException {
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("konig/gcp/credentials.json");){
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)input);
            BigQuery bigQuery = (BigQuery)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials((Credentials)credentials)).build().getService();
            ClasspathEntityStructureService structureService = ClasspathEntityStructureService.defaultInstance();
            BigQueryShapeReadService bigQueryShapeReadService = new BigQueryShapeReadService((EntityStructureService)structureService, bigQuery);
            return bigQueryShapeReadService;
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

