/*
 * Decompiled with CFR 0.152.
 */
package io.konig.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.konig.maven.OmcsConnection;
import io.konig.maven.OmcsDeployment;
import io.konig.omcs.datasource.OracleTableDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class CreateOmcsTableAction {
    private OmcsDeployment ocmsDeployment;

    public CreateOmcsTableAction(OmcsDeployment ocmsDeployment) {
        this.ocmsDeployment = ocmsDeployment;
    }

    public OmcsDeployment from(String tableFile) throws Exception {
        Connection connection = null;
        Statement statement = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            File file = this.ocmsDeployment.file(tableFile);
            OracleTableDefinition table = (OracleTableDefinition)mapper.readValue(file, OracleTableDefinition.class);
            String oracleHost = table.getTableReference().getOracleHost();
            if (System.getProperty(oracleHost) != null) {
                oracleHost = System.getProperty(oracleHost);
            }
            String instance = oracleHost + ":" + table.getTableReference().getOmcsInstanceId();
            String schema = table.getTableReference().getOracleSchema();
            String tableId = table.getTableReference().getOmcsTableId();
            File ddlFile = new File(file.getParentFile(), table.getQuery());
            String createQuery = this.fileToString(ddlFile);
            connection = OmcsConnection.getConnection(instance, schema);
            statement = connection.createStatement();
            statement.execute(createQuery);
            this.ocmsDeployment.setResponse("Created Table " + tableId);
        }
        catch (IOException | SQLException ex) {
            throw ex;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return this.ocmsDeployment;
    }

    private String fileToString(File ddlFile) throws IOException {
        return new String(Files.readAllBytes(ddlFile.toPath()));
    }
}

