/*
 * Decompiled with CFR 0.152.
 */
package io.konig.maven;

import java.sql.Connection;
import java.sql.DriverManager;

public class OmcsConnection {
    private static OmcsConnection connection;
    private String url;
    private String username;
    private String password;

    private OmcsConnection(String instance, String schema) throws Exception {
        this.url = "jdbc:oracle:thin:@" + instance;
        this.username = System.getenv("OMCS_USERNAME") == null ? System.getProperty("omcs.username") : System.getenv("OMCS_USERNAME");
        String string = this.password = System.getenv("OMCS_PASSWORD") == null ? System.getProperty("omcs.password") : System.getenv("OMCS_PASSWORD");
        if (this.username == null || this.password == null) {
            String error = "Please define the OMCS_USERNAME and OMCS_PASSWORD as environment variable, or set the property 'omcs.username' and 'omcs.password'.";
            throw new Exception(error);
        }
        Class.forName("oracle.jdbc.driver.OracleDriver");
    }

    public static Connection getConnection(String instance, String schema) throws Exception {
        if (connection == null) {
            connection = new OmcsConnection(instance, schema);
        }
        Connection con = DriverManager.getConnection(OmcsConnection.connection.url, OmcsConnection.connection.username, OmcsConnection.connection.password);
        if (schema != null && !schema.equals("")) {
            con.createStatement().execute("ALTER SESSION SET CURRENT_SCHEMA =" + schema);
        }
        return con;
    }
}

