/*
 * Decompiled with CFR 0.152.
 */
package io.konig.omcs.deploy;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.konig.maven.OmcsConnection;
import io.konig.omcs.datasource.OracleTableDefinition;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="omcsDeploy")
public class KonigOmcsDeploymentMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File directory;
    @Parameter(required=true)
    private File tables;
    private Connection connection = null;
    private Statement statement = null;

    public void execute() throws MojoExecutionException {
        try {
            File[] tableFiles;
            for (File file : tableFiles = this.tables.listFiles()) {
                this.createTables(file);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to connect the database ", e);
        }
        finally {
            this.close();
        }
    }

    private void createTables(File file) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        OracleTableDefinition table = (OracleTableDefinition)mapper.readValue(file, OracleTableDefinition.class);
        String oracleHost = table.getTableReference().getOracleHost();
        if (System.getProperty(oracleHost) != null) {
            oracleHost = System.getProperty(oracleHost);
        }
        String instance = oracleHost + ":" + table.getTableReference().getOmcsInstanceId();
        String schema = table.getTableReference().getOracleSchema();
        String createQuery = table.getQuery();
        this.connection = OmcsConnection.getConnection(instance, schema);
        this.statement = this.connection.createStatement();
        this.statement.execute(createQuery);
        this.close();
    }

    private void close() throws MojoExecutionException {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                throw new MojoExecutionException("Failed to close the connection ", (Exception)e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new MojoExecutionException("Failed to close the connection ", (Exception)e);
            }
        }
    }
}

