/*
 * Decompiled with CFR 0.152.
 */
package io.konig.omcs.datasource;

import io.konig.annotation.RdfProperty;
import io.konig.core.KonigException;
import io.konig.core.vocab.Konig;
import io.konig.datasource.TableDataSource;
import io.konig.omcs.datasource.OracleTableReference;
import io.konig.shacl.Shape;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class OracleTable
extends TableDataSource {
    private String tableName;
    private OracleTableReference tableReference;
    private String tableId;

    public OracleTable() {
        this.addType(Konig.OracleTable);
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getTableId() {
        return this.tableId;
    }

    @RdfProperty(value="http://www.konig.io/ns/omcs/tableReference")
    public OracleTableReference getTableReference() {
        return this.tableReference;
    }

    public void setTableReference(OracleTableReference tableReference) {
        this.tableReference = tableReference;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableIdentifier() {
        return this.tableName;
    }

    public void setId(Resource id) {
        super.setId(id);
        if (this.tableName == null && id instanceof URI) {
            URI uri = (URI)id;
            this.tableName = uri.getLocalName();
        }
    }

    public String getUniqueIdentifier() {
        StringBuilder builder = new StringBuilder();
        builder.append("OracleTable:");
        builder.append(this.tableReference.getOmcsInstanceId());
        builder.append(':');
        builder.append(this.tableReference.getOracleSchema());
        builder.append(':');
        builder.append(this.tableReference.getOmcsTableId());
        return builder.toString();
    }

    public String getSqlDialect() {
        return "PL/SQL";
    }

    public String getDdlFileName() {
        OracleTableReference ref = this.getTableReference();
        StringBuilder builder = new StringBuilder();
        builder.append(ref.getOmcsInstanceId());
        builder.append('.');
        builder.append(ref.getOracleSchema());
        builder.append('.');
        builder.append(ref.getOmcsTableId());
        builder.append(".sql");
        return builder.toString();
    }

    public String getTransformFileName() {
        OracleTableReference ref = this.getTableReference();
        StringBuilder builder = new StringBuilder();
        builder.append(ref.getOmcsInstanceId());
        builder.append('.');
        builder.append(ref.getOracleSchema());
        builder.append('.');
        builder.append(ref.getOmcsTableId());
        builder.append(".dml.sql");
        return builder.toString();
    }

    public String getQualifiedTableName() {
        if (this.tableReference == null) {
            throw new KonigException("tableReference must be defined");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.tableReference.getOracleSchema());
        builder.append('.');
        builder.append(this.tableName);
        return builder.toString();
    }

    public TableDataSource generateAssociationTable(Shape subjectShape, URI predicate) {
        throw new UnsupportedOperationException();
    }
}

