/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.Vertex;
import io.konig.core.vocab.SH;
import io.konig.core.vocab.VANN;
import io.konig.schemagen.LocalnameComparator;
import io.konig.schemagen.NamespaceComparator;
import io.konig.schemagen.SchemaGeneratorException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllJsonldWriter {
    private static final Logger logger = LoggerFactory.getLogger(AllJsonldWriter.class);
    private static final Set<URI> ONTOLOGY_SKIP = new HashSet<URI>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJSON(NamespaceManager nsManager, Graph graph, Set<String> excludeNamespaces, File outFile) throws IOException {
        JsonFactory factory = new JsonFactory();
        FileWriter writer = new FileWriter(outFile);
        try {
            JsonGenerator generator = factory.createGenerator((Writer)writer);
            generator.useDefaultPrettyPrinter();
            this.writeJSON(nsManager, graph, excludeNamespaces, generator);
        }
        finally {
            this.close(writer);
        }
    }

    private void close(FileWriter writer) {
        try {
            writer.close();
        }
        catch (Throwable ignore) {
            logger.warn("Failed to close writer", ignore);
        }
    }

    public void writeJSON(NamespaceManager nsManager, Graph graph, Set<String> excludeNamespaces, JsonGenerator json) throws IOException {
        Worker worker = new Worker();
        worker.writeJSON(nsManager, graph, excludeNamespaces, json);
    }

    static {
        ONTOLOGY_SKIP.add((URI)new URIImpl("http://www.w3.org/2002/07/owl#"));
        ONTOLOGY_SKIP.add((URI)new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        ONTOLOGY_SKIP.add((URI)new URIImpl("http://www.w3.org/2000/01/rdf-schema#"));
        ONTOLOGY_SKIP.add((URI)new URIImpl("http://www.w3.org/2001/XMLSchema#"));
        ONTOLOGY_SKIP.add((URI)new URIImpl("http://www.w3.org/2003/06/sw-vocab-status/ns#"));
        ONTOLOGY_SKIP.add((URI)new URIImpl("http://www.konig.io/ns/kol/"));
        ONTOLOGY_SKIP.add(VANN.NAMESPACE_URI);
        ONTOLOGY_SKIP.add(SH.NAMESPACE_URI);
    }

    private static class Worker {
        private Set<String> memory = new HashSet<String>();
        private List<Vertex> stack = new ArrayList<Vertex>();
        private NamespaceManager nsManager;
        private Graph graph;
        private JsonGenerator json;
        private Set<URI> excludeNamespaces;

        private Worker() {
        }

        private void push(Vertex v) {
            URI uri;
            Resource id = v.getId();
            if (id instanceof URI && ("http://www.w3.org/2002/07/owl#".equals((uri = (URI)id).getNamespace()) || SH.NAMESPACE_URI.stringValue().equals(uri.getNamespace()))) {
                return;
            }
            String key = v.getId().stringValue();
            if (!this.memory.contains(key)) {
                this.stack.add(v);
            }
        }

        public void writeJSON(NamespaceManager nsManager, Graph graph, Set<String> excludeNamespaces, JsonGenerator json) throws IOException {
            this.nsManager = nsManager;
            this.graph = graph;
            this.json = json;
            this.excludeNamespaces(excludeNamespaces);
            json.writeStartObject();
            this.addContext();
            json.writeArrayFieldStart("@graph");
            this.writeInstances(OWL.ONTOLOGY, this.excludeNamespaces);
            this.writeInstances(OWL.CLASS);
            this.writeInstances(RDF.PROPERTY);
            this.writeInstances(OWL.OBJECTPROPERTY);
            this.writeInstances(OWL.DATATYPEPROPERTY);
            this.writeInstances(OWL.FUNCTIONALPROPERTY);
            this.writeInstances(SH.Shape);
            for (int i = 0; i < this.stack.size(); ++i) {
                Vertex v = this.stack.get(i);
                this.writeVertex(v);
            }
            json.writeEndArray();
            json.writeEndObject();
            json.flush();
        }

        private void excludeNamespaces(Set<String> set) {
            if (set == null) {
                this.excludeNamespaces = ONTOLOGY_SKIP;
            } else {
                this.excludeNamespaces = new HashSet<URI>();
                for (String namespace : set) {
                    if (namespace == null || namespace.length() <= 0) continue;
                    this.excludeNamespaces.add((URI)new URIImpl(namespace));
                }
            }
        }

        private void writeInstances(URI type) throws IOException {
            this.writeInstances(type, null);
        }

        private void writeInstances(URI type, Set<URI> skip) throws IOException {
            List list = this.graph.v((Resource)type).in(RDF.TYPE).toVertexList();
            Collections.sort(list, new LocalnameComparator());
            this.writeVertices(list, skip);
        }

        private void writeVertices(List<Vertex> list, Set<URI> skip) throws IOException {
            for (Vertex v : list) {
                if (skip != null && skip.contains(v.getId())) continue;
                this.writeVertex(v);
            }
        }

        private void writeVertex(Vertex v) throws IOException {
            Set set = v.outEdges();
            if (set.isEmpty()) {
                return;
            }
            String idValue = v.getId().stringValue();
            if (this.memory.contains(idValue)) {
                return;
            }
            this.memory.add(idValue);
            this.json.writeStartObject();
            this.writeVertexProperties(set, v);
            this.json.writeEndObject();
        }

        private void writeVertexProperties(Set<Map.Entry<URI, Set<Edge>>> set, Vertex v) throws IOException {
            String idValue = this.idValue(v);
            if (idValue != null) {
                this.json.writeStringField("@id", this.idValue(v.getId()));
            }
            for (Map.Entry<URI, Set<Edge>> e : set) {
                Set<Edge> edgeSet = e.getValue();
                if (edgeSet.isEmpty()) continue;
                URI predicate = e.getKey();
                boolean isType = predicate.equals((Object)RDF.TYPE);
                String fieldName = isType ? "@type" : this.curie(predicate);
                this.json.writeFieldName(fieldName);
                if (edgeSet.size() > 1) {
                    this.json.writeStartArray();
                    for (Edge edge : edgeSet) {
                        this.writeValue(isType, edge.getObject());
                    }
                    this.json.writeEndArray();
                    continue;
                }
                Value value = edgeSet.iterator().next().getObject();
                this.writeValue(isType, value);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void writeValue(boolean isType, Value object) throws IOException {
            if (isType) {
                if (!(object instanceof Resource)) throw new SchemaGeneratorException("Illegal type value: " + object.stringValue());
                this.json.writeString(this.idValue((Resource)object));
                return;
            } else {
                this.writeValue(object);
            }
        }

        private String idValue(Vertex v) {
            Resource id = v.getId();
            if (id instanceof BNode) {
                Map.Entry entry;
                Set edgeSet;
                int count = 0;
                Set set = v.inEdges();
                Iterator i$ = set.iterator();
                while (i$.hasNext() && ((edgeSet = (Set)(entry = (Map.Entry)i$.next()).getValue()).isEmpty() || ++count <= 1)) {
                }
                if (count < 2) {
                    return null;
                }
            }
            return this.idValue(id);
        }

        private void writeValue(Value object) throws IOException {
            this.json.writeStartObject();
            if (object instanceof URI) {
                this.json.writeStringField("@id", this.curie((URI)object));
                this.push(this.graph.vertex((Resource)((URI)object)));
            } else if (object instanceof BNode) {
                if (!this.memory.contains(object.stringValue())) {
                    this.memory.add(object.stringValue());
                    Vertex v = this.graph.vertex((Resource)((BNode)object));
                    this.writeVertexProperties(v.outEdges(), v);
                } else {
                    this.json.writeStringField("@id", this.bnodeValue((BNode)object));
                }
            } else {
                Literal literal = (Literal)object;
                String value = literal.stringValue();
                String lang = literal.getLanguage();
                URI datatype = literal.getDatatype();
                this.json.writeStringField("@value", value);
                if (lang != null) {
                    this.json.writeStringField("@language", lang);
                }
                if (datatype != null && !XMLSchema.STRING.equals((Object)datatype)) {
                    this.json.writeStringField("@type", this.curie(datatype));
                }
            }
            this.json.writeEndObject();
        }

        private String bnodeValue(BNode object) {
            StringBuilder builder = new StringBuilder();
            builder.append("_:");
            builder.append(object.stringValue());
            return builder.toString();
        }

        private String curie(URI predicate) {
            String value = predicate.stringValue();
            String namespace = predicate.getNamespace();
            Namespace ns = this.nsManager.findByName(namespace);
            if (ns != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(ns.getPrefix());
                builder.append(':');
                builder.append(predicate.getLocalName());
                value = builder.toString();
            }
            return value;
        }

        private String idValue(Resource resource) {
            return resource instanceof URI ? this.curie((URI)resource) : "_:" + resource.stringValue();
        }

        private void addContext() throws IOException {
            this.json.writeObjectFieldStart("@context");
            ArrayList list = new ArrayList(this.nsManager.listNamespaces());
            Collections.sort(list, new NamespaceComparator());
            for (Namespace namespace : list) {
                this.json.writeStringField(namespace.getPrefix(), namespace.getName());
            }
            this.json.writeEndObject();
        }
    }
}

