/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen;

import io.konig.core.NamespaceManager;
import io.konig.core.impl.RdfUtil;
import io.konig.schemagen.IriEnumStyle;
import io.konig.shacl.PropertyConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class Generator {
    protected NamespaceManager nsManager;
    protected IriEnumStyle iriEnumStyle = IriEnumStyle.CURIE;

    public Generator(NamespaceManager nsManager) {
        this.nsManager = nsManager;
    }

    protected String documentation(PropertyConstraint p) {
        String doc = p.getDocumentation();
        if (doc != null) {
            doc = RdfUtil.normalize((String)doc);
        }
        if (doc == null) {
            doc = "";
        }
        StringBuilder builder = new StringBuilder(doc);
        this.addHasValueDocumentation(p, builder);
        this.addKnownValueDocumentation(p, builder);
        doc = builder.toString();
        return doc.length() == 0 ? null : doc;
    }

    private void addKnownValueDocumentation(PropertyConstraint p, StringBuilder builder) {
        List possibleValues = p.getKnownValue();
        if (possibleValues != null) {
            List<String> list = this.curieList(possibleValues);
            Set hasValue = p.getHasValue();
            if (hasValue != null) {
                for (Value v : hasValue) {
                    String value = this.curie(v);
                    list.remove(value);
                }
            }
            if (!list.isEmpty()) {
                this.beginClause(builder);
                builder.append("Possible values include (but are not limited to): ");
                this.writeList(builder, list);
            }
        }
    }

    private void addHasValueDocumentation(PropertyConstraint p, StringBuilder builder) {
        Integer maxCount;
        Set hasValue = p.getHasValue();
        if (!(hasValue == null || hasValue.isEmpty() || (maxCount = p.getMaxCount()) != null && maxCount <= 1)) {
            this.beginClause(builder);
            builder.append("The set of values must include ");
            List<String> list = this.curieList(hasValue);
            if (list.size() > 1) {
                builder.append(" all of ");
            }
            this.writeList(builder, list);
        }
    }

    private void writeList(StringBuilder builder, List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                if (i == list.size() - 1) {
                    builder.append(" and ");
                } else {
                    builder.append(", ");
                }
            }
            String value = list.get(i);
            builder.append("'");
            builder.append(value);
            builder.append("'");
        }
    }

    private List<String> curieList(Collection<Value> source) {
        ArrayList<String> result = new ArrayList<String>();
        for (Value value : source) {
            if (value instanceof URI) {
                result.add(this.curie((Value)((URI)value)));
                continue;
            }
            result.add(value.stringValue());
        }
        Collections.sort(result);
        return result;
    }

    private void beginClause(StringBuilder builder) {
        if (builder.length() > 0) {
            char c = builder.charAt(builder.length() - 1);
            if (c != '.') {
                builder.append('.');
            }
            builder.append(' ');
        }
    }

    protected String curie(Value value) {
        if (!(value instanceof URI)) {
            return value.stringValue();
        }
        URI uri = (URI)value;
        String result = null;
        if (this.nsManager == null) {
            result = uri.stringValue();
        } else {
            Namespace ns = this.nsManager.findByName(uri.getNamespace());
            if (ns != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(ns.getPrefix());
                builder.append(':');
                builder.append(uri.getLocalName());
                result = builder.toString();
            } else {
                result = uri.stringValue();
            }
        }
        return result;
    }

    protected List<String> enumList(PropertyConstraint property) {
        List valueList = property.getAllowedValues();
        if (valueList != null && !valueList.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>();
            for (Value value : valueList) {
                if (value instanceof URI) {
                    URI uri = (URI)value;
                    switch (this.iriEnumStyle) {
                        case CURIE: {
                            result.add(this.curie((Value)uri));
                            break;
                        }
                        case ABSOLUTE: {
                            result.add(uri.stringValue());
                            break;
                        }
                    }
                    result.add(this.curie((Value)uri));
                    continue;
                }
                String text = value.stringValue();
                if (!this.validEnumValue(text)) continue;
                result.add(value.stringValue());
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        return null;
    }

    protected boolean validEnumValue(String text) {
        return true;
    }

    protected String strictValue(PropertyConstraint property) {
        Set valueSet;
        Integer maxCount = property.getMaxCount();
        if (maxCount != null && maxCount == 1 && (valueSet = property.getHasValue()) != null && valueSet.size() == 1) {
            String text;
            Value value = (Value)valueSet.iterator().next();
            if (value instanceof URI) {
                URI uri = (URI)value;
                switch (this.iriEnumStyle) {
                    case CURIE: {
                        return this.curie((Value)uri);
                    }
                    case ABSOLUTE: {
                        return uri.stringValue();
                    }
                    case NONE: {
                        return null;
                    }
                }
            }
            if (this.validEnumValue(text = value.stringValue())) {
                return text;
            }
        }
        return null;
    }
}

