/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.Vertex;
import io.konig.core.impl.KonigLiteral;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.vocab.VANN;
import io.konig.schemagen.SchemaGeneratorException;
import io.konig.schemagen.domain.DomainManager;
import io.konig.shacl.ShapeManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.helpers.BasicWriterSettings;
import org.openrdf.rio.turtle.TurtleWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologySummarizer {
    private static final Logger logger = LoggerFactory.getLogger(OntologySummarizer.class);

    public Graph domainModel(Graph source, ShapeManager shapeManager) {
        MemoryGraph sink = new MemoryGraph();
        DomainManager manager = new DomainManager(shapeManager, null);
        manager.load(source);
        manager.export((Graph)sink);
        return sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePrototypeModel(NamespaceManager nsManager, Graph source, ShapeManager shapeManager, File outFile) throws SchemaGeneratorException {
        MemoryGraph sink = new MemoryGraph();
        DomainManager manager = new DomainManager(shapeManager, nsManager);
        manager.load(source);
        manager.exportPrototype((Graph)sink);
        try {
            FileWriter out = new FileWriter(outFile);
            try {
                this.writeTurtle(nsManager, (Graph)sink, out);
            }
            finally {
                this.close(out);
            }
        }
        catch (IOException e) {
            throw new SchemaGeneratorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDomainModel(NamespaceManager nsManager, Graph source, ShapeManager shapeManager, File outFile) throws SchemaGeneratorException {
        Graph sink = this.domainModel(source, shapeManager);
        try {
            FileWriter out = new FileWriter(outFile);
            try {
                this.writeTurtle(nsManager, sink, out);
            }
            finally {
                this.close(out);
            }
        }
        catch (IOException e) {
            throw new SchemaGeneratorException(e);
        }
    }

    public void writeTurtle(NamespaceManager nsManager, Graph graph, Writer writer) throws SchemaGeneratorException {
        TurtleWriterFactory factory = new TurtleWriterFactory();
        RDFWriter turtle = factory.getWriter(writer);
        turtle.getWriterConfig().set(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL, (Object)true);
        try {
            turtle.startRDF();
            this.writeNamespaces(nsManager, turtle);
            this.writeStatements(graph, turtle);
            turtle.endRDF();
            writer.flush();
        }
        catch (IOException | RDFHandlerException e) {
            throw new SchemaGeneratorException(e);
        }
    }

    private void writeStatements(Graph graph, RDFWriter turtle) throws RDFHandlerException {
        for (Edge edge : graph) {
            turtle.handleStatement((Statement)edge);
        }
    }

    private void writeNamespaces(NamespaceManager nsManager, RDFWriter turtle) throws RDFHandlerException {
        ArrayList list = new ArrayList(nsManager.listNamespaces());
        Collections.sort(list, new Comparator<Namespace>(){

            @Override
            public int compare(Namespace a, Namespace b) {
                return a.getPrefix().compareTo(b.getPrefix());
            }
        });
        for (Namespace ns : list) {
            turtle.handleNamespace(ns.getPrefix(), ns.getName());
        }
    }

    public void summarize(NamespaceManager nsManager, Graph input, Writer writer) throws SchemaGeneratorException {
        try {
            this.declareNamespaces(nsManager, input);
            List list = input.v((Resource)OWL.ONTOLOGY).in(RDF.TYPE).toVertexList();
            Collections.sort(list, new OntologyComparator());
            TurtleWriterFactory factory = new TurtleWriterFactory();
            RDFWriter turtle = factory.getWriter(writer);
            turtle.getWriterConfig().set(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL, (Object)true);
            turtle.startRDF();
            for (Vertex v : list) {
                String prefix = v.getValue(VANN.preferredNamespacePrefix).stringValue();
                String namespace = v.getId().stringValue();
                turtle.handleNamespace(prefix, namespace);
            }
            for (Vertex v : list) {
                this.writeOntology(turtle, v);
            }
            turtle.endRDF();
            writer.flush();
        }
        catch (IOException | RDFHandlerException e) {
            throw new SchemaGeneratorException(e);
        }
    }

    private void writeOntology(RDFWriter turtle, Vertex v) throws RDFHandlerException {
        Set typeSet = v.outProperty(RDF.TYPE);
        for (Edge edge : typeSet) {
            turtle.handleStatement((Statement)edge);
        }
        Set outward = v.outEdges();
        ArrayList list = new ArrayList(outward);
        Collections.sort(list, new PropertyComparator());
        for (Map.Entry e : list) {
            URI predicate = (URI)e.getKey();
            if (predicate.equals((Object)RDF.TYPE)) continue;
            Set set = (Set)e.getValue();
            for (Edge edge : set) {
                turtle.handleStatement((Statement)edge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void summarize(NamespaceManager nsManager, Graph input, File outFile) throws SchemaGeneratorException {
        try {
            FileWriter writer = new FileWriter(outFile);
            try {
                this.summarize(nsManager, input, writer);
            }
            finally {
                this.close(writer);
            }
        }
        catch (IOException e) {
            throw new SchemaGeneratorException(e);
        }
    }

    private void close(Writer writer) {
        try {
            writer.close();
        }
        catch (Throwable ignore) {
            logger.warn("Failed to close writer", ignore);
        }
    }

    private void declareNamespaces(NamespaceManager nsManager, Graph graph) {
        this.declareVann(graph);
        Collection list = nsManager.listNamespaces();
        for (Namespace ns : list) {
            URI nsURI = this.uri(ns.getName());
            Vertex v = graph.vertex((Resource)nsURI);
            if (v.getValue(VANN.preferredNamespacePrefix) == null) {
                v.addProperty(VANN.preferredNamespacePrefix, (Value)this.literal(ns.getPrefix()));
            }
            if (v.hasProperty(RDF.TYPE, (Value)OWL.ONTOLOGY)) continue;
            v.addProperty(RDF.TYPE, (Value)OWL.ONTOLOGY);
        }
    }

    private void declareVann(Graph graph) {
        Vertex v = graph.vertex((Resource)VANN.NAMESPACE_URI);
        if (v.getValue(VANN.preferredNamespacePrefix) == null) {
            v.addProperty(VANN.preferredNamespacePrefix, (Value)this.literal("vann"));
        }
        if (!v.hasProperty(RDF.TYPE, (Value)OWL.ONTOLOGY)) {
            v.addProperty(RDF.TYPE, (Value)OWL.ONTOLOGY);
        }
        if (v.outProperty(RDFS.COMMENT).isEmpty()) {
            v.addProperty(RDFS.COMMENT, (Value)this.literal("A vocabulary for annotating ontologies with examples and usage notes."));
        }
        if (v.outProperty(RDFS.LABEL).isEmpty()) {
            v.addProperty(RDFS.LABEL, (Value)this.literal("Vocabulary Annotation"));
        }
    }

    private Literal literal(String value) {
        return new KonigLiteral(value, XMLSchema.STRING);
    }

    private URI uri(String name) {
        return new URIImpl(name);
    }

    private static class OntologyComparator
    implements Comparator<Vertex> {
        private OntologyComparator() {
        }

        @Override
        public int compare(Vertex a, Vertex b) {
            Value aPrefix = a.getValue(VANN.preferredNamespacePrefix);
            Value bPrefix = b.getValue(VANN.preferredNamespacePrefix);
            String aValue = aPrefix == null ? a.getId().stringValue() : aPrefix.stringValue();
            String bValue = bPrefix == null ? b.getId().stringValue() : bPrefix.stringValue();
            return aValue.compareTo(bValue);
        }
    }

    private static class PropertyComparator
    implements Comparator<Map.Entry<URI, Set<Edge>>> {
        private PropertyComparator() {
        }

        @Override
        public int compare(Map.Entry<URI, Set<Edge>> a, Map.Entry<URI, Set<Edge>> b) {
            String bLocal;
            URI aURI = a.getKey();
            URI bURI = b.getKey();
            String aLocal = aURI.getLocalName();
            int result = aLocal.compareTo(bLocal = bURI.getLocalName());
            if (result == 0) {
                result = aURI.stringValue().compareTo(bURI.stringValue());
            }
            return result;
        }
    }
}

