/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen;

import io.konig.core.Graph;
import io.konig.core.impl.KonigLiteral;
import io.konig.core.vocab.KOL;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeMediaTypeNamer;
import java.util.Collection;
import org.openrdf.model.Value;

public class ShapeMediaTypeLinker {
    private ShapeMediaTypeNamer mediaTypeNamer;

    public ShapeMediaTypeLinker(ShapeMediaTypeNamer mediaTypeNamer) {
        this.mediaTypeNamer = mediaTypeNamer;
    }

    public void assignMediaType(Shape shape, Graph graph) {
        String mediaTypeName = this.mediaTypeNamer.baseMediaTypeName(shape);
        KonigLiteral literal = new KonigLiteral(mediaTypeName);
        graph.edge(shape.getId(), KOL.mediaTypeBaseName, (Value)literal);
    }

    public void assignAll(Collection<Shape> list, Graph graph) {
        for (Shape shape : list) {
            this.assignMediaType(shape, graph);
        }
    }
}

