/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.avro;

import io.konig.core.Graph;
import io.konig.core.impl.MemoryGraph;
import io.konig.schemagen.SchemaGeneratorException;
import io.konig.schemagen.avro.AvroDatatypeMapper;
import io.konig.schemagen.avro.AvroNamer;
import io.konig.schemagen.avro.IdlWriter;
import io.konig.schemagen.avro.impl.BasicIdlWriter;
import io.konig.schemagen.avro.impl.SimpleAvroDatatypeMapper;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class AvroIdlGenerator {
    private AvroNamer namer;
    private AvroDatatypeMapper datatypeMapper = new SimpleAvroDatatypeMapper();
    private Graph graph;

    public AvroIdlGenerator(AvroNamer namer, Graph graph) {
        this.namer = namer;
        if (graph == null) {
            graph = new MemoryGraph();
        }
        this.graph = graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateAll(Collection<Shape> collection) throws SchemaGeneratorException, IOException {
        for (Shape shape : collection) {
            Resource shapeId = shape.getId();
            if (!(shapeId instanceof URI)) continue;
            URI shapeURI = (URI)shapeId;
            File idlFile = this.namer.idlFile(shapeURI);
            idlFile.getParentFile().mkdirs();
            FileWriter fileWriter = new FileWriter(idlFile);
            try {
                this.generateIDL(shape, new PrintWriter(fileWriter));
            }
            finally {
                this.close(fileWriter);
            }
        }
    }

    private void close(Writer writer) {
        try {
            writer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void generateIDL(Shape shape, PrintWriter out) throws SchemaGeneratorException {
        Worker worker = new Worker(out);
        try {
            worker.generate(shape);
            out.flush();
        }
        catch (IOException e) {
            throw new SchemaGeneratorException("Failed to generate Avro IDL for " + shape.getId().stringValue());
        }
    }

    class Worker {
        private IdlWriter avro;
        private String namespace;

        public Worker(PrintWriter out) {
            this.avro = new BasicIdlWriter(out);
        }

        void generate(Shape shape) throws IOException {
            this.generateImportStatements(shape);
            Resource shapeId = shape.getId();
            if (shapeId instanceof URI) {
                URI shapeIRI = (URI)shapeId;
                this.namespace = shapeIRI.getNamespace();
                String avroNamespace = AvroIdlGenerator.this.namer.toAvroNamespace(this.namespace);
                this.avro.writeNamespace(avroNamespace);
                String recordName = shapeIRI.getLocalName();
                this.avro.writeStartRecord(recordName);
                this.generateFields(shape);
                this.avro.writeEndRecord();
            }
        }

        private void generateImportStatements(Shape shape) throws IOException {
            ArrayList<String> importList = new ArrayList<String>();
            List list = shape.getProperty();
            for (PropertyConstraint property : list) {
                File file;
                String fileName;
                Resource valueShapeId = property.getValueShapeId();
                if (!(valueShapeId instanceof URI) || importList.contains(fileName = (file = AvroIdlGenerator.this.namer.idlFile((URI)valueShapeId)).getName())) continue;
                importList.add(fileName);
            }
            Collections.sort(importList);
            for (String file : importList) {
                this.avro.writeImport(file);
            }
        }

        private void generateFields(Shape shape) throws IOException {
            List list = shape.getProperty();
            for (PropertyConstraint property : list) {
                this.generateField(shape, property);
            }
        }

        private void generateField(Shape shape, PropertyConstraint property) throws IOException {
            Integer maxCount = property.getMaxCount();
            Integer minCount = property.getMinCount();
            URI datatype = property.getDatatype();
            String fieldName = property.getPredicate().getLocalName();
            String comment = property.getDocumentation();
            Resource valueShapeId = property.getValueShapeId();
            URI valueShape = valueShapeId instanceof URI ? (URI)valueShapeId : null;
            NodeKind nodeKind = property.getNodeKind();
            if (comment != null) {
                this.avro.writeDocumentation(comment);
            }
            if (this.equals(maxCount, 1) && this.equals(minCount, 1)) {
                String type = this.avroType(datatype, valueShape, nodeKind);
                this.avro.writeField(type, fieldName);
            } else if (this.equals(maxCount, 1) && (minCount == null || this.equals(minCount, 0))) {
                String type = this.avroType(datatype, valueShape, nodeKind);
                this.avro.writeStartUnion();
                this.avro.writeNull();
                this.avro.writeType(type);
                this.avro.writeEndUnion(fieldName);
            } else if (maxCount == null) {
                String itemType = this.avroType(datatype, valueShape, nodeKind);
                if (minCount != null && !this.equals(minCount, 0)) {
                    this.avro.writeArrayField(itemType, fieldName);
                } else {
                    this.avro.writeStartUnion();
                    this.avro.writeNull();
                    this.avro.writeArray(itemType);
                    this.avro.writeEndUnion(fieldName);
                }
            }
        }

        private String avroType(URI datatype, URI valueShape, NodeKind nodeKind) throws IOException {
            if (datatype != null) {
                return AvroIdlGenerator.this.datatypeMapper.toAvroDatatype(datatype).getTypeName();
            }
            if (valueShape != null) {
                return this.toAvroName(valueShape);
            }
            if (nodeKind == NodeKind.IRI) {
                return "string";
            }
            throw new SchemaGeneratorException("Failed to map to Avro type");
        }

        private String toAvroName(URI shapeId) {
            if (this.namespace.equals(shapeId.getNamespace())) {
                return shapeId.getLocalName();
            }
            return AvroIdlGenerator.this.namer.toAvroFullName(shapeId);
        }

        private boolean equals(Integer a, int b) {
            return a != null && a.equals(b);
        }
    }
}

