/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.avro;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.impl.TraversalImpl;
import io.konig.core.vocab.KOL;
import io.konig.core.vocab.SH;
import io.konig.schemagen.GeneratedMediaTypeTransformer;
import io.konig.schemagen.Generator;
import io.konig.schemagen.IriEnumStyle;
import io.konig.schemagen.SchemaGeneratorException;
import io.konig.schemagen.ShapeTransformer;
import io.konig.schemagen.avro.AvroDatatype;
import io.konig.schemagen.avro.AvroDatatypeMapper;
import io.konig.schemagen.avro.AvroNamer;
import io.konig.schemagen.avro.AvroSchemaListener;
import io.konig.schemagen.avro.AvroSchemaResource;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class AvroSchemaGenerator
extends Generator {
    public static final String AVRO_SCHEMA = "Avro-Schema";
    public static final String USAGE_COUNT = "Usage-Count";
    private AvroNamer namer;
    private AvroDatatypeMapper datatypeMapper;
    private boolean embedValueShape = true;
    private static final Pattern enumSymbolPattern = Pattern.compile("[A-Za-z_][A-Za-z0-9_]*");
    private ShapeTransformer shapeTransformer = new GeneratedMediaTypeTransformer("+avro");

    public AvroSchemaGenerator(AvroDatatypeMapper datatypeMapper, AvroNamer namer, NamespaceManager nsManager) {
        super(nsManager);
        this.datatypeMapper = datatypeMapper;
        this.namer = namer;
        this.nsManager = nsManager;
        this.iriEnumStyle = IriEnumStyle.NONE;
    }

    public boolean isEmbedValueShape() {
        return this.embedValueShape;
    }

    public void setEmbedValueShape(boolean embedValueShape) {
        this.embedValueShape = embedValueShape;
    }

    public void generateAll(Graph graph, AvroSchemaListener listener) throws IOException {
        List shapeList = graph.v((Resource)SH.Shape).in(RDF.TYPE).toVertexList();
        for (Vertex v : shapeList) {
            AvroSchemaResource resource = this.generateSchema(v);
            if (resource == null) continue;
            listener.handleSchema(resource);
        }
    }

    public AvroSchemaResource generateSchema(Vertex shape) throws IOException {
        Resource id = shape.getId();
        if (id instanceof URI) {
            URI uri = (URI)id;
            StringWriter writer = new StringWriter();
            JsonFactory factory = new JsonFactory();
            JsonGenerator json = factory.createGenerator((Writer)writer);
            json.useDefaultPrettyPrinter();
            String avroName = this.doGenerateSchema(uri, shape, json);
            json.flush();
            String entityBody = writer.toString();
            String schemaAddress = this.namer.toAvroSchemaURI(uri.stringValue());
            int usageCount = shape.asTraversal().in(SH.valueShape).toVertexList().size();
            AvroSchemaResource resource = new AvroSchemaResource(entityBody, avroName, usageCount);
            URIImpl schemaId = new URIImpl(schemaAddress);
            shape.getGraph().edge(id, KOL.avroSchemaRendition, (Value)schemaId);
            return resource;
        }
        return null;
    }

    @Override
    protected boolean validEnumValue(String text) {
        Matcher matcher = enumSymbolPattern.matcher(text);
        boolean result = matcher.matches();
        return result;
    }

    private String doGenerateSchema(URI uri, Vertex shape, JsonGenerator json) throws IOException {
        String avroName = this.namer.toAvroFullName(uri);
        json.writeStartObject();
        json.writeStringField("name", avroName);
        json.writeStringField("type", "record");
        this.generateFields(avroName, shape, json);
        json.writeEndObject();
        return avroName;
    }

    private void generateFields(String recordName, Vertex shapeVertex, JsonGenerator json) throws IOException {
        Shape shape = new Shape();
        Value scopeClass = shapeVertex.getValue(SH.scopeClass);
        if (scopeClass instanceof URI) {
            shape.setScopeClass((URI)scopeClass);
        }
        List propertyList = shapeVertex.asTraversal().out(SH.property).distinct().toVertexList();
        boolean fieldStart = false;
        for (Vertex p : propertyList) {
            if (!fieldStart) {
                json.writeArrayFieldStart("fields");
                fieldStart = true;
            }
            this.writeField(shape, recordName, p, json);
        }
        if (fieldStart) {
            json.writeEndArray();
        }
    }

    private void writeField(Shape shape, String recordName, Vertex propertyVertex, JsonGenerator json) throws IOException {
        PropertyConstraint property = this.asPropertyConstraint(shape, propertyVertex);
        if (property == null) {
            return;
        }
        URI predicate = property.getPredicate();
        String fieldName = predicate.getLocalName();
        json.writeStartObject();
        json.writeStringField("name", fieldName);
        Integer maxCount = property.getMaxCount();
        Integer minCount = property.getMinCount();
        String doc = this.documentation(property);
        if (doc != null) {
            json.writeStringField("doc", doc);
        }
        if (maxCount == null || maxCount > 1) {
            json.writeObjectFieldStart("type");
            json.writeStringField("type", "array");
            json.writeFieldName("items");
            this.writeType(recordName, propertyVertex, property, json);
            json.writeEndObject();
        } else if (minCount == null || minCount == 0) {
            json.writeFieldName("type");
            json.writeStartArray();
            json.writeString("null");
            this.writeType(recordName, propertyVertex, property, json);
            json.writeEndArray();
        } else {
            json.writeFieldName("type");
            this.writeType(recordName, propertyVertex, property, json);
        }
        json.writeEndObject();
    }

    private void writeType(String recordName, Vertex propertyVertex, PropertyConstraint property, JsonGenerator json) throws IOException {
        String strictValue;
        List<String> enumList = null;
        NodeKind nodeKind = property.getNodeKind();
        URI datatype = property.getDatatype();
        Resource valueShapeId = property.getValueShapeId();
        if (valueShapeId == null) {
            enumList = this.enumList(property);
        }
        if ((strictValue = this.strictValue(property)) != null) {
            json.writeStartObject();
            json.writeStringField("type", "enum");
            json.writeStringField("name", this.namer.enumName(recordName, property, propertyVertex));
            json.writeFieldName("symbols");
            json.writeStartArray();
            json.writeString(strictValue);
            json.writeEndArray();
            json.writeEndObject();
        } else if (enumList != null) {
            json.writeStartObject();
            json.writeStringField("type", "enum");
            json.writeStringField("name", this.namer.enumName(recordName, property, propertyVertex));
            json.writeFieldName("symbols");
            json.writeStartArray();
            for (String value : enumList) {
                json.writeString(value);
            }
            json.writeEndArray();
            json.writeEndObject();
        } else if (nodeKind == NodeKind.IRI) {
            json.writeString("string");
        } else if (datatype != null) {
            AvroDatatype avroDatatype = this.datatypeMapper.toAvroDatatype(datatype);
            if (avroDatatype == null) {
                throw new IOException("AvroDatatype not found: " + datatype);
            }
            String typeName = avroDatatype.getTypeName();
            String logicalType = avroDatatype.getLogicalType();
            if (logicalType == null) {
                json.writeString(typeName);
            } else {
                json.writeStartObject();
                json.writeStringField("type", typeName);
                json.writeStringField("logicalType", logicalType);
                json.writeEndObject();
            }
        } else if (valueShapeId instanceof URI) {
            URI valueShapeURI = (URI)valueShapeId;
            if (this.embedValueShape) {
                Vertex embeddedShape = propertyVertex.getGraph().getVertex((Resource)valueShapeURI);
                this.doGenerateSchema(valueShapeURI, embeddedShape, json);
            } else {
                json.writeString(this.namer.toAvroFullName((URI)valueShapeId));
            }
        }
    }

    private PropertyConstraint asPropertyConstraint(Shape shape, Vertex propertyVertex) {
        URI predicate = this.uri(propertyVertex, SH.predicate);
        if (predicate == null) {
            throw new SchemaGeneratorException("Missing predicate for PropertyConstraint");
        }
        PropertyConstraint p = new PropertyConstraint(predicate);
        p.setDatatype(this.uri(propertyVertex, SH.datatype));
        p.setNodeKind(NodeKind.fromURI((URI)this.uri(propertyVertex, SH.nodeKind)));
        p.setMinCount(this.intValue(propertyVertex, SH.minCount));
        p.setMaxCount(this.intValue(propertyVertex, SH.maxCount));
        p.setDirectValueType(this.uri(propertyVertex, SH.directType));
        p.setValueClass((Resource)this.uri(propertyVertex, SH.valueClass));
        String description = this.description(propertyVertex, predicate);
        List hasValueList = propertyVertex.asTraversal().out(SH.hasValue).toValueList();
        List<Value> allowedValues = this.allowedValues(propertyVertex);
        if (description != null) {
            p.setDocumentation(description);
        }
        for (Value value : hasValueList) {
            p.addHasValue(value);
        }
        if (allowedValues != null) {
            for (Value value : allowedValues) {
                p.addAllowedValue(value);
            }
        }
        p.setValueShapeId(this.uri(propertyVertex, SH.valueShape));
        this.addKnownValues(shape, propertyVertex, p);
        if (this.shapeTransformer != null) {
            p = this.shapeTransformer.transform(shape, p);
        }
        return p;
    }

    private void addKnownValues(Shape shape, Vertex propertyVertex, PropertyConstraint p) {
        block11: {
            List subtypes;
            URI scopeClass;
            List typeList;
            Graph graph;
            block10: {
                if (p.getValueShapeId() != null) {
                    return;
                }
                graph = propertyVertex.getGraph();
                List allowed = p.getAllowedValues();
                if (allowed != null && !allowed.isEmpty()) {
                    return;
                }
                typeList = null;
                URI predicate = p.getPredicate();
                if (!RDF.TYPE.equals((Object)predicate)) break block10;
                URI scopeClass2 = shape.getScopeClass();
                if (scopeClass2 == null) break block11;
                Vertex scopeVertex = graph.vertex((Resource)scopeClass2);
                typeList = RdfUtil.subtypeList((Vertex)scopeVertex);
                typeList.add(scopeVertex);
                for (Vertex v : typeList) {
                    p.addKnownValue((Value)v.getId());
                }
                break block11;
            }
            if (KOL.id.equals((Object)p.getPredicate()) && (scopeClass = shape.getScopeClass()) != null) {
                Vertex scopeVertex = graph.vertex((Resource)scopeClass);
                typeList = RdfUtil.subtypeList((Vertex)scopeVertex);
                typeList.add(scopeVertex);
            }
            if (typeList == null || typeList.isEmpty()) {
                typeList = propertyVertex.asTraversal().out(SH.valueClass).toVertexList();
            }
            if (!typeList.isEmpty()) {
                subtypes = RdfUtil.listSubtypes((List)typeList);
                typeList.addAll(subtypes);
            }
            if (typeList.isEmpty()) {
                typeList = propertyVertex.asTraversal().out(SH.directType).toVertexList();
            }
            if (typeList.isEmpty()) {
                typeList = propertyVertex.asTraversal().out(SH.valueShape).out(SH.scopeClass).distinct().toVertexList();
                subtypes = RdfUtil.listSubtypes((List)typeList);
                typeList.addAll(subtypes);
            }
            if (typeList.isEmpty()) {
                typeList = graph.v((Resource)p.getPredicate()).out(RDFS.RANGE).toVertexList();
            }
            TraversalImpl t = new TraversalImpl(graph, typeList);
            List list = t.in(RDF.TYPE).distinct().toVertexList();
            for (Vertex v : list) {
                p.addKnownValue((Value)v.getId());
            }
        }
    }

    private String description(Vertex propertyVertex, URI predicate) {
        String result = RdfUtil.getDescription((Vertex)propertyVertex);
        if (result == null) {
            Vertex v = propertyVertex.getGraph().getVertex((Resource)predicate);
            result = RdfUtil.getDescription((Vertex)v);
        }
        return result;
    }

    private List<Value> allowedValues(Vertex propertyVertex) {
        Vertex v = propertyVertex.asTraversal().firstVertex(SH.in);
        return v == null ? null : v.asList();
    }

    private URI uri(Vertex propertyVertex, URI predicate) {
        Value v = this.value(propertyVertex, predicate);
        return v instanceof URI ? (URI)v : null;
    }

    private Integer intValue(Vertex propertyVertex, URI predicate) {
        Value value = this.value(propertyVertex, predicate);
        return value == null ? null : new Integer(value.stringValue());
    }

    private Value value(Vertex v, URI predicate) {
        return v.asTraversal().firstValue(predicate);
    }
}

