/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.avro.impl;

import io.konig.schemagen.avro.IdlWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class BasicIdlWriter
implements IdlWriter {
    private PrintWriter out;
    private int indent = 0;
    private String tab = "  ";
    private String enumComma;
    private String unionComma;
    private boolean newLine = false;

    public BasicIdlWriter(PrintWriter out) {
        this.out = out;
    }

    private void indent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.out.write(this.tab);
        }
    }

    @Override
    public void writeDocumentation(String text) throws IOException {
        this.writeNewLine();
        text = text.replace("\r", "").replace("\t", this.tab);
        String[] lines = text.split("\\n");
        if (lines.length > 0) {
            this.out.println();
            this.indent();
            this.out.println("/**");
            for (int i = 0; i < lines.length; ++i) {
                this.indent();
                this.out.print(" * ");
                this.out.println(lines[i]);
            }
            this.indent();
            this.out.println(" */");
        }
    }

    @Override
    public void writeImport(String fileName) throws IOException {
        this.out.print("import idl \"");
        this.out.print(fileName);
        this.out.println("\";");
        this.newLine = true;
    }

    @Override
    public void writeNamespace(String namespace) throws IOException {
        this.writeNewLine();
        this.indent();
        this.out.print("@namespace(\"");
        this.out.print(namespace);
        this.out.println("\")");
    }

    private void writeNewLine() {
        if (this.newLine) {
            this.out.println();
            this.newLine = false;
        }
    }

    @Override
    public void writeStartRecord(String name) throws IOException {
        this.writeNewLine();
        this.out.print("record ");
        this.out.print(name);
        this.out.println(" {");
        ++this.indent;
    }

    @Override
    public void writeEndRecord() throws IOException {
        --this.indent;
        this.out.println("}");
    }

    @Override
    public void writeStartEnum(String name) throws IOException {
        this.out.print("enum ");
        this.out.print(name);
        this.out.print(" {");
        this.enumComma = "";
        ++this.indent;
    }

    @Override
    public void writeSymbol(String symbol) throws IOException {
        this.out.println(this.enumComma);
        this.indent();
        this.out.print(symbol);
        this.enumComma = ",";
    }

    @Override
    public void writeEndEnum() throws IOException {
        this.out.println();
        --this.indent;
        this.out.println("}");
    }

    @Override
    public void writeField(String type, String name) throws IOException {
        this.indent();
        this.out.print(type);
        this.out.print(' ');
        this.out.print(name);
        this.out.println(";");
    }

    @Override
    public void writeArrayField(String itemType, String name) throws IOException {
        this.indent();
        this.out.print("array<");
        this.out.print(itemType);
        this.out.print("> ");
        this.out.print(name);
        this.out.println(";");
    }

    @Override
    public void writeStartUnion() throws IOException {
        this.indent();
        this.out.write("union {");
        this.unionComma = "";
    }

    @Override
    public void writeType(String type) throws IOException {
        if (this.unionComma != null) {
            this.out.write(this.unionComma);
            this.unionComma = ", ";
        }
        this.out.write(type);
    }

    @Override
    public void writeEndUnion(String fieldName) throws IOException {
        this.out.write("} ");
        this.out.write(fieldName);
        this.out.println(";");
        this.unionComma = null;
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void writeNull() throws IOException {
        this.writeType("null");
    }

    @Override
    public void writeArray(String itemType) throws IOException {
        if (this.unionComma != null) {
            this.out.write(this.unionComma);
            this.unionComma = ", ";
        }
        this.out.print("array<");
        this.out.print(itemType);
        this.out.print(">");
    }

    @Override
    public void writeFieldName(String fieldName) throws IOException {
        this.out.print(' ');
        this.out.print(fieldName);
        this.out.println(';');
    }
}

