/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.avro.impl;

import io.konig.core.DatatypeRestriction;
import io.konig.core.OwlReasoner;
import io.konig.schemagen.avro.AvroDatatype;
import io.konig.schemagen.avro.AvroDatatypeMapper;
import io.konig.schemagen.avro.impl.SimpleAvroDatatypeMapper;
import org.openrdf.model.URI;

public class SmartAvroDatatypeMapper
implements AvroDatatypeMapper {
    private OwlReasoner reasoner;
    private SimpleAvroDatatypeMapper simple = new SimpleAvroDatatypeMapper();

    public SmartAvroDatatypeMapper(OwlReasoner reasoner) {
        this.reasoner = reasoner;
    }

    @Override
    public AvroDatatype toAvroDatatype(URI rdfDatatype) {
        if (rdfDatatype.getNamespace().equals("http://www.w3.org/2001/XMLSchema#")) {
            return this.simple.toAvroDatatype(rdfDatatype);
        }
        DatatypeRestriction r = this.reasoner.datatypeRestriction(rdfDatatype);
        URI datatype = r.getOnDatatype();
        if (datatype != null && "http://www.w3.org/2001/XMLSchema#".equals(datatype.getNamespace())) {
            return this.simple.toAvroDatatype(datatype);
        }
        return null;
    }
}

