/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.domain;

import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.vocab.KOL;
import io.konig.schemagen.domain.DomainClass;
import io.konig.schemagen.domain.DomainProperty;
import io.konig.schemagen.domain.ShapeProperty;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class DomainManager {
    private Map<String, Vertex> shapeMap = new HashMap<String, Vertex>();
    private Map<String, DomainClass> classMap = new HashMap<String, DomainClass>();
    private Map<String, DomainProperty> propertyMap = new HashMap<String, DomainProperty>();
    private Graph ontology;
    private ShapeManager shapeManager;
    private NamespaceManager nsManager;

    public DomainManager(ShapeManager shapeManager, NamespaceManager nsManager) {
        this.shapeManager = shapeManager;
        this.nsManager = nsManager;
    }

    public DomainClass addOwlClass(Vertex v) {
        String key = v.getId().stringValue();
        DomainClass c = this.classMap.get(key);
        if (c == null) {
            c = new DomainClass(v);
            this.classMap.put(key, c);
        }
        return c;
    }

    public DomainProperty addProperty(Vertex property) {
        String key = property.getId().stringValue();
        DomainProperty p = this.propertyMap.get(key);
        if (p == null) {
            p = new DomainProperty(property);
            this.propertyMap.put(key, p);
        }
        return p;
    }

    public void load(Graph ontology) {
        this.ontology = ontology;
        this.loadClasses(ontology);
        this.loadShapes();
        this.loadProperties(ontology, OWL.OBJECTPROPERTY);
        this.buildClassHierarchy();
    }

    private void loadShapes() {
        for (Shape shape : this.shapeManager.listShapes()) {
            List propertyList = shape.getProperty();
            for (PropertyConstraint p : propertyList) {
                URI predicate = p.getPredicate();
                DomainProperty d = this.domainProperty(predicate);
                d.addShapeProperty(shape, p);
                this.analyze(p);
            }
        }
    }

    private void analyze(PropertyConstraint p) {
        this.owlClass((Value)p.getValueClass());
        this.owlClass((Value)p.getDirectValueType());
        this.owlClass(p.getValueShape());
    }

    private void owlClass(Shape shape) {
        if (shape != null) {
            this.owlClass((Value)shape.getScopeClass());
        }
    }

    private void owlClass(Value valueClass) {
        if (valueClass instanceof URI) {
            Vertex v = this.ontology.vertex((Resource)((URI)valueClass));
            this.addOwlClass(v);
        }
    }

    private DomainProperty domainProperty(URI predicate) {
        DomainProperty p = this.propertyMap.get(predicate.stringValue());
        if (p == null) {
            p = this.addProperty(this.ontology.vertex((Resource)predicate));
        }
        return p;
    }

    private void buildClassHierarchy() {
        ArrayList<DomainClass> list = new ArrayList<DomainClass>(this.classMap.values());
        for (int i = 0; i < list.size(); ++i) {
            DomainClass c = (DomainClass)list.get(i);
            List superList = c.getClassVertex().asTraversal().out(RDFS.SUBCLASSOF).toVertexList();
            for (Vertex v : superList) {
                Resource id = v.getId();
                if (!(id instanceof URI)) continue;
                c.addSuperClass((URI)id);
                DomainClass s = this.classMap.get(id.stringValue());
                if (s != null) continue;
                this.addOwlClass(v);
            }
        }
    }

    private void loadProperties(Graph ontology, URI type) {
        List list = ontology.v((Resource)type).in(RDF.TYPE).toVertexList();
        for (Vertex v : list) {
            DomainProperty p = this.addProperty(v);
            Value domain = v.getValue(RDFS.DOMAIN);
            Value range = v.getValue(RDFS.RANGE);
            if (domain instanceof URI) {
                this.owlClass(domain);
                p.setDomain((URI)domain);
            }
            if (!(range instanceof URI)) continue;
            this.owlClass(range);
            p.setRange((URI)range);
        }
    }

    public void export(Graph sink) {
        this.exportClasses(sink);
        this.exportProperties(sink);
    }

    public void exportPrototype(Graph sink) {
        this.exportClassPrototypes(sink);
        this.exportPropertyPrototypes(sink);
    }

    private void exportPropertyPrototypes(Graph sink) {
        ArrayList<DomainProperty> list = new ArrayList<DomainProperty>(this.propertyMap.values());
        for (DomainProperty p : list) {
            URI predicate = (URI)sink.vertex(p.getVertex().getId()).getId();
            URI domain = p.getDomain();
            URI range = p.getRange();
            if (domain != null && range != null) {
                sink.edge((Resource)domain, predicate, (Value)range);
            }
            this.exportPrototypeRestrictions(p, sink);
        }
    }

    private void exportPrototypeRestrictions(DomainProperty p, Graph sink) {
        List<ShapeProperty> list = p.getShapeProperyList();
        block0: for (ShapeProperty a : list) {
            URI domain = this.domainOf(a);
            if (domain == null) continue;
            Vertex v = this.ontology.vertex((Resource)domain);
            URI range = this.rangeOf(a);
            if (range == null || range.equals((Object)p.getRange())) continue;
            for (ShapeProperty b : list) {
                URI bDomain;
                URI bRange;
                if (b == a || !range.equals((Object)(bRange = this.rangeOf(b))) || (bDomain = this.domainOf(b)) == null || !RdfUtil.isSubClassOf((Vertex)v, (Resource)bDomain)) continue;
                continue block0;
            }
            URI predicate = a.getConstraint().getPredicate();
            sink.edge((Resource)domain, predicate, (Value)range);
        }
    }

    private void exportClassPrototypes(Graph sink) {
        ArrayList<DomainClass> list = new ArrayList<DomainClass>(this.classMap.values());
        for (DomainClass c : list) {
            Resource resource = c.getClassVertex().getId();
            if (!(resource instanceof URI)) continue;
            URI subject = (URI)resource;
            String curie = RdfUtil.curie((NamespaceManager)this.nsManager, (URI)subject);
            sink.edge((Resource)subject, RDFS.LABEL, this.literal(curie));
            Set<URI> superList = c.getSuperClass();
            for (URI superClass : superList) {
                sink.edge((Resource)subject, RDFS.SUBCLASSOF, (Value)superClass);
            }
        }
    }

    private Value literal(String curie) {
        return new LiteralImpl(curie);
    }

    private void exportProperties(Graph sink) {
        ArrayList<DomainProperty> list = new ArrayList<DomainProperty>(this.propertyMap.values());
        for (DomainProperty p : list) {
            URI range;
            if (p.isDatatypeProperty()) continue;
            URI property = (URI)sink.vertex(p.getVertex().getId()).getId();
            sink.edge((Resource)property, RDF.TYPE, (Value)OWL.OBJECTPROPERTY);
            URI domain = p.derivedDomain(this.ontology);
            if (domain != null) {
                sink.edge((Resource)property, RDFS.DOMAIN, (Value)domain);
            }
            if ((range = p.derivedRange(this.ontology)) != null) {
                sink.edge((Resource)property, RDFS.RANGE, (Value)range);
            }
            this.exportRestrictions(p, sink);
        }
    }

    private void exportRestrictions(DomainProperty p, Graph sink) {
        List<ShapeProperty> list = p.getShapeProperyList();
        block0: for (ShapeProperty a : list) {
            URI domain = this.domainOf(a);
            if (domain == null) continue;
            Vertex v = this.ontology.vertex((Resource)domain);
            URI range = this.rangeOf(a);
            if (range == null || range.equals((Object)p.getRange())) continue;
            for (ShapeProperty b : list) {
                URI bDomain;
                URI bRange;
                if (b == a || !range.equals((Object)(bRange = this.rangeOf(b))) || (bDomain = this.domainOf(b)) == null || !RdfUtil.isSubClassOf((Vertex)v, (Resource)bDomain)) continue;
                continue block0;
            }
            URI predicate = a.getConstraint().getPredicate();
            Resource restriction = sink.vertex().getId();
            sink.edge((Resource)domain, RDFS.SUBCLASSOF, (Value)restriction);
            sink.edge(restriction, RDF.TYPE, (Value)OWL.RESTRICTION);
            sink.edge(restriction, OWL.ONPROPERTY, (Value)predicate);
            sink.edge(restriction, OWL.ALLVALUESFROM, (Value)range);
        }
    }

    private URI domainOf(ShapeProperty a) {
        return a.getShape().getScopeClass();
    }

    private URI rangeOf(ShapeProperty s) {
        return DomainManager.rangeOf(s, this.ontology);
    }

    static URI rangeOf(ShapeProperty s, Graph ontology) {
        URI scopeClass;
        PropertyConstraint constraint = s.getConstraint();
        Resource valueClass = constraint.getValueClass();
        URI predicate = constraint.getPredicate();
        if (predicate.equals((Object)KOL.id)) {
            return null;
        }
        if (RDF.TYPE.equals((Object)predicate)) {
            return null;
        }
        Value range = ontology.vertex((Resource)predicate).getValue(RDFS.RANGE);
        if (valueClass instanceof URI) {
            return valueClass.equals(range) ? null : (URI)valueClass;
        }
        URI directType = constraint.getDirectValueType();
        if (directType != null) {
            return directType.equals((Object)range) ? null : directType;
        }
        Shape valueShape = constraint.getValueShape();
        if (valueShape != null && (scopeClass = valueShape.getScopeClass()) != null) {
            return scopeClass.equals((Object)range) ? null : scopeClass;
        }
        if (range != null) {
            return null;
        }
        if (constraint.getNodeKind() == NodeKind.IRI || constraint.getNodeKind() == NodeKind.BlankNode) {
            return OWL.THING;
        }
        return null;
    }

    private void exportClasses(Graph sink) {
        ArrayList<DomainClass> list = new ArrayList<DomainClass>(this.classMap.values());
        for (DomainClass c : list) {
            Resource subject = c.getClassVertex().getId();
            sink.edge(subject, RDF.TYPE, (Value)OWL.CLASS);
            Set<URI> superList = c.getSuperClass();
            for (URI superClass : superList) {
                sink.edge(subject, RDFS.SUBCLASSOF, (Value)superClass);
            }
        }
    }

    private void loadClasses(Graph ontology) {
        List classList = ontology.v((Resource)OWL.CLASS).in(RDF.TYPE).toVertexList();
        for (Vertex v : classList) {
            this.addOwlClass(v);
        }
    }
}

